/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.IOConstants;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.StorageFormatFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class HiveParserStorageFormat {
    private static final StorageFormatFactory storageFormatFactory = new StorageFormatFactory();
    private final Configuration conf;
    private String inputFormat;
    private String outputFormat;
    private String storageHandler;
    private String serde;
    private String genericName;
    private final Map<String, String> serdeProps;

    public HiveParserStorageFormat(Configuration conf) {
        this.conf = conf;
        this.serdeProps = new HashMap<String, String>();
    }

    public boolean fillStorageFormat(HiveParserASTNode child) throws SemanticException {
        switch (child.getToken().getType()) {
            case 962: {
                if (child.getChildCount() < 2) {
                    throw new SemanticException("Incomplete specification of File Format. You must provide InputFormat, OutputFormat.");
                }
                this.inputFormat = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                this.outputFormat = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(1).getText());
                if (child.getChildCount() != 3) break;
                this.serde = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText());
                break;
            }
            case 940: {
                this.storageHandler = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                if (child.getChildCount() != 2) break;
                HiveParserBaseSemanticAnalyzer.readProps((HiveParserASTNode)child.getChild(1).getChild(0), this.serdeProps);
                break;
            }
            case 761: {
                HiveParserASTNode grandChild = (HiveParserASTNode)child.getChild(0);
                this.genericName = (grandChild == null ? "" : grandChild.getText()).trim().toUpperCase();
                this.processStorageFormat(this.genericName);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void processStorageFormat(String name) throws SemanticException {
        if (name.isEmpty()) {
            throw new SemanticException("File format in STORED AS clause cannot be empty");
        }
        StorageFormatDescriptor descriptor = storageFormatFactory.get(name);
        if (descriptor == null) {
            throw new SemanticException("Unrecognized file format in STORED AS clause: '" + name + "'");
        }
        this.inputFormat = descriptor.getInputFormat();
        this.outputFormat = descriptor.getOutputFormat();
        if (this.serde == null) {
            this.serde = descriptor.getSerde();
        }
        if (this.serde == null) {
            this.serde = name.equalsIgnoreCase("RCFILE") ? HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEDEFAULTRCFILESERDE) : HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEDEFAULTSERDE);
        }
    }

    public void fillDefaultStorageFormat(boolean isExternal, boolean isMaterializedView) throws SemanticException {
        if (this.inputFormat == null && this.storageHandler == null) {
            String defaultFormat;
            String defaultManagedFormat;
            if (isMaterializedView) {
                defaultFormat = defaultManagedFormat = this.conf.get("hive.materializedview.fileformat", "ORC");
                this.serde = this.conf.get("hive.materializedview.serde", "org.apache.hadoop.hive.ql.io.orc.OrcSerde");
            } else {
                defaultFormat = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEDEFAULTFILEFORMAT);
                defaultManagedFormat = this.conf.get("hive.default.fileformat.managed", "none");
            }
            if (!isExternal && !"none".equals(defaultManagedFormat)) {
                defaultFormat = defaultManagedFormat;
            }
            if (StringUtils.isNullOrWhitespaceOnly((String)defaultFormat)) {
                this.inputFormat = IOConstants.TEXTFILE_INPUT;
                this.outputFormat = IOConstants.TEXTFILE_OUTPUT;
            } else {
                this.processStorageFormat(defaultFormat);
                if (defaultFormat.equalsIgnoreCase("RCFILE")) {
                    this.serde = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEDEFAULTRCFILESERDE);
                }
            }
        }
    }

    public void setSerde(String serde) {
        this.serde = serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getStorageHandler() {
        return this.storageHandler;
    }

    public String getSerde() {
        return this.serde;
    }

    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public String getGenericName() {
        return this.genericName;
    }
}

