/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ConversionUtil;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public class HiveParserTypeConverter {
    public static RelDataType getType(RelOptCluster cluster, HiveParserRowResolver rr, List<String> neededCols) throws SemanticException {
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
        RowSchema rs = rr.getRowSchema();
        LinkedList<RelDataType> fieldTypes = new LinkedList<RelDataType>();
        LinkedList<String> fieldNames = new LinkedList<String>();
        for (ColumnInfo ci : rs.getSignature()) {
            if (neededCols != null && !neededCols.contains(ci.getInternalName())) continue;
            fieldTypes.add(HiveParserTypeConverter.convert(ci.getType(), dtFactory));
            fieldNames.add(ci.getInternalName());
        }
        return dtFactory.createStructType(fieldTypes, fieldNames);
    }

    public static RelDataType convert(TypeInfo type, RelDataTypeFactory dtFactory) throws SemanticException {
        RelDataType convertedType = null;
        switch (type.getCategory()) {
            case PRIMITIVE: {
                convertedType = HiveParserTypeConverter.convert((PrimitiveTypeInfo)type, dtFactory);
                break;
            }
            case LIST: {
                convertedType = HiveParserTypeConverter.convert((ListTypeInfo)type, dtFactory);
                break;
            }
            case MAP: {
                convertedType = HiveParserTypeConverter.convert((MapTypeInfo)type, dtFactory);
                break;
            }
            case STRUCT: {
                convertedType = HiveParserTypeConverter.convert((StructTypeInfo)type, dtFactory);
                break;
            }
            case UNION: {
                convertedType = HiveParserTypeConverter.convert((UnionTypeInfo)type, dtFactory);
            }
        }
        return convertedType;
    }

    public static RelDataType convert(PrimitiveTypeInfo type, RelDataTypeFactory dtFactory) {
        RelDataType convertedType = null;
        HiveShim hiveShim = HiveParserUtils.getSessionHiveShim();
        switch (type.getPrimitiveCategory()) {
            case VOID: {
                convertedType = dtFactory.createSqlType(SqlTypeName.NULL);
                break;
            }
            case BOOLEAN: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BOOLEAN);
                break;
            }
            case BYTE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TINYINT);
                break;
            }
            case SHORT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.SMALLINT);
                break;
            }
            case INT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.INTEGER);
                break;
            }
            case LONG: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BIGINT);
                break;
            }
            case FLOAT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.FLOAT);
                break;
            }
            case DOUBLE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.DOUBLE);
                break;
            }
            case STRING: {
                convertedType = dtFactory.createTypeWithCharsetAndCollation(dtFactory.createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                break;
            }
            case DATE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.DATE);
                break;
            }
            case TIMESTAMP: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TIMESTAMP, 9);
                break;
            }
            case BINARY: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BINARY);
                break;
            }
            case DECIMAL: {
                DecimalTypeInfo dtInf = (DecimalTypeInfo)type;
                convertedType = dtFactory.createSqlType(SqlTypeName.DECIMAL, dtInf.precision(), dtInf.scale());
                break;
            }
            case VARCHAR: {
                convertedType = dtFactory.createTypeWithCharsetAndCollation(dtFactory.createSqlType(SqlTypeName.VARCHAR, ((BaseCharTypeInfo)type).getLength()), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                break;
            }
            case CHAR: {
                convertedType = dtFactory.createTypeWithCharsetAndCollation(dtFactory.createSqlType(SqlTypeName.CHAR, ((BaseCharTypeInfo)type).getLength()), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                break;
            }
            case UNKNOWN: {
                convertedType = dtFactory.createSqlType(SqlTypeName.OTHER);
                break;
            }
            default: {
                if (hiveShim.isIntervalYearMonthType(type.getPrimitiveCategory())) {
                    convertedType = dtFactory.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, new SqlParserPos(1, 1)));
                    break;
                }
                if (!hiveShim.isIntervalDayTimeType(type.getPrimitiveCategory())) break;
                convertedType = dtFactory.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, new SqlParserPos(1, 1)));
            }
        }
        if (null == convertedType) {
            throw new RuntimeException("Unsupported Type : " + type.getTypeName());
        }
        return dtFactory.createTypeWithNullability(convertedType, true);
    }

    private static RelDataType convert(ListTypeInfo lstType, RelDataTypeFactory dtFactory) throws SemanticException {
        RelDataType elemType = HiveParserTypeConverter.convert(lstType.getListElementTypeInfo(), dtFactory);
        return dtFactory.createArrayType(elemType, -1L);
    }

    private static RelDataType convert(MapTypeInfo mapType, RelDataTypeFactory dtFactory) throws SemanticException {
        RelDataType keyType = HiveParserTypeConverter.convert(mapType.getMapKeyTypeInfo(), dtFactory);
        RelDataType valueType = HiveParserTypeConverter.convert(mapType.getMapValueTypeInfo(), dtFactory);
        return dtFactory.createMapType(keyType, valueType);
    }

    private static RelDataType convert(StructTypeInfo structType, RelDataTypeFactory dtFactory) throws SemanticException {
        ArrayList<RelDataType> fTypes = new ArrayList<RelDataType>(structType.getAllStructFieldTypeInfos().size());
        for (TypeInfo ti : structType.getAllStructFieldTypeInfos()) {
            fTypes.add(HiveParserTypeConverter.convert(ti, dtFactory));
        }
        return dtFactory.createStructType(fTypes, (List)structType.getAllStructFieldNames());
    }

    private static RelDataType convert(UnionTypeInfo unionType, RelDataTypeFactory dtFactory) throws SemanticException {
        throw new SemanticException("Union type is not supported");
    }

    public static TypeInfo convert(RelDataType rType) {
        if (rType.isStruct()) {
            return HiveParserTypeConverter.convertStructType(rType);
        }
        if (rType.getComponentType() != null) {
            return HiveParserTypeConverter.convertListType(rType);
        }
        if (rType.getKeyType() != null) {
            return HiveParserTypeConverter.convertMapType(rType);
        }
        return HiveParserTypeConverter.convertPrimitiveType(rType);
    }

    private static TypeInfo convertStructType(RelDataType rType) {
        List fTypes = rType.getFieldList().stream().map(f -> HiveParserTypeConverter.convert(f.getType())).collect(Collectors.toList());
        List fNames = rType.getFieldList().stream().map(RelDataTypeField::getName).collect(Collectors.toList());
        return TypeInfoFactory.getStructTypeInfo(fNames, fTypes);
    }

    private static TypeInfo convertMapType(RelDataType rType) {
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)HiveParserTypeConverter.convert(rType.getKeyType()), (TypeInfo)HiveParserTypeConverter.convert(rType.getValueType()));
    }

    private static TypeInfo convertListType(RelDataType rType) {
        return TypeInfoFactory.getListTypeInfo((TypeInfo)HiveParserTypeConverter.convert(rType.getComponentType()));
    }

    private static TypeInfo convertPrimitiveType(RelDataType rType) {
        HiveShim hiveShim = HiveParserUtils.getSessionHiveShim();
        switch (rType.getSqlTypeName()) {
            case BOOLEAN: {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case TINYINT: {
                return TypeInfoFactory.byteTypeInfo;
            }
            case SMALLINT: {
                return TypeInfoFactory.shortTypeInfo;
            }
            case INTEGER: {
                return TypeInfoFactory.intTypeInfo;
            }
            case BIGINT: {
                return TypeInfoFactory.longTypeInfo;
            }
            case FLOAT: {
                return TypeInfoFactory.floatTypeInfo;
            }
            case DOUBLE: {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case DATE: {
                return TypeInfoFactory.dateTypeInfo;
            }
            case TIMESTAMP: {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: {
                return hiveShim.getIntervalYearMonthTypeInfo();
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return hiveShim.getIntervalDayTimeTypeInfo();
            }
            case BINARY: {
                return TypeInfoFactory.binaryTypeInfo;
            }
            case DECIMAL: {
                return TypeInfoFactory.getDecimalTypeInfo((int)rType.getPrecision(), (int)rType.getScale());
            }
            case VARCHAR: {
                int varcharLength = rType.getPrecision();
                if (varcharLength < 1 || varcharLength > 65535) {
                    return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
                }
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharLength);
            }
            case CHAR: {
                int charLength = rType.getPrecision();
                if (charLength < 1 || charLength > 255) {
                    return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
                }
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
        }
        return TypeInfoFactory.voidTypeInfo;
    }
}

