/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.runtime.tree.CommonTree;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveDatabase;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.factories.HiveFunctionDefinitionFactory;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowPartitionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.ShowViewsOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.ddl.AddPartitionsOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterPartitionPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableOptionsOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.AlterTableSchemaOperation;
import org.apache.flink.table.operations.ddl.AlterViewAsOperation;
import org.apache.flink.table.operations.ddl.AlterViewPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterViewRenameOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableASOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropPartitionsOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;
import org.apache.flink.table.planner.delegation.hive.HiveParser;
import org.apache.flink.table.planner.delegation.hive.HiveParserCalcitePlanner;
import org.apache.flink.table.planner.delegation.hive.HiveParserDMLHelper;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserAuthorizationParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQueryState;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserStorageFormat;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserCreateViewInfo;
import org.apache.flink.table.planner.utils.OperationConverterUtils;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserDDLSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserDDLSemanticAnalyzer.class);
    private static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();
    private final Set<String> reservedPartitionValues;
    private final HiveConf conf;
    private final HiveParserQueryState queryState;
    private final HiveCatalog hiveCatalog;
    private final CatalogManager catalogManager;
    private final String currentDB;
    private final HiveParser hiveParser;
    private final HiveFunctionDefinitionFactory funcDefFactory;
    private final HiveShim hiveShim;
    private final HiveParserContext context;
    private final HiveParserDMLHelper dmlHelper;

    public static String getTypeName(HiveParserASTNode node) throws SemanticException {
        String typeName;
        int token = node.getType();
        if (token == 727) {
            throw new ValidationException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        switch (token) {
            case 703: {
                CharTypeInfo charTypeInfo = HiveASTParseUtils.getCharTypeInfo(node);
                typeName = charTypeInfo.getQualifiedName();
                break;
            }
            case 1014: {
                VarcharTypeInfo varcharTypeInfo = HiveASTParseUtils.getVarcharTypeInfo(node);
                typeName = varcharTypeInfo.getQualifiedName();
                break;
            }
            case 730: {
                DecimalTypeInfo decTypeInfo = HiveASTParseUtils.getDecimalTypeTypeInfo(node);
                typeName = decTypeInfo.getQualifiedName();
                break;
            }
            default: {
                typeName = TokenToTypeName.get(token);
            }
        }
        return typeName;
    }

    public HiveParserDDLSemanticAnalyzer(HiveParserQueryState queryState, HiveCatalog hiveCatalog, CatalogManager catalogManager, HiveParser hiveParser, HiveShim hiveShim, HiveParserContext context, HiveParserDMLHelper dmlHelper) throws SemanticException {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.hiveCatalog = hiveCatalog;
        this.currentDB = catalogManager.getCurrentDatabase();
        this.catalogManager = catalogManager;
        this.hiveParser = hiveParser;
        this.funcDefFactory = new HiveFunctionDefinitionFactory(hiveShim);
        this.hiveShim = hiveShim;
        this.context = context;
        this.dmlHelper = dmlHelper;
        this.reservedPartitionValues = new HashSet<String>();
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_ZOOKEEPER_PARTITION_NAME));
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
    }

    private Table getTable(ObjectPath tablePath) {
        try {
            return new Table(this.hiveCatalog.getHiveTable(tablePath));
        }
        catch (TableNotExistException e) {
            throw new ValidationException("Table not found", (Throwable)e);
        }
    }

    public Operation convertToOperation(HiveParserASTNode ast) throws SemanticException {
        Operation res = null;
        switch (ast.getType()) {
            case 658: {
                res = this.convertAlterTable(ast);
                break;
            }
            case 748: {
                res = this.convertDropTable(ast, null);
                break;
            }
            case 736: {
                res = this.convertDescribeTable(ast);
                break;
            }
            case 915: {
                res = this.convertShowDatabases();
                break;
            }
            case 921: {
                res = this.convertShowTables(ast, false);
                break;
            }
            case 917: {
                res = this.convertShowFunctions(ast);
                break;
            }
            case 922: {
                res = this.convertShowTables(ast, true);
                break;
            }
            case 749: {
                res = this.convertDropTable(ast, TableType.VIRTUAL_VIEW);
                break;
            }
            case 688: {
                res = this.convertAlterView(ast);
                break;
            }
            case 920: {
                res = this.convertShowPartitions(ast);
                break;
            }
            case 710: {
                res = this.convertCreateDatabase(ast);
                break;
            }
            case 743: {
                res = this.convertDropDatabase(ast);
                break;
            }
            case 951: {
                res = this.convertSwitchDatabase(ast);
                break;
            }
            case 655: {
                res = this.convertAlterDatabaseProperties(ast);
                break;
            }
            case 654: {
                res = this.convertAlterDatabaseOwner(ast);
                break;
            }
            case 653: {
                res = this.convertAlterDatabaseLocation(ast);
                break;
            }
            case 716: {
                res = this.convertCreateTable(ast);
                break;
            }
            case 717: {
                res = this.convertCreateView(ast);
                break;
            }
            case 711: {
                res = this.convertCreateFunction(ast);
                break;
            }
            case 744: {
                res = this.convertDropFunction(ast);
                break;
            }
            default: {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
            }
        }
        return res;
    }

    private Operation convertAlterTable(HiveParserASTNode input) throws SemanticException {
        Operation operation = null;
        HiveParserASTNode ast = (HiveParserASTNode)input.getChild(1);
        String[] qualified = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)input.getChild(0));
        String tableName = HiveParserBaseSemanticAnalyzer.getDotName(qualified);
        HashMap<String, String> partSpec = null;
        HiveParserASTNode partSpecNode = (HiveParserASTNode)input.getChild(2);
        if (partSpecNode != null) {
            partSpec = HiveParserDDLSemanticAnalyzer.getPartSpec(partSpecNode);
        }
        CatalogBaseTable alteredTable = this.getAlteredTable(tableName, false);
        switch (ast.getType()) {
            case 676: {
                operation = this.convertAlterTableRename(tableName, ast, false);
                break;
            }
            case 659: {
                operation = this.convertAlterTableModifyCols(alteredTable, tableName, ast, false);
                break;
            }
            case 679: {
                operation = this.convertAlterTableModifyCols(alteredTable, tableName, ast, true);
                break;
            }
            case 677: {
                operation = this.convertAlterTableChangeCol(alteredTable, qualified, ast);
                break;
            }
            case 661: {
                operation = this.convertAlterTableAddParts(qualified, ast);
                break;
            }
            case 668: {
                operation = this.convertAlterTableDropParts(qualified, ast);
                break;
            }
            case 675: {
                operation = this.convertAlterTableProps(alteredTable, tableName, null, ast, false, false);
                break;
            }
            case 669: {
                operation = this.convertAlterTableProps(alteredTable, tableName, null, ast, false, true);
                break;
            }
            case 687: {
                operation = this.convertAlterTableProps(alteredTable, tableName, partSpec, ast, false, false);
                break;
            }
            case 671: {
                operation = this.convertAlterTableFileFormat(alteredTable, ast, tableName, partSpec);
                break;
            }
            case 672: {
                operation = this.convertAlterTableLocation(alteredTable, ast, tableName, partSpec);
                break;
            }
            case 681: {
                operation = this.convertAlterTableSerde(alteredTable, ast, tableName, partSpec);
                break;
            }
            case 680: {
                operation = this.convertAlterTableSerdeProps(alteredTable, ast, tableName, partSpec);
                break;
            }
            case 660: 
            case 662: 
            case 663: 
            case 665: 
            case 666: 
            case 667: 
            case 670: 
            case 673: 
            case 674: 
            case 678: 
            case 682: 
            case 683: 
            case 684: 
            case 685: 
            case 686: {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                break;
            }
            default: {
                throw new ValidationException("Unknown AST node for ALTER TABLE: " + ast);
            }
        }
        return operation;
    }

    private Operation convertDropFunction(HiveParserASTNode ast) {
        boolean isTemporaryFunction;
        String functionName = ast.getChild(0).getText();
        boolean ifExists = ast.getFirstChildWithType(779) != null;
        boolean bl = isTemporaryFunction = ast.getFirstChildWithType(986) != null;
        if (isTemporaryFunction) {
            return new DropTempSystemFunctionOperation(functionName, ifExists);
        }
        ObjectIdentifier identifier = this.parseObjectIdentifier(functionName);
        return new DropCatalogFunctionOperation(identifier, ifExists, false);
    }

    private Operation convertCreateFunction(HiveParserASTNode ast) {
        String functionName = ast.getChild(0).getText().toLowerCase();
        boolean isTemporaryFunction = ast.getFirstChildWithType(986) != null;
        String className = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        if (isTemporaryFunction && FunctionUtils.isQualifiedFunctionName((String)functionName)) {
            throw new ValidationException("Temporary function cannot be created with a qualified name.");
        }
        if (isTemporaryFunction) {
            FunctionDefinition funcDefinition = this.funcDefFactory.createFunctionDefinition(functionName, (CatalogFunction)new CatalogFunctionImpl(className, FunctionLanguage.JAVA));
            return new CreateTempSystemFunctionOperation(functionName, false, funcDefinition);
        }
        ObjectIdentifier identifier = this.parseObjectIdentifier(functionName);
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(className, FunctionLanguage.JAVA);
        return new CreateCatalogFunctionOperation(identifier, (CatalogFunction)catalogFunction, false, false);
    }

    private Operation convertAlterView(HiveParserASTNode ast) throws SemanticException {
        Operation operation = null;
        String[] qualified = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)ast.getChild(0));
        String tableName = HiveParserBaseSemanticAnalyzer.getDotName(qualified);
        CatalogBaseTable alteredTable = this.getAlteredTable(tableName, true);
        if (ast.getChild(1).getType() == 880) {
            operation = this.convertCreateView(ast);
        } else {
            ast = (HiveParserASTNode)ast.getChild(1);
            switch (ast.getType()) {
                case 692: {
                    operation = this.convertAlterTableProps(alteredTable, tableName, null, ast, true, false);
                    break;
                }
                case 691: {
                    operation = this.convertAlterTableProps(alteredTable, tableName, null, ast, true, true);
                    break;
                }
                case 693: {
                    operation = this.convertAlterTableRename(tableName, ast, true);
                    break;
                }
                case 689: 
                case 690: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("ADD/DROP PARTITION for view is not supported");
                    break;
                }
                default: {
                    throw new ValidationException("Unknown AST node for ALTER VIEW: " + ast);
                }
            }
        }
        return operation;
    }

    private Operation convertCreateView(HiveParserASTNode ast) throws SemanticException {
        boolean isMaterialized;
        String[] qualTabName = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)ast.getChild(0));
        String dbDotTable = HiveParserBaseSemanticAnalyzer.getDotName(qualTabName);
        List<FieldSchema> cols = null;
        boolean ifNotExists = false;
        boolean isAlterViewAs = false;
        String comment = null;
        HiveParserASTNode selectStmt = null;
        HashMap<String, String> tblProps = null;
        boolean bl = isMaterialized = ast.getToken().getType() == 718;
        if (isMaterialized) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("MATERIALIZED VIEW is not supported");
        }
        HiveParserStorageFormat storageFormat = new HiveParserStorageFormat((Configuration)this.conf);
        LOG.info("Creating view " + dbDotTable + " position=" + ast.getCharPositionInLine());
        int numCh = ast.getChildCount();
        block13: for (int num = 1; num < numCh; ++num) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child)) {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("FILE FORMAT for view is not supported");
            }
            switch (child.getToken().getType()) {
                case 780: {
                    ifNotExists = true;
                    continue block13;
                }
                case 897: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("MATERIALIZED VIEW REWRITE is not supported");
                    continue block13;
                }
                case 856: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("CREATE OR REPLACE VIEW is not supported");
                    continue block13;
                }
                case 880: {
                    selectStmt = child;
                    continue block13;
                }
                case 956: {
                    cols = HiveParserBaseSemanticAnalyzer.getColumns(child);
                    continue block13;
                }
                case 961: {
                    comment = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block13;
                }
                case 965: {
                    tblProps = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)child.getChild(0));
                    continue block13;
                }
                case 968: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("ROW FORMAT for view is not supported");
                    continue block13;
                }
                case 974: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("SERDE for view is not supported");
                    continue block13;
                }
                case 963: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("LOCATION for view is not supported");
                    continue block13;
                }
                case 1015: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("PARTITION COLUMN for view is not supported");
                    continue block13;
                }
                default: {
                    throw new ValidationException("Unknown AST node for CREATE/ALTER VIEW: " + child);
                }
            }
        }
        if (ast.getToken().getType() == 688 && ast.getChild(1).getType() == 880) {
            isAlterViewAs = true;
        }
        this.queryState.setCommandType(HiveOperation.CREATEVIEW);
        HiveParserCreateViewInfo createViewInfo = new HiveParserCreateViewInfo(dbDotTable, cols, selectStmt);
        this.hiveParser.analyzeCreateView(createViewInfo, this.context, this.queryState, this.hiveShim);
        ObjectIdentifier viewIdentifier = this.parseObjectIdentifier(createViewInfo.getCompoundName());
        TableSchema schema = HiveTableUtil.createTableSchema(createViewInfo.getSchema(), Collections.emptyList(), Collections.emptySet(), null);
        HashMap<String, String> props = new HashMap<String, String>();
        if (isAlterViewAs) {
            CatalogBaseTable baseTable = this.getCatalogBaseTable(viewIdentifier);
            props.putAll(baseTable.getOptions());
            comment = baseTable.getComment();
        } else if (tblProps != null) {
            props.putAll(tblProps);
        }
        CatalogViewImpl catalogView = new CatalogViewImpl(createViewInfo.getOriginalText(), createViewInfo.getExpandedText(), schema, props, comment);
        if (isAlterViewAs) {
            return new AlterViewAsOperation(viewIdentifier, (CatalogView)catalogView);
        }
        return new CreateViewOperation(viewIdentifier, (CatalogView)catalogView, ifNotExists, false);
    }

    private Operation convertCreateTable(HiveParserASTNode ast) throws SemanticException {
        String[] qualifiedTabName = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)ast.getChild(0));
        String dbDotTab = HiveParserBaseSemanticAnalyzer.getDotName(qualifiedTabName);
        List<Object> cols = new ArrayList();
        ArrayList<FieldSchema> partCols = new ArrayList();
        ArrayList<HiveParserBaseSemanticAnalyzer.PrimaryKey> primaryKeys = new ArrayList<HiveParserBaseSemanticAnalyzer.PrimaryKey>();
        ArrayList<HiveParserBaseSemanticAnalyzer.NotNullConstraint> notNulls = new ArrayList<HiveParserBaseSemanticAnalyzer.NotNullConstraint>();
        String comment = null;
        String location = null;
        Map<String, String> tblProps = null;
        boolean ifNotExists = false;
        boolean isExt = false;
        boolean isTemporary = false;
        HiveParserASTNode selectStmt = null;
        boolean createTable = false;
        boolean ctlt = true;
        int ctas = 2;
        int commandType = 0;
        HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams rowFormatParams = new HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams();
        HiveParserStorageFormat storageFormat = new HiveParserStorageFormat((Configuration)this.conf);
        LOG.info("Creating table " + dbDotTab + " position=" + ast.getCharPositionInLine());
        int numCh = ast.getChildCount();
        block21: for (int num = 1; num < numCh; ++num) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child)) continue;
            switch (child.getToken().getType()) {
                case 780: {
                    ifNotExists = true;
                    continue block21;
                }
                case 115: {
                    isExt = true;
                    continue block21;
                }
                case 284: {
                    isTemporary = true;
                    continue block21;
                }
                case 811: {
                    if (child.getChildCount() <= 0) continue block21;
                    String likeTableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)child.getChild(0));
                    if (likeTableName != null) {
                        if (commandType == 2) {
                            throw new ValidationException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                        }
                        if (cols.size() != 0) {
                            throw new ValidationException(ErrorMsg.CTLT_COLLST_COEXISTENCE.getMsg());
                        }
                    }
                    commandType = 1;
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("CREATE TABLE LIKE is not supported");
                    continue block21;
                }
                case 880: {
                    if (commandType == 1) {
                        throw new ValidationException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                    }
                    if (cols.size() != 0) {
                        throw new ValidationException(ErrorMsg.CTAS_COLLST_COEXISTENCE.getMsg());
                    }
                    if (partCols.size() != 0) {
                        throw new ValidationException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                    }
                    if (isExt) {
                        throw new ValidationException(ErrorMsg.CTAS_EXTTBL_COEXISTENCE.getMsg());
                    }
                    commandType = 2;
                    selectStmt = child;
                    continue block21;
                }
                case 955: {
                    cols = HiveParserBaseSemanticAnalyzer.getColumns(child, true, primaryKeys, notNulls);
                    continue block21;
                }
                case 961: {
                    comment = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block21;
                }
                case 964: {
                    partCols = HiveParserBaseSemanticAnalyzer.getColumns((HiveParserASTNode)child.getChild(0), false);
                    continue block21;
                }
                case 968: {
                    rowFormatParams.analyzeRowFormat(child);
                    continue block21;
                }
                case 963: {
                    location = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block21;
                }
                case 965: {
                    tblProps = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)child.getChild(0));
                    continue block21;
                }
                case 974: {
                    child = (HiveParserASTNode)child.getChild(0);
                    storageFormat.setSerde(HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                    if (child.getChildCount() != 2) continue block21;
                    HiveParserBaseSemanticAnalyzer.readProps((HiveParserASTNode)child.getChild(1).getChild(0), storageFormat.getSerdeProps());
                    continue block21;
                }
                case 663: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Bucketed table is not supported");
                    continue block21;
                }
                case 975: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Skewed table is not supported");
                    continue block21;
                }
                default: {
                    throw new ValidationException("Unknown AST node for CREATE TABLE: " + child);
                }
            }
        }
        if (storageFormat.getStorageHandler() != null) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Storage handler table is not supported");
        }
        if (commandType == 0 || commandType == 1) {
            this.queryState.setCommandType(HiveOperation.CREATETABLE);
        } else {
            this.queryState.setCommandType(HiveOperation.CREATETABLE_AS_SELECT);
        }
        storageFormat.fillDefaultStorageFormat(isExt, false);
        if (isTemporary) {
            if (partCols.size() > 0) {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Partition columns are not supported on temporary tables");
            }
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Temporary hive table is not supported");
        }
        switch (commandType) {
            case 0: {
                tblProps = this.addDefaultProperties(tblProps);
                return this.convertCreateTable(dbDotTab, isExt, ifNotExists, isTemporary, cols, partCols, comment, location, tblProps, rowFormatParams, storageFormat, primaryKeys, notNulls);
            }
            case 1: {
                tblProps = this.addDefaultProperties(tblProps);
                throw new SemanticException("CREATE TABLE LIKE is not supported yet");
            }
            case 2: {
                tblProps = this.addDefaultProperties(tblProps);
                HiveParserCalcitePlanner calcitePlanner = this.hiveParser.createCalcitePlanner(this.context, this.queryState, this.hiveShim);
                calcitePlanner.setCtasCols(cols);
                RelNode queryRelNode = calcitePlanner.genLogicalPlan(selectStmt);
                String[] dbTblName = dbDotTab.split("\\.");
                Table destTable = new Table(Table.getEmptyTable((String)dbTblName[0], (String)dbTblName[1]));
                destTable.getSd().setCols(cols);
                CatalogSinkModifyOperation insertOperation = this.dmlHelper.createInsertOperation(queryRelNode, destTable, Collections.emptyMap(), Collections.emptyList(), false);
                CreateTableOperation createTableOperation = this.convertCreateTable(dbDotTab, isExt, ifNotExists, isTemporary, cols, partCols, comment, location, tblProps, rowFormatParams, storageFormat, primaryKeys, notNulls);
                return new CreateTableASOperation(createTableOperation, insertOperation);
            }
        }
        throw new ValidationException("Unrecognized command.");
    }

    private CreateTableOperation convertCreateTable(String compoundName, boolean isExternal, boolean ifNotExists, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, String comment, String location, Map<String, String> tblProps, HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams rowFormatParams, HiveParserStorageFormat storageFormat, List<HiveParserBaseSemanticAnalyzer.PrimaryKey> primaryKeys, List<HiveParserBaseSemanticAnalyzer.NotNullConstraint> notNullConstraints) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (tblProps != null) {
            props.putAll(tblProps);
        }
        this.markHiveConnector(props);
        if (isExternal) {
            props.put("hive.is-external", "true");
        }
        UniqueConstraint uniqueConstraint = null;
        if (primaryKeys != null && !primaryKeys.isEmpty()) {
            HiveParserBaseSemanticAnalyzer.PrimaryKey primaryKey = primaryKeys.get(0);
            byte trait = 0;
            if (primaryKey.isEnable()) {
                trait = HiveDDLUtils.enableConstraint((byte)trait);
            }
            if (primaryKey.isValidate()) {
                trait = HiveDDLUtils.validateConstraint((byte)trait);
            }
            if (primaryKey.isRely()) {
                trait = HiveDDLUtils.relyConstraint((byte)trait);
            }
            props.put("hive.pk.constraint.trait", String.valueOf(trait));
            List pkCols = primaryKeys.stream().map(HiveParserBaseSemanticAnalyzer.PrimaryKey::getPk).collect(Collectors.toList());
            String constraintName = primaryKey.getConstraintName();
            if (constraintName == null) {
                constraintName = pkCols.stream().collect(Collectors.joining("_", "PK_", ""));
            }
            uniqueConstraint = UniqueConstraint.primaryKey((String)constraintName, (List)pkCols);
        }
        ArrayList<String> notNullCols = new ArrayList<String>();
        if (!notNullConstraints.isEmpty()) {
            ArrayList<String> traits = new ArrayList<String>();
            for (HiveParserBaseSemanticAnalyzer.NotNullConstraint notNull : notNullConstraints) {
                byte trait = 0;
                if (notNull.isEnable()) {
                    trait = HiveDDLUtils.enableConstraint((byte)trait);
                }
                if (notNull.isValidate()) {
                    trait = HiveDDLUtils.validateConstraint((byte)trait);
                }
                if (notNull.isRely()) {
                    trait = HiveDDLUtils.relyConstraint((byte)trait);
                }
                traits.add(String.valueOf(trait));
                notNullCols.add(notNull.getColName());
            }
            props.put("hive.not.null.constraint.traits", String.join((CharSequence)";", traits));
            props.put("hive.not.null.cols", String.join((CharSequence)";", notNullCols));
        }
        if (rowFormatParams != null) {
            this.encodeRowFormat(rowFormatParams, props);
        }
        if (storageFormat != null) {
            this.encodeStorageFormat(storageFormat, props);
        }
        if (location != null) {
            props.put("hive.location-uri", location);
        }
        ObjectIdentifier identifier = this.parseObjectIdentifier(compoundName);
        HashSet<String> notNullColSet = new HashSet<String>(notNullCols);
        if (uniqueConstraint != null) {
            notNullColSet.addAll(uniqueConstraint.getColumns());
        }
        TableSchema tableSchema = HiveTableUtil.createTableSchema(cols, partCols, notNullColSet, uniqueConstraint);
        return new CreateTableOperation(identifier, (CatalogTable)new CatalogTableImpl(tableSchema, HiveCatalog.getFieldNames(partCols), props, comment), ifNotExists, isTemporary);
    }

    private void markHiveConnector(Map<String, String> props) {
        props.put(FactoryUtil.CONNECTOR.key(), "hive");
    }

    private void encodeRowFormat(HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams rowFormatParams, Map<String, String> props) {
        if (rowFormatParams.getFieldDelim() != null) {
            props.put("hive.serde.info.prop.field.delim", rowFormatParams.getFieldDelim());
        }
        if (rowFormatParams.getCollItemDelim() != null) {
            props.put("hive.serde.info.prop.collection.delim", rowFormatParams.getCollItemDelim());
        }
        if (rowFormatParams.getMapKeyDelim() != null) {
            props.put("hive.serde.info.prop.mapkey.delim", rowFormatParams.getMapKeyDelim());
        }
        if (rowFormatParams.getFieldEscape() != null) {
            props.put("hive.serde.info.prop.escape.delim", rowFormatParams.getFieldEscape());
        }
        if (rowFormatParams.getLineDelim() != null) {
            props.put("hive.serde.info.prop.line.delim", rowFormatParams.getLineDelim());
        }
        if (rowFormatParams.getNullFormat() != null) {
            props.put("hive.serde.info.prop.serialization.null.format", rowFormatParams.getNullFormat());
        }
    }

    private void encodeStorageFormat(HiveParserStorageFormat storageFormat, Map<String, String> props) {
        Map<String, String> serdeProps;
        String serdeName = storageFormat.getSerde();
        if (serdeName != null) {
            props.put("hive.serde.lib.class.name", serdeName);
        }
        if ((serdeProps = storageFormat.getSerdeProps()) != null) {
            for (String serdeKey : serdeProps.keySet()) {
                props.put("hive.serde.info.prop." + serdeKey, serdeProps.get(serdeKey));
            }
        }
        if (storageFormat.getInputFormat() != null) {
            props.put("hive.stored.as.input.format", storageFormat.getInputFormat());
        }
        if (storageFormat.getOutputFormat() != null) {
            props.put("hive.stored.as.output.format", storageFormat.getOutputFormat());
        }
    }

    private Operation convertAlterDatabaseProperties(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> dbProps = null;
        for (int i = 1; i < ast.getChildCount(); ++i) {
            HiveParserASTNode childNode = (HiveParserASTNode)ast.getChild(i);
            if (childNode.getToken().getType() != 724) {
                throw new ValidationException("Unknown AST node for ALTER DATABASE PROPERTIES: " + childNode);
            }
            dbProps = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)childNode.getChild(0));
        }
        CatalogDatabase originDB = this.getDatabase(dbName);
        HashMap<String, String> props = new HashMap<String, String>(originDB.getProperties());
        props.put("hive.alter.database.op", SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_PROPS.name());
        props.putAll(dbProps);
        CatalogDatabaseImpl newDB = new CatalogDatabaseImpl(props, originDB.getComment());
        return new AlterDatabaseOperation(this.catalogManager.getCurrentCatalog(), dbName, (CatalogDatabase)newDB);
    }

    private Operation convertAlterDatabaseOwner(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
        PrincipalDesc principalDesc = HiveParserAuthorizationParseUtils.getPrincipalDesc((HiveParserASTNode)ast.getChild(1));
        String nullCmdMsg = "can't be null in alter database set owner command";
        if (principalDesc.getName() == null) {
            throw new ValidationException("Owner name " + nullCmdMsg);
        }
        if (principalDesc.getType() == null) {
            throw new ValidationException("Owner type " + nullCmdMsg);
        }
        CatalogDatabase originDB = this.getDatabase(dbName);
        HashMap<String, String> props = new HashMap<String, String>(originDB.getProperties());
        props.put("hive.alter.database.op", SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_OWNER.name());
        props.put("hive.database.owner.name", principalDesc.getName());
        props.put("hive.database.owner.type", principalDesc.getType().name().toLowerCase());
        CatalogDatabaseImpl newDB = new CatalogDatabaseImpl(props, originDB.getComment());
        return new AlterDatabaseOperation(this.catalogManager.getCurrentCatalog(), dbName, (CatalogDatabase)newDB);
    }

    private Operation convertAlterDatabaseLocation(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
        String newLocation = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        CatalogDatabase originDB = this.getDatabase(dbName);
        HashMap<String, String> props = new HashMap<String, String>(originDB.getProperties());
        props.put("hive.alter.database.op", SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_LOCATION.name());
        props.put("hive.database.location-uri", newLocation);
        CatalogDatabaseImpl newDB = new CatalogDatabaseImpl(props, originDB.getComment());
        return new AlterDatabaseOperation(this.catalogManager.getCurrentCatalog(), dbName, (CatalogDatabase)newDB);
    }

    private Operation convertCreateDatabase(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifNotExists = false;
        String dbComment = null;
        String dbLocation = null;
        HashMap<String, String> dbProps = null;
        block6: for (int i = 1; i < ast.getChildCount(); ++i) {
            HiveParserASTNode childNode = (HiveParserASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 780: {
                    ifNotExists = true;
                    continue block6;
                }
                case 722: {
                    dbComment = HiveParserBaseSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                case 724: {
                    dbProps = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)childNode.getChild(0));
                    continue block6;
                }
                case 723: {
                    dbLocation = HiveParserBaseSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                default: {
                    throw new ValidationException("Unknown AST node for CREATE DATABASE: " + childNode);
                }
            }
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (dbProps != null) {
            props.putAll(dbProps);
        }
        if (dbLocation != null) {
            props.put("hive.database.location-uri", dbLocation);
        }
        CatalogDatabaseImpl catalogDatabase = new CatalogDatabaseImpl(props, dbComment);
        return new CreateDatabaseOperation(this.catalogManager.getCurrentCatalog(), dbName, (CatalogDatabase)catalogDatabase, ifNotExists);
    }

    private Operation convertDropDatabase(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = false;
        boolean ifCascade = false;
        if (null != ast.getFirstChildWithType(779)) {
            ifExists = true;
        }
        if (null != ast.getFirstChildWithType(702)) {
            ifCascade = true;
        }
        return new DropDatabaseOperation(this.catalogManager.getCurrentCatalog(), dbName, ifExists, ifCascade);
    }

    private Operation convertSwitchDatabase(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        return new UseDatabaseOperation(this.catalogManager.getCurrentCatalog(), dbName);
    }

    private Operation convertDropTable(HiveParserASTNode ast, TableType expectedType) {
        String tableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
        boolean ifExists = ast.getFirstChildWithType(779) != null;
        ObjectIdentifier identifier = this.parseObjectIdentifier(tableName);
        CatalogBaseTable baseTable = this.getCatalogBaseTable(identifier, true);
        if (expectedType == TableType.VIRTUAL_VIEW) {
            if (baseTable instanceof CatalogTable) {
                throw new ValidationException("DROP VIEW for a table is not allowed");
            }
            return new DropViewOperation(identifier, ifExists, false);
        }
        if (baseTable instanceof CatalogView) {
            throw new ValidationException("DROP TABLE for a view is not allowed");
        }
        return new DropTableOperation(identifier, ifExists, false);
    }

    private void validateAlterTableType(Table tbl) {
        if (tbl.isNonNative()) {
            throw new ValidationException(ErrorMsg.ALTER_TABLE_NON_NATIVE.getMsg(tbl.getTableName()));
        }
    }

    private Operation convertAlterTableProps(CatalogBaseTable alteredTable, String tableName, HashMap<String, String> partSpec, HiveParserASTNode ast, boolean expectView, boolean isUnset) {
        HashMap<String, String> mapProp = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)ast.getChild(0).getChild(0));
        for (Map.Entry<String, String> entry : mapProp.entrySet()) {
            if (entry.getKey().equals("numRows") || entry.getKey().equals("rawDataSize")) {
                try {
                    Long.parseLong(entry.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new ValidationException("AlterTable " + entry.getKey() + " failed with value " + entry.getValue());
                }
            }
            if (!HiveOperation.ALTERTABLE_UPDATETABLESTATS.getOperationName().equals(this.queryState.getCommandType()) && !HiveOperation.ALTERTABLE_UPDATEPARTSTATS.getOperationName().equals(this.queryState.getCommandType())) continue;
            throw new ValidationException("AlterTable UpdateStats " + entry.getKey() + " failed because the only valid keys are " + "numRows" + " and " + "rawDataSize");
        }
        if (isUnset) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Unset properties not supported");
        }
        if (expectView) {
            return this.convertAlterViewProps(alteredTable, tableName, mapProp);
        }
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_TBL_PROPS.name());
        newProps.putAll(mapProp);
        return this.convertAlterTableProps(alteredTable, tableName, partSpec, newProps);
    }

    private Operation convertAlterTableProps(CatalogBaseTable oldBaseTable, String tableName, Map<String, String> partSpec, Map<String, String> newProps) {
        ObjectIdentifier tableIdentifier = this.parseObjectIdentifier(tableName);
        CatalogTable oldTable = (CatalogTable)oldBaseTable;
        CatalogPartitionSpec catalogPartitionSpec = partSpec != null ? new CatalogPartitionSpec(partSpec) : null;
        CatalogPartition catalogPartition = partSpec != null ? this.getPartition(tableIdentifier, catalogPartitionSpec) : null;
        HashMap<String, String> props = new HashMap<String, String>();
        if (catalogPartition != null) {
            props.putAll(catalogPartition.getProperties());
            props.putAll(newProps);
            return new AlterPartitionPropertiesOperation(tableIdentifier, catalogPartitionSpec, (CatalogPartition)new CatalogPartitionImpl(props, catalogPartition.getComment()));
        }
        props.putAll(oldTable.getOptions());
        props.putAll(newProps);
        return new AlterTableOptionsOperation(tableIdentifier, oldTable.copy(props));
    }

    private Operation convertAlterTableSerdeProps(CatalogBaseTable alteredTable, HiveParserASTNode ast, String tableName, HashMap<String, String> partSpec) {
        HashMap<String, String> mapProp = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)ast.getChild(0).getChild(0));
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_SERDE_PROPS.name());
        for (String key : mapProp.keySet()) {
            newProps.put("hive.serde.info.prop." + key, mapProp.get(key));
        }
        return this.convertAlterTableProps(alteredTable, tableName, partSpec, newProps);
    }

    private Operation convertAlterTableSerde(CatalogBaseTable alteredTable, HiveParserASTNode ast, String tableName, HashMap<String, String> partSpec) {
        String serdeName = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        HashMap<String, String> mapProp = null;
        if (ast.getChildCount() > 1) {
            mapProp = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)ast.getChild(1).getChild(0));
        }
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_SERDE_PROPS.name());
        newProps.put("hive.serde.lib.class.name", serdeName);
        if (mapProp != null) {
            for (String key : mapProp.keySet()) {
                newProps.put("hive.serde.info.prop." + key, mapProp.get(key));
            }
        }
        return this.convertAlterTableProps(alteredTable, tableName, partSpec, newProps);
    }

    private Operation convertAlterTableFileFormat(CatalogBaseTable alteredTable, HiveParserASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HiveParserStorageFormat format = new HiveParserStorageFormat((Configuration)this.conf);
        HiveParserASTNode child = (HiveParserASTNode)ast.getChild(0);
        if (!format.fillStorageFormat(child)) {
            throw new ValidationException("Unknown AST node for ALTER TABLE FILEFORMAT: " + child);
        }
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_FILE_FORMAT.name());
        newProps.put("hive.storage.file-format", format.getGenericName());
        return this.convertAlterTableProps(alteredTable, tableName, partSpec, newProps);
    }

    private Operation convertAlterTableLocation(CatalogBaseTable alteredTable, HiveParserASTNode ast, String tableName, HashMap<String, String> partSpec) {
        String newLocation = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_LOCATION.name());
        newProps.put("hive.location-uri", newLocation);
        return this.convertAlterTableProps(alteredTable, tableName, partSpec, newProps);
    }

    public static HashMap<String, String> getProps(HiveParserASTNode prop) {
        LinkedHashMap<String, String> mapProp = new LinkedHashMap<String, String>();
        HiveParserBaseSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    private CatalogPartition getPartition(ObjectIdentifier tableIdentifier, CatalogPartitionSpec partitionSpec) {
        return (CatalogPartition)this.catalogManager.getPartition(tableIdentifier, partitionSpec).orElseThrow(() -> new ValidationException(String.format("Partition %s of table %s doesn't exist", partitionSpec.getPartitionSpec(), tableIdentifier)));
    }

    private Operation convertDescribeTable(HiveParserASTNode ast) {
        String tableName;
        HiveParserASTNode tableTypeExpr = (HiveParserASTNode)ast.getChild(0);
        String dbName = null;
        if (tableTypeExpr.getChild(0).getType() == 980) {
            HiveParserASTNode tableNode = (HiveParserASTNode)tableTypeExpr.getChild(0);
            if (tableNode.getChildCount() == 1) {
                tableName = tableNode.getChild(0).getText();
            } else {
                dbName = tableNode.getChild(0).getText();
                tableName = dbName + "." + tableNode.getChild(1).getText();
            }
        } else {
            throw new ValidationException(tableTypeExpr.getChild(0).getText() + " is not an expected token type");
        }
        Map<String, String> partSpec = QualifiedNameUtil.getPartitionSpec(tableTypeExpr);
        String colPath = QualifiedNameUtil.getColPath(tableTypeExpr, dbName, tableName, partSpec);
        if (partSpec != null) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("DESCRIBE PARTITION is not supported");
        }
        if (!colPath.equals(tableName)) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("DESCRIBE COLUMNS is not supported");
        }
        boolean isExt = false;
        boolean isFormatted = false;
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            isExt = descOptions == 114;
            boolean bl = isFormatted = descOptions == 129;
            if (descOptions == 220) {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("DESCRIBE PRETTY is not supported.");
            }
        }
        ObjectIdentifier tableIdentifier = this.parseObjectIdentifier(tableName);
        return new DescribeTableOperation(tableIdentifier, isExt || isFormatted);
    }

    public static HashMap<String, String> getPartSpec(HiveParserASTNode partspec) {
        if (partspec == null) {
            return null;
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            HiveParserASTNode partVal = (HiveParserASTNode)partspec.getChild(i);
            String key = partVal.getChild(0).getText();
            String val = null;
            if (partVal.getChildCount() == 3) {
                val = HiveParserBaseSemanticAnalyzer.stripQuotes(partVal.getChild(2).getText());
            } else if (partVal.getChildCount() == 2) {
                val = HiveParserBaseSemanticAnalyzer.stripQuotes(partVal.getChild(1).getText());
            }
            partSpec.put(key.toLowerCase(), val);
        }
        return partSpec;
    }

    private List<Map<String, String>> getPartitionSpecs(CommonTree ast) {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        for (int childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            HiveParserASTNode partSpecNode = (HiveParserASTNode)ast.getChild(childIndex);
            if (partSpecNode.getType() != 859) continue;
            HashMap<String, String> partSpec = HiveParserDDLSemanticAnalyzer.getPartSpec(partSpecNode);
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    private Operation convertShowPartitions(HiveParserASTNode ast) {
        String tableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        ObjectIdentifier tableIdentifier = this.parseObjectIdentifier(tableName);
        CatalogPartitionSpec spec = null;
        if (partSpec != null && !partSpec.isEmpty()) {
            spec = new CatalogPartitionSpec(new HashMap<String, String>(partSpec));
        }
        return new ShowPartitionsOperation(tableIdentifier, spec);
    }

    private Operation convertShowDatabases() {
        return new ShowDatabasesOperation();
    }

    private Operation convertShowTables(HiveParserASTNode ast, boolean expectView) {
        String dbName = this.currentDB;
        String pattern = null;
        if (ast.getChildCount() > 3) {
            throw new ValidationException("Internal error : Invalid AST " + ast.toStringTree());
        }
        switch (ast.getChildCount()) {
            case 1: {
                pattern = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 764);
                dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 764);
                dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                pattern = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                break;
            }
        }
        if (!dbName.equalsIgnoreCase(this.currentDB)) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("SHOW TABLES/VIEWS IN DATABASE is not supported");
        }
        if (pattern != null) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("SHOW TABLES/VIEWS LIKE is not supported");
        }
        return expectView ? new ShowViewsOperation() : new ShowTablesOperation();
    }

    private Operation convertShowFunctions(HiveParserASTNode ast) {
        if (ast.getChildCount() == 2) {
            assert (ast.getChild(0).getType() == 167);
            throw new ValidationException("SHOW FUNCTIONS LIKE is not supported yet");
        }
        return new ShowFunctionsOperation();
    }

    private Operation convertAlterTableRename(String sourceName, HiveParserASTNode ast, boolean expectView) throws SemanticException {
        String[] target = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)ast.getChild(0));
        String targetName = HiveParserBaseSemanticAnalyzer.getDotName(target);
        ObjectIdentifier objectIdentifier = this.parseObjectIdentifier(sourceName);
        return expectView ? new AlterViewRenameOperation(objectIdentifier, this.parseObjectIdentifier(targetName)) : new AlterTableRenameOperation(objectIdentifier, this.parseObjectIdentifier(targetName));
    }

    private Operation convertAlterTableChangeCol(CatalogBaseTable alteredTable, String[] qualified, HiveParserASTNode ast) throws SemanticException {
        String newComment = null;
        boolean first = false;
        String flagCol = null;
        boolean isCascade = false;
        String oldColName = ast.getChild(0).getText();
        String newColName = ast.getChild(1).getText();
        String newType = HiveParserBaseSemanticAnalyzer.getTypeStringFromAST((HiveParserASTNode)ast.getChild(2));
        int childCount = ast.getChildCount();
        block7: for (int i = 3; i < childCount; ++i) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(i);
            switch (child.getToken().getType()) {
                case 353: {
                    newComment = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getText());
                    continue block7;
                }
                case 664: {
                    flagCol = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    continue block7;
                }
                case 122: {
                    first = true;
                    continue block7;
                }
                case 702: {
                    isCascade = true;
                    continue block7;
                }
                case 893: {
                    continue block7;
                }
                default: {
                    throw new ValidationException("Unsupported token: " + child.getToken() + " for alter table");
                }
            }
        }
        Table tab = this.getTable(new ObjectPath(qualified[0], qualified[1]));
        SkewedInfo skewInfo = tab.getTTable().getSd().getSkewedInfo();
        if (null != skewInfo && null != skewInfo.getSkewedColNames() && skewInfo.getSkewedColNames().contains(oldColName)) {
            throw new ValidationException(oldColName + ErrorMsg.ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN.getMsg());
        }
        String tblName = HiveParserBaseSemanticAnalyzer.getDotName(qualified);
        ObjectIdentifier tableIdentifier = this.parseObjectIdentifier(tblName);
        CatalogTable oldTable = (CatalogTable)alteredTable;
        String oldName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(oldColName);
        String newName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(newColName);
        if (oldTable.getPartitionKeys().contains(oldName)) {
            throw new ValidationException("CHANGE COLUMN cannot be applied to partition columns");
        }
        TableSchema oldSchema = oldTable.getSchema();
        TableColumn.PhysicalColumn newTableColumn = TableColumn.physical((String)newName, (DataType)HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString((String)newType)));
        TableSchema newSchema = OperationConverterUtils.changeColumn((TableSchema)oldSchema, (String)oldName, (TableColumn)newTableColumn, (boolean)first, (String)flagCol);
        HashMap<String, String> props = new HashMap<String, String>(oldTable.getOptions());
        props.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.ALTER_COLUMNS.name());
        if (isCascade) {
            props.put("alter.column.cascade", "true");
        }
        return new AlterTableSchemaOperation(tableIdentifier, (CatalogTable)new CatalogTableImpl(newSchema, oldTable.getPartitionKeys(), props, oldTable.getComment()));
    }

    private Operation convertAlterTableModifyCols(CatalogBaseTable alteredTable, String tblName, HiveParserASTNode ast, boolean replace) throws SemanticException {
        List<FieldSchema> newCols = HiveParserBaseSemanticAnalyzer.getColumns((HiveParserASTNode)ast.getChild(0));
        boolean isCascade = false;
        if (null != ast.getFirstChildWithType(702)) {
            isCascade = true;
        }
        ObjectIdentifier tableIdentifier = this.parseObjectIdentifier(tblName);
        CatalogTable oldTable = (CatalogTable)alteredTable;
        HashMap<String, String> props = new HashMap<String, String>(oldTable.getOptions());
        props.put("alter.table.op", SqlAlterHiveTable.AlterTableOp.ALTER_COLUMNS.name());
        if (isCascade) {
            props.put("alter.column.cascade", "true");
        }
        TableSchema oldSchema = oldTable.getSchema();
        int numPartCol = oldTable.getPartitionKeys().size();
        TableSchema.Builder builder = TableSchema.builder();
        if (!replace) {
            List nonPartCols = oldSchema.getTableColumns().subList(0, oldSchema.getFieldCount() - numPartCol);
            Iterator iterator = nonPartCols.iterator();
            while (iterator.hasNext()) {
                TableColumn column = (TableColumn)iterator.next();
                builder.add(column);
            }
            HiveParserDDLSemanticAnalyzer.setWatermarkAndPK(builder, oldSchema);
        }
        for (FieldSchema col : newCols) {
            builder.add((TableColumn)TableColumn.physical((String)col.getName(), (DataType)HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString((String)col.getType()))));
        }
        List partCols = oldSchema.getTableColumns().subList(oldSchema.getFieldCount() - numPartCol, oldSchema.getFieldCount());
        for (TableColumn column : partCols) {
            builder.add(column);
        }
        return new AlterTableSchemaOperation(tableIdentifier, (CatalogTable)new CatalogTableImpl(builder.build(), oldTable.getPartitionKeys(), props, oldTable.getComment()));
    }

    private static void setWatermarkAndPK(TableSchema.Builder builder, TableSchema schema) {
        for (WatermarkSpec watermarkSpec : schema.getWatermarkSpecs()) {
            builder.watermark(watermarkSpec);
        }
        schema.getPrimaryKey().ifPresent(pk -> builder.primaryKey(pk.getName(), pk.getColumns().toArray(new String[0])));
    }

    private Operation convertAlterTableDropParts(String[] qualified, HiveParserASTNode ast) {
        boolean ifExists = ast.getFirstChildWithType(779) != null;
        Table tab = this.getTable(new ObjectPath(qualified[0], qualified[1]));
        ArrayList<HashMap<String, String>> partSpecs = new ArrayList<HashMap<String, String>>();
        for (int i = 0; i < ast.getChildCount(); ++i) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(i);
            if (child.getType() != 859) continue;
            partSpecs.add(HiveParserDDLSemanticAnalyzer.getPartSpec(child));
        }
        this.validateAlterTableType(tab);
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{qualified[0], qualified[1]}));
        List specs = partSpecs.stream().map(CatalogPartitionSpec::new).collect(Collectors.toList());
        return new DropPartitionsOperation(tableIdentifier, ifExists, specs);
    }

    private Operation convertAlterTableAddParts(String[] qualified, CommonTree ast) {
        boolean ifNotExists = ast.getChild(0).getType() == 780;
        Table tab = this.getTable(new ObjectPath(qualified[0], qualified[1]));
        boolean isView = tab.isView();
        this.validateAlterTableType(tab);
        int numCh = ast.getChildCount();
        int start = ifNotExists ? 1 : 0;
        String currentLocation = null;
        HashMap<String, String> currentPartSpec = null;
        ArrayList<CatalogPartitionSpec> specs = new ArrayList<CatalogPartitionSpec>();
        ArrayList<CatalogPartitionImpl> partitions = new ArrayList<CatalogPartitionImpl>();
        block4: for (int num = start; num < numCh; ++num) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 859: {
                    if (currentPartSpec != null) {
                        specs.add(new CatalogPartitionSpec(currentPartSpec));
                        HashMap<String, String> props = new HashMap<String, String>();
                        if (currentLocation != null) {
                            props.put("hive.location-uri", currentLocation);
                        }
                        partitions.add(new CatalogPartitionImpl(props, null));
                        currentLocation = null;
                    }
                    currentPartSpec = HiveParserDDLSemanticAnalyzer.getPartSpec(child);
                    this.validatePartitionValues(currentPartSpec);
                    continue block4;
                }
                case 858: {
                    if (isView) {
                        throw new ValidationException("LOCATION clause illegal for view partition");
                    }
                    currentLocation = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block4;
                }
                default: {
                    throw new ValidationException("Unknown child: " + child);
                }
            }
        }
        if (currentPartSpec != null) {
            specs.add(new CatalogPartitionSpec(currentPartSpec));
            HashMap<String, String> props = new HashMap<String, String>();
            if (currentLocation != null) {
                props.put("hive.location-uri", currentLocation);
            }
            partitions.add(new CatalogPartitionImpl(props, null));
        }
        ObjectIdentifier tableIdentifier = tab.getDbName() == null ? this.parseObjectIdentifier(tab.getTableName()) : this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{tab.getDbName(), tab.getTableName()}));
        return new AddPartitionsOperation(tableIdentifier, ifNotExists, specs, partitions);
    }

    private Operation convertAlterViewProps(CatalogBaseTable oldBaseTable, String tableName, Map<String, String> newProps) {
        ObjectIdentifier viewIdentifier = this.parseObjectIdentifier(tableName);
        CatalogView oldView = (CatalogView)oldBaseTable;
        HashMap<String, String> props = new HashMap<String, String>(oldView.getOptions());
        props.putAll(newProps);
        CatalogViewImpl newView = new CatalogViewImpl(oldView.getOriginalQuery(), oldView.getExpandedQuery(), oldView.getSchema(), props, oldView.getComment());
        return new AlterViewPropertiesOperation(viewIdentifier, (CatalogView)newView);
    }

    private CatalogBaseTable getAlteredTable(String tableName, boolean expectView) {
        ObjectIdentifier objectIdentifier = this.parseObjectIdentifier(tableName);
        CatalogBaseTable catalogBaseTable = this.getCatalogBaseTable(objectIdentifier);
        if (expectView) {
            if (catalogBaseTable instanceof CatalogTable) {
                throw new ValidationException("ALTER VIEW for a table is not allowed");
            }
        } else if (catalogBaseTable instanceof CatalogView) {
            throw new ValidationException("ALTER TABLE for a view is not allowed");
        }
        return catalogBaseTable;
    }

    private ObjectIdentifier parseObjectIdentifier(String compoundName) {
        UnresolvedIdentifier unresolvedIdentifier = this.hiveParser.parseIdentifier(compoundName);
        return this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
    }

    private CatalogDatabase getDatabase(String databaseName) {
        CatalogDatabase database;
        Catalog catalog = (Catalog)this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get();
        try {
            database = catalog.getDatabase(databaseName);
        }
        catch (DatabaseNotExistException e) {
            throw new ValidationException(String.format("Database %s not exists", databaseName), (Throwable)e);
        }
        return database;
    }

    private CatalogBaseTable getCatalogBaseTable(ObjectIdentifier tableIdentifier) {
        return this.getCatalogBaseTable(tableIdentifier, false);
    }

    private CatalogBaseTable getCatalogBaseTable(ObjectIdentifier tableIdentifier, boolean ifExists) {
        Optional optionalCatalogTable = this.catalogManager.getTable(tableIdentifier);
        if (!optionalCatalogTable.isPresent()) {
            if (ifExists) {
                return null;
            }
            throw new ValidationException(String.format("Table or View %s doesn't exist.", tableIdentifier.toString()));
        }
        if (((CatalogManager.TableLookupResult)optionalCatalogTable.get()).isTemporary()) {
            throw new ValidationException(String.format("Table or View %s is temporary.", tableIdentifier.toString()));
        }
        return ((CatalogManager.TableLookupResult)optionalCatalogTable.get()).getTable();
    }

    private void validatePartitionValues(Map<String, String> partSpec) {
        for (Map.Entry<String, String> e : partSpec.entrySet()) {
            for (String s : this.reservedPartitionValues) {
                String value = e.getValue();
                if (value == null || !value.contains(s)) continue;
                throw new ValidationException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    private Map<String, String> addDefaultProperties(Map<String, String> tblProp) {
        Map<String, String> retValue = tblProp == null ? new HashMap<String, String>() : tblProp;
        String paraString = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.NEWTABLEDEFAULTPARA);
        if (paraString != null && !paraString.isEmpty()) {
            for (String keyValuePair : paraString.split(",")) {
                String[] keyValue = keyValuePair.split("=", 2);
                if (keyValue.length != 2 || retValue.containsKey(keyValue[0])) continue;
                retValue.put(keyValue[0], keyValue[1]);
            }
        }
        return retValue;
    }

    private static void handleUnsupportedOperation(HiveParserASTNode astNode) {
        throw new ValidationException(null, (Throwable)new UnsupportedOperationException("Unsupported operation: " + astNode));
    }

    private static void handleUnsupportedOperation(String message) {
        throw new ValidationException(null, (Throwable)new UnsupportedOperationException(message));
    }

    static {
        TokenToTypeName.put(700, "boolean");
        TokenToTypeName.put(989, "tinyint");
        TokenToTypeName.put(937, "smallint");
        TokenToTypeName.put(787, "int");
        TokenToTypeName.put(697, "bigint");
        TokenToTypeName.put(762, "float");
        TokenToTypeName.put(742, "double");
        TokenToTypeName.put(942, "string");
        TokenToTypeName.put(703, "char");
        TokenToTypeName.put(1014, "varchar");
        TokenToTypeName.put(698, "binary");
        TokenToTypeName.put(725, "date");
        TokenToTypeName.put(727, "datetime");
        TokenToTypeName.put(987, "timestamp");
        TokenToTypeName.put(798, "interval_year_month");
        TokenToTypeName.put(791, "interval_day_time");
        TokenToTypeName.put(730, "decimal");
    }

    private static class QualifiedNameUtil {
        private QualifiedNameUtil() {
        }

        public static String getFullyQualifiedName(HiveParserASTNode ast) {
            if (ast.getChildCount() == 0) {
                return ast.getText();
            }
            if (ast.getChildCount() == 2) {
                return QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(1));
            }
            if (ast.getChildCount() == 3) {
                return QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(1)) + "." + QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(2));
            }
            return null;
        }

        public static String getColPath(HiveParserASTNode node, String dbName, String tableName, Map<String, String> partSpec) {
            if (node.getChildCount() == 1) {
                return tableName;
            }
            HiveParserASTNode columnNode = null;
            if (node.getChildCount() > 1) {
                columnNode = partSpec == null ? (HiveParserASTNode)node.getChild(1) : (HiveParserASTNode)node.getChild(2);
            }
            if (columnNode != null) {
                if (dbName == null) {
                    return tableName + "." + QualifiedNameUtil.getFullyQualifiedName(columnNode);
                }
                return tableName.substring(dbName.length() + 1) + "." + QualifiedNameUtil.getFullyQualifiedName(columnNode);
            }
            return tableName;
        }

        public static Map<String, String> getPartitionSpec(HiveParserASTNode ast) {
            HiveParserASTNode partNode = null;
            if (ast.getChildCount() == 1) {
                return null;
            }
            if (ast.getChildCount() > 2 && ast.getChild(1).getType() != 859) {
                throw new ValidationException(ast.getChild(1).getType() + " is not a partition specification");
            }
            if (ast.getChild(1).getType() == 859) {
                partNode = (HiveParserASTNode)ast.getChild(1);
            }
            if (partNode != null) {
                return HiveParserDDLSemanticAnalyzer.getPartSpec(partNode);
            }
            return null;
        }
    }
}

