/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.Collections;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connectors.hive.HiveSource;
import org.apache.flink.connectors.hive.HiveSourceBuilder;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.read.HiveCompactReaderFactory;
import org.apache.flink.connectors.hive.write.HiveWriterFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HiveDeserializeExceptionTest {
    @Parameterized.Parameter
    public Object object;
    @Parameterized.Parameter(value=1)
    public String name;

    @Parameterized.Parameters(name="{1}")
    public static Object[] parameters() {
        HiveWriterFactory writerFactory = new HiveWriterFactory(new JobConf(), HiveIgnoreKeyTextOutputFormat.class, new SerDeInfo(), TableSchema.builder().build(), new String[0], new Properties(), HiveShimLoader.loadHiveShim((String)HiveShimLoader.getHiveVersion()), false);
        HiveCompactReaderFactory compactReaderFactory = new HiveCompactReaderFactory(new StorageDescriptor(), new Properties(), new JobConf(), (CatalogTable)new CatalogTableImpl(TableSchema.builder().build(), Collections.emptyMap(), null), HiveShimLoader.getHiveVersion(), RowType.of((LogicalType[])new LogicalType[]{DataTypes.INT().getLogicalType()}), false);
        HiveSourceBuilder builder = new HiveSourceBuilder(new JobConf(), (ReadableConfig)new Configuration(), new ObjectPath("default", "foo"), HiveShimLoader.getHiveVersion(), (CatalogTable)new CatalogTableImpl(TableSchema.builder().field("i", DataTypes.INT()).build(), Collections.emptyMap(), null));
        builder.setPartitions(Collections.singletonList(new HiveTablePartition(new StorageDescriptor(), new Properties())));
        HiveSource hiveSource = builder.buildWithDefaultBulkFormat();
        return new Object[][]{{writerFactory, writerFactory.getClass().getSimpleName()}, {compactReaderFactory, compactReaderFactory.getClass().getSimpleName()}, {hiveSource, hiveSource.getClass().getSimpleName()}};
    }

    @Test
    public void test() throws Exception {
        ClassLoader parentLoader = this.object.getClass().getClassLoader().getParent();
        Assume.assumeTrue((parentLoader != null ? 1 : 0) != 0);
        byte[] bytes = InstantiationUtil.serializeObject((Object)this.object);
        try {
            InstantiationUtil.deserializeObject((byte[])bytes, (ClassLoader)parentLoader);
            Assert.fail((String)"Exception not thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

