/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.HiveVersionTestUtil;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.command.ClearOperation;
import org.apache.flink.table.operations.command.HelpOperation;
import org.apache.flink.table.operations.command.QuitOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.planner.delegation.hive.HiveParser;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class HiveDialectITCase {
    private TableEnvironment tableEnv;
    private HiveCatalog hiveCatalog;
    private String warehouse;

    @Before
    public void setup() {
        this.hiveCatalog = HiveTestUtils.createHiveCatalog();
        this.hiveCatalog.getHiveConf().setBoolVar(HiveConf.ConfVars.METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES, false);
        this.hiveCatalog.open();
        this.warehouse = this.hiveCatalog.getHiveConf().getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
        this.tableEnv = HiveTestUtils.createTableEnvInBatchMode();
        this.tableEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        this.tableEnv.registerCatalog(this.hiveCatalog.getName(), (Catalog)this.hiveCatalog);
        this.tableEnv.useCatalog(this.hiveCatalog.getName());
    }

    @After
    public void tearDown() {
        if (this.hiveCatalog != null) {
            this.hiveCatalog.close();
        }
        if (this.warehouse != null) {
            FileUtils.deleteDirectoryQuietly((File)new File(this.warehouse));
        }
    }

    @Test
    public void testPluggableParser() {
        TableEnvironmentInternal tableEnvInternal = (TableEnvironmentInternal)this.tableEnv;
        Parser parser = tableEnvInternal.getParser();
        Assert.assertTrue((boolean)(parser instanceof HiveParser));
        tableEnvInternal.executeSql("show databases");
        Assert.assertSame((Object)parser, (Object)tableEnvInternal.getParser());
        tableEnvInternal.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        Assert.assertNotEquals((Object)parser.getClass().getName(), (Object)tableEnvInternal.getParser().getClass().getName());
    }

    @Test
    public void testParseCommand() {
        TableEnvironmentInternal tableEnvInternal = (TableEnvironmentInternal)this.tableEnv;
        Parser parser = tableEnvInternal.getParser();
        Assert.assertTrue((boolean)(parser instanceof HiveParser));
        Assert.assertThat(parser.parse("HELP").get(0), (Matcher)CoreMatchers.instanceOf(HelpOperation.class));
        Assert.assertThat(parser.parse("clear").get(0), (Matcher)CoreMatchers.instanceOf(ClearOperation.class));
        Assert.assertThat(parser.parse("SET").get(0), (Matcher)CoreMatchers.instanceOf(SetOperation.class));
        Assert.assertThat(parser.parse("ResET").get(0), (Matcher)CoreMatchers.instanceOf(ResetOperation.class));
        Assert.assertThat(parser.parse("Exit").get(0), (Matcher)CoreMatchers.instanceOf(QuitOperation.class));
    }

    @Test
    public void testCreateDatabase() throws Exception {
        this.tableEnv.executeSql("create database db1 comment 'db1 comment'");
        Database db = this.hiveCatalog.getHiveDatabase("db1");
        Assert.assertEquals((Object)"db1 comment", (Object)db.getDescription());
        String db2Location = this.warehouse + "/db2_location";
        this.tableEnv.executeSql(String.format("create database db2 location '%s' with dbproperties('k1'='v1')", db2Location));
        db = this.hiveCatalog.getHiveDatabase("db2");
        Assert.assertEquals((Object)db2Location, (Object)HiveDialectITCase.locationPath(db.getLocationUri()));
        Assert.assertEquals((Object)"v1", db.getParameters().get("k1"));
    }

    @Test
    public void testAlterDatabase() throws Exception {
        this.tableEnv.executeSql("create database db1 with dbproperties('k1'='v1')");
        this.tableEnv.executeSql("alter database db1 set dbproperties ('k1'='v11','k2'='v2')");
        Database db = this.hiveCatalog.getHiveDatabase("db1");
        Assert.assertEquals((Object)"v11", db.getParameters().get("k1"));
        Assert.assertEquals((Object)"v2", db.getParameters().get("k2"));
        this.tableEnv.executeSql("alter database db1 set owner user user1");
        db = this.hiveCatalog.getHiveDatabase("db1");
        Assert.assertEquals((Object)"user1", (Object)db.getOwnerName());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)db.getOwnerType());
        this.tableEnv.executeSql("alter database db1 set owner role role1");
        db = this.hiveCatalog.getHiveDatabase("db1");
        Assert.assertEquals((Object)"role1", (Object)db.getOwnerName());
        Assert.assertEquals((Object)PrincipalType.ROLE, (Object)db.getOwnerType());
        if (this.hiveCatalog.getHiveVersion().compareTo("2.4.0") >= 0) {
            String newLocation = this.warehouse + "/db1_new_location";
            this.tableEnv.executeSql(String.format("alter database db1 set location '%s'", newLocation));
            db = this.hiveCatalog.getHiveDatabase("db1");
            Assert.assertEquals((Object)newLocation, (Object)HiveDialectITCase.locationPath(db.getLocationUri()));
        }
    }

    @Test
    public void testCreateTable() throws Exception {
        String location = this.warehouse + "/external_location";
        this.tableEnv.executeSql(String.format("create external table tbl1 (d decimal(10,0),ts timestamp) partitioned by (p string) location '%s' tblproperties('k1'='v1')", location));
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.hiveCatalog.getHiveTable(new ObjectPath("default", "tbl1"));
        Assert.assertEquals((Object)TableType.EXTERNAL_TABLE.toString(), (Object)hiveTable.getTableType());
        Assert.assertEquals((long)1L, (long)hiveTable.getPartitionKeysSize());
        Assert.assertEquals((Object)location, (Object)HiveDialectITCase.locationPath(hiveTable.getSd().getLocation()));
        Assert.assertEquals((Object)"v1", hiveTable.getParameters().get("k1"));
        Assert.assertFalse((boolean)hiveTable.getParameters().containsKey("hive.location-uri"));
        this.tableEnv.executeSql("create table tbl2 (s struct<ts:timestamp,bin:binary>) stored as orc");
        hiveTable = this.hiveCatalog.getHiveTable(new ObjectPath("default", "tbl2"));
        Assert.assertEquals((Object)TableType.MANAGED_TABLE.toString(), (Object)hiveTable.getTableType());
        Assert.assertEquals((Object)OrcSerde.class.getName(), (Object)hiveTable.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)OrcInputFormat.class.getName(), (Object)hiveTable.getSd().getInputFormat());
        Assert.assertEquals((Object)OrcOutputFormat.class.getName(), (Object)hiveTable.getSd().getOutputFormat());
        this.tableEnv.executeSql("create table tbl3 (m map<timestamp,binary>) partitioned by (p1 bigint,p2 tinyint) row format serde 'org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe'");
        hiveTable = this.hiveCatalog.getHiveTable(new ObjectPath("default", "tbl3"));
        Assert.assertEquals((long)2L, (long)hiveTable.getPartitionKeysSize());
        Assert.assertEquals((Object)LazyBinarySerDe.class.getName(), (Object)hiveTable.getSd().getSerdeInfo().getSerializationLib());
        this.tableEnv.executeSql("create table tbl4 (x int,y smallint) row format delimited fields terminated by '|' lines terminated by '\n'");
        hiveTable = this.hiveCatalog.getHiveTable(new ObjectPath("default", "tbl4"));
        Assert.assertEquals((Object)"|", hiveTable.getSd().getSerdeInfo().getParameters().get("field.delim"));
        Assert.assertEquals((Object)"|", hiveTable.getSd().getSerdeInfo().getParameters().get("serialization.format"));
        Assert.assertEquals((Object)"\n", hiveTable.getSd().getSerdeInfo().getParameters().get("line.delim"));
        this.tableEnv.executeSql("create table tbl5 (m map<bigint,string>) row format delimited collection items terminated by ';' map keys terminated by ':'");
        hiveTable = this.hiveCatalog.getHiveTable(new ObjectPath("default", "tbl5"));
        Assert.assertEquals((Object)";", hiveTable.getSd().getSerdeInfo().getParameters().get("colelction.delim"));
        Assert.assertEquals((Object)":", hiveTable.getSd().getSerdeInfo().getParameters().get("mapkey.delim"));
        int createdTimeForTableExists = hiveTable.getCreateTime();
        this.tableEnv.executeSql("create table if not exists tbl5 (m map<bigint,string>)");
        hiveTable = this.hiveCatalog.getHiveTable(new ObjectPath("default", "tbl5"));
        Assert.assertEquals((long)createdTimeForTableExists, (long)hiveTable.getCreateTime());
        Parser parser = ((TableEnvironmentInternal)this.tableEnv).getParser();
        DescribeTableOperation operation = (DescribeTableOperation)parser.parse("desc tbl1").get(0);
        Assert.assertFalse((boolean)operation.isExtended());
        Assert.assertEquals((Object)ObjectIdentifier.of((String)this.hiveCatalog.getName(), (String)"default", (String)"tbl1"), (Object)operation.getSqlIdentifier());
        operation = (DescribeTableOperation)parser.parse("describe default.tbl2").get(0);
        Assert.assertFalse((boolean)operation.isExtended());
        Assert.assertEquals((Object)ObjectIdentifier.of((String)this.hiveCatalog.getName(), (String)"default", (String)"tbl2"), (Object)operation.getSqlIdentifier());
        operation = (DescribeTableOperation)parser.parse("describe extended tbl3").get(0);
        Assert.assertTrue((boolean)operation.isExtended());
        Assert.assertEquals((Object)ObjectIdentifier.of((String)this.hiveCatalog.getName(), (String)"default", (String)"tbl3"), (Object)operation.getSqlIdentifier());
    }

    @Test
    public void testCreateTableWithConstraints() throws Exception {
        Assume.assumeTrue((boolean)HiveVersionTestUtil.HIVE_310_OR_LATER);
        this.tableEnv.executeSql("create table tbl (x int,y int not null disable novalidate rely,z int not null disable novalidate norely,constraint pk_name primary key (x) disable rely)");
        CatalogTable catalogTable = (CatalogTable)this.hiveCatalog.getTable(new ObjectPath("default", "tbl"));
        TableSchema tableSchema = catalogTable.getSchema();
        Assert.assertTrue((String)"PK not present", (boolean)tableSchema.getPrimaryKey().isPresent());
        Assert.assertEquals((Object)"pk_name", (Object)((UniqueConstraint)tableSchema.getPrimaryKey().get()).getName());
        Assert.assertFalse((String)"PK cannot be null", (boolean)tableSchema.getFieldDataTypes()[0].getLogicalType().isNullable());
        Assert.assertFalse((String)"RELY NOT NULL should be reflected in schema", (boolean)tableSchema.getFieldDataTypes()[1].getLogicalType().isNullable());
        Assert.assertTrue((String)"NORELY NOT NULL shouldn't be reflected in schema", (boolean)tableSchema.getFieldDataTypes()[2].getLogicalType().isNullable());
    }

    @Test
    public void testCreateTableAs() throws Exception {
        this.tableEnv.executeSql("create table src (x int,y string)");
        this.tableEnv.executeSql("create table tbl1 as select x from src group by x").await();
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.hiveCatalog.getHiveTable(new ObjectPath("default", "tbl1"));
        Assert.assertEquals((long)1L, (long)hiveTable.getSd().getCols().size());
        Assert.assertEquals((Object)"x", (Object)((FieldSchema)hiveTable.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)"int", (Object)((FieldSchema)hiveTable.getSd().getCols().get(0)).getType());
        this.tableEnv.executeSql("create table default.tbl2 stored as orc as select x,max(y) as m from src group by x order by x limit 1").await();
        hiveTable = this.hiveCatalog.getHiveTable(new ObjectPath("default", "tbl2"));
        Assert.assertEquals((long)2L, (long)hiveTable.getSd().getCols().size());
        Assert.assertEquals((Object)"x", (Object)((FieldSchema)hiveTable.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)"m", (Object)((FieldSchema)hiveTable.getSd().getCols().get(1)).getName());
        Assert.assertEquals((Object)OrcSerde.class.getName(), (Object)hiveTable.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)OrcInputFormat.class.getName(), (Object)hiveTable.getSd().getInputFormat());
        Assert.assertEquals((Object)OrcOutputFormat.class.getName(), (Object)hiveTable.getSd().getOutputFormat());
    }

    @Test
    public void testInsert() throws Exception {
        this.tableEnv.executeSql("create table src (x int,y string)");
        this.tableEnv.executeSql("insert into src values (1,'a'),(2,'b'),(3,'c')").await();
        this.tableEnv.executeSql("create table dest (x int)");
        this.tableEnv.executeSql("insert into dest select x from src").await();
        List<Row> results = HiveDialectITCase.queryResult(this.tableEnv.sqlQuery("select * from dest"));
        Assert.assertEquals((Object)"[+I[1], +I[2], +I[3]]", (Object)results.toString());
        this.tableEnv.executeSql("insert overwrite dest values (3),(4),(5)").await();
        results = HiveDialectITCase.queryResult(this.tableEnv.sqlQuery("select * from dest"));
        Assert.assertEquals((Object)"[+I[3], +I[4], +I[5]]", (Object)results.toString());
        this.tableEnv.executeSql("create table dest2 (x int) partitioned by (p1 int,p2 string)");
        this.tableEnv.executeSql("insert into dest2 partition (p1=0,p2='static') select x from src").await();
        results = HiveDialectITCase.queryResult(this.tableEnv.sqlQuery("select * from dest2 order by x,p1,p2"));
        Assert.assertEquals((Object)"[+I[1, 0, static], +I[2, 0, static], +I[3, 0, static]]", (Object)results.toString());
        this.tableEnv.executeSql("insert into dest2 partition (p1=1,p2) select x,y from src").await();
        results = HiveDialectITCase.queryResult(this.tableEnv.sqlQuery("select * from dest2 order by x,p1,p2"));
        Assert.assertEquals((Object)"[+I[1, 0, static], +I[1, 1, a], +I[2, 0, static], +I[2, 1, b], +I[3, 0, static], +I[3, 1, c]]", (Object)results.toString());
        this.tableEnv.executeSql("insert overwrite dest2 partition (p1,p2) select 1,x,y from src").await();
        results = HiveDialectITCase.queryResult(this.tableEnv.sqlQuery("select * from dest2 order by x,p1,p2"));
        Assert.assertEquals((Object)"[+I[1, 0, static], +I[1, 1, a], +I[1, 2, b], +I[1, 3, c], +I[2, 0, static], +I[2, 1, b], +I[3, 0, static], +I[3, 1, c]]", (Object)results.toString());
    }

    @Test
    public void testAlterTable() throws Exception {
        this.tableEnv.executeSql("create table tbl (x int) tblproperties('k1'='v1')");
        this.tableEnv.executeSql("alter table tbl rename to tbl1");
        ObjectPath tablePath = new ObjectPath("default", "tbl1");
        this.tableEnv.executeSql("alter table `default`.tbl1 set tblproperties ('k2'='v2')");
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        Assert.assertEquals((Object)"v1", hiveTable.getParameters().get("k1"));
        Assert.assertEquals((Object)"v2", hiveTable.getParameters().get("k2"));
        String newLocation = this.warehouse + "/tbl1_new_location";
        this.tableEnv.executeSql(String.format("alter table default.tbl1 set location '%s'", newLocation));
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        Assert.assertEquals((Object)newLocation, (Object)HiveDialectITCase.locationPath(hiveTable.getSd().getLocation()));
        this.tableEnv.executeSql("alter table tbl1 set fileformat orc");
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        Assert.assertEquals((Object)OrcSerde.class.getName(), (Object)hiveTable.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)OrcInputFormat.class.getName(), (Object)hiveTable.getSd().getInputFormat());
        Assert.assertEquals((Object)OrcOutputFormat.class.getName(), (Object)hiveTable.getSd().getOutputFormat());
        this.tableEnv.executeSql(String.format("alter table tbl1 set serde '%s' with serdeproperties('%s'='%s')", LazyBinarySerDe.class.getName(), "field.delim", "\u0001"));
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        Assert.assertEquals((Object)LazyBinarySerDe.class.getName(), (Object)hiveTable.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"\u0001", hiveTable.getSd().getSerdeInfo().getParameters().get("field.delim"));
        this.tableEnv.executeSql("alter table tbl1 replace columns (t tinyint,s smallint,i int,b bigint,f float,d double,num decimal,ts timestamp,dt date,str string,var varchar(10),ch char(123),bool boolean,bin binary)");
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        Assert.assertEquals((long)14L, (long)hiveTable.getSd().getColsSize());
        Assert.assertEquals((Object)"varchar(10)", (Object)((FieldSchema)hiveTable.getSd().getCols().get(10)).getType());
        Assert.assertEquals((Object)"char(123)", (Object)((FieldSchema)hiveTable.getSd().getCols().get(11)).getType());
        this.tableEnv.executeSql("alter table tbl1 replace columns (a array<array<int>>,s struct<f1:struct<f11:int,f12:binary>, f2:map<double,date>>,m map<char(5),map<timestamp,decimal(20,10)>>)");
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        Assert.assertEquals((Object)"array<array<int>>", (Object)((FieldSchema)hiveTable.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"struct<f1:struct<f11:int,f12:binary>,f2:map<double,date>>", (Object)((FieldSchema)hiveTable.getSd().getCols().get(1)).getType());
        Assert.assertEquals((Object)"map<char(5),map<timestamp,decimal(20,10)>>", (Object)((FieldSchema)hiveTable.getSd().getCols().get(2)).getType());
        this.tableEnv.executeSql("alter table tbl1 add columns (x int,y int)");
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        Assert.assertEquals((long)5L, (long)hiveTable.getSd().getColsSize());
        this.tableEnv.executeSql("alter table tbl1 change column x x1 string comment 'new x col'");
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        Assert.assertEquals((long)5L, (long)hiveTable.getSd().getColsSize());
        FieldSchema newField = (FieldSchema)hiveTable.getSd().getCols().get(3);
        Assert.assertEquals((Object)"x1", (Object)newField.getName());
        Assert.assertEquals((Object)"string", (Object)newField.getType());
        this.tableEnv.executeSql("alter table tbl1 change column y y int first");
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        newField = (FieldSchema)hiveTable.getSd().getCols().get(0);
        Assert.assertEquals((Object)"y", (Object)newField.getName());
        Assert.assertEquals((Object)"int", (Object)newField.getType());
        this.tableEnv.executeSql("alter table tbl1 change column x1 x2 timestamp after y");
        hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        newField = (FieldSchema)hiveTable.getSd().getCols().get(1);
        Assert.assertEquals((Object)"x2", (Object)newField.getName());
        Assert.assertEquals((Object)"timestamp", (Object)newField.getType());
        this.tableEnv.executeSql("create table tbl2 (x int) partitioned by (dt date,id bigint)");
        this.tableEnv.executeSql("alter table tbl2 add partition (dt='2020-01-23',id=1) partition (dt='2020-04-24',id=2)");
        CatalogPartitionSpec partitionSpec1 = new CatalogPartitionSpec((Map)new LinkedHashMap<String, String>(){
            {
                this.put("dt", "2020-01-23");
                this.put("id", "1");
            }
        });
        CatalogPartitionSpec partitionSpec2 = new CatalogPartitionSpec((Map)new LinkedHashMap<String, String>(){
            {
                this.put("dt", "2020-04-24");
                this.put("id", "2");
            }
        });
        this.tableEnv.executeSql("alter table tbl2 replace columns (ti tinyint,d decimal) cascade");
        ObjectPath tablePath2 = new ObjectPath("default", "tbl2");
        hiveTable = this.hiveCatalog.getHiveTable(tablePath2);
        Partition hivePartition = this.hiveCatalog.getHivePartition(hiveTable, partitionSpec1);
        Assert.assertEquals((long)2L, (long)hivePartition.getSd().getColsSize());
        hivePartition = this.hiveCatalog.getHivePartition(hiveTable, partitionSpec2);
        Assert.assertEquals((long)2L, (long)hivePartition.getSd().getColsSize());
        this.tableEnv.executeSql("alter table tbl2 add columns (ch char(5),vch varchar(9)) cascade");
        hivePartition = this.hiveCatalog.getHivePartition(hiveTable, partitionSpec1);
        Assert.assertEquals((long)4L, (long)hivePartition.getSd().getColsSize());
        hivePartition = this.hiveCatalog.getHivePartition(hiveTable, partitionSpec2);
        Assert.assertEquals((long)4L, (long)hivePartition.getSd().getColsSize());
        this.tableEnv.executeSql("alter table tbl2 change column ch ch char(10) cascade");
        hivePartition = this.hiveCatalog.getHivePartition(hiveTable, partitionSpec1);
        Assert.assertEquals((Object)"char(10)", (Object)((FieldSchema)hivePartition.getSd().getCols().get(2)).getType());
        hivePartition = this.hiveCatalog.getHivePartition(hiveTable, partitionSpec2);
        Assert.assertEquals((Object)"char(10)", (Object)((FieldSchema)hivePartition.getSd().getCols().get(2)).getType());
        this.tableEnv.executeSql("alter table tbl2 change column vch str string first cascade");
        hivePartition = this.hiveCatalog.getHivePartition(hiveTable, partitionSpec1);
        Assert.assertEquals((Object)"str", (Object)((FieldSchema)hivePartition.getSd().getCols().get(0)).getName());
        hivePartition = this.hiveCatalog.getHivePartition(hiveTable, partitionSpec2);
        Assert.assertEquals((Object)"str", (Object)((FieldSchema)hivePartition.getSd().getCols().get(0)).getName());
    }

    @Test
    public void testAlterPartition() throws Exception {
        this.tableEnv.executeSql("create table tbl (x tinyint,y string) partitioned by (p1 bigint,p2 date)");
        this.tableEnv.executeSql("alter table tbl add partition (p1=1000,p2='2020-05-01') partition (p1=2000,p2='2020-01-01')");
        CatalogPartitionSpec spec1 = new CatalogPartitionSpec((Map)new LinkedHashMap<String, String>(){
            {
                this.put("p1", "1000");
                this.put("p2", "2020-05-01");
            }
        });
        CatalogPartitionSpec spec2 = new CatalogPartitionSpec((Map)new LinkedHashMap<String, String>(){
            {
                this.put("p1", "2000");
                this.put("p2", "2020-01-01");
            }
        });
        ObjectPath tablePath = new ObjectPath("default", "tbl");
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        String location = this.warehouse + "/new_part_location";
        this.tableEnv.executeSql(String.format("alter table tbl partition (p1=1000,p2='2020-05-01') set location '%s'", location));
        Partition partition = this.hiveCatalog.getHivePartition(hiveTable, spec1);
        Assert.assertEquals((Object)location, (Object)HiveDialectITCase.locationPath(partition.getSd().getLocation()));
        this.tableEnv.executeSql("alter table tbl partition (p1=2000,p2='2020-01-01') set fileformat rcfile");
        partition = this.hiveCatalog.getHivePartition(hiveTable, spec2);
        Assert.assertEquals((Object)LazyBinaryColumnarSerDe.class.getName(), (Object)partition.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)RCFileInputFormat.class.getName(), (Object)partition.getSd().getInputFormat());
        Assert.assertEquals((Object)RCFileOutputFormat.class.getName(), (Object)partition.getSd().getOutputFormat());
        this.tableEnv.executeSql(String.format("alter table tbl partition (p1=1000,p2='2020-05-01') set serde '%s' with serdeproperties('%s'='%s')", LazyBinarySerDe.class.getName(), "line.delim", "\n"));
        partition = this.hiveCatalog.getHivePartition(hiveTable, spec1);
        Assert.assertEquals((Object)LazyBinarySerDe.class.getName(), (Object)partition.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"\n", partition.getSd().getSerdeInfo().getParameters().get("line.delim"));
    }

    @Test
    public void testView() throws Exception {
        this.tableEnv.executeSql("create table tbl (x int,y string)");
        this.tableEnv.executeSql("create view v(vx) comment 'v comment' tblproperties ('k1'='v1') as select x from tbl");
        ObjectPath viewPath = new ObjectPath("default", "v");
        CatalogBaseTable catalogBaseTable = this.hiveCatalog.getTable(viewPath);
        Assert.assertTrue((boolean)(catalogBaseTable instanceof CatalogView));
        Assert.assertEquals((Object)"vx", (Object)((Schema.UnresolvedColumn)catalogBaseTable.getUnresolvedSchema().getColumns().get(0)).getName());
        Assert.assertEquals((Object)"v1", catalogBaseTable.getOptions().get("k1"));
        this.tableEnv.executeSql("alter view v set tblproperties ('k1'='v11')");
        catalogBaseTable = this.hiveCatalog.getTable(viewPath);
        Assert.assertEquals((Object)"v11", catalogBaseTable.getOptions().get("k1"));
        this.tableEnv.executeSql("alter view v as select y from tbl");
        catalogBaseTable = this.hiveCatalog.getTable(viewPath);
        Assert.assertEquals((Object)"y", (Object)((Schema.UnresolvedColumn)catalogBaseTable.getUnresolvedSchema().getColumns().get(0)).getName());
        this.tableEnv.executeSql("alter view v rename to v1");
        viewPath = new ObjectPath("default", "v1");
        Assert.assertTrue((boolean)this.hiveCatalog.tableExists(viewPath));
        this.tableEnv.executeSql("drop view v1");
        Assert.assertFalse((boolean)this.hiveCatalog.tableExists(viewPath));
    }

    @Test
    public void testFunction() throws Exception {
        this.tableEnv.executeSql(String.format("create function default.my_abs as '%s'", GenericUDFAbs.class.getName()));
        List functions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show functions").collect());
        Assert.assertTrue((boolean)functions.toString().contains("my_abs"));
        this.tableEnv.executeSql("create table src(x int)");
        this.tableEnv.executeSql("insert into src values (1),(-1)").await();
        Assert.assertEquals((Object)"[+I[1], +I[1]]", (Object)HiveDialectITCase.queryResult(this.tableEnv.sqlQuery("select my_abs(x) from src")).toString());
        this.tableEnv.executeSql("drop function my_abs");
        Assert.assertFalse((boolean)this.hiveCatalog.functionExists(new ObjectPath("default", "my_abs")));
        this.tableEnv.executeSql("drop function if exists foo");
    }

    @Test
    public void testTemporaryFunction() throws Exception {
        this.tableEnv.executeSql(String.format("create temporary function temp_abs as '%s'", GenericUDFAbs.class.getName()));
        Object[] functions = this.tableEnv.listUserDefinedFunctions();
        Assert.assertArrayEquals((Object[])new String[]{"temp_abs"}, (Object[])functions);
        this.tableEnv.executeSql("create table src(x int)");
        this.tableEnv.executeSql("insert into src values (1),(-1)").await();
        Assert.assertEquals((Object)"[+I[1], +I[1]]", (Object)HiveDialectITCase.queryResult(this.tableEnv.sqlQuery("select temp_abs(x) from src")).toString());
        this.tableEnv.executeSql("create database db1");
        this.tableEnv.useDatabase("db1");
        Assert.assertEquals((Object)"[+I[1], +I[1]]", (Object)HiveDialectITCase.queryResult(this.tableEnv.sqlQuery("select temp_abs(x) from `default`.src")).toString());
        this.tableEnv.executeSql("drop temporary function temp_abs");
        functions = this.tableEnv.listUserDefinedFunctions();
        Assert.assertEquals((long)0L, (long)functions.length);
        this.tableEnv.executeSql("drop temporary function if exists foo");
    }

    @Test
    public void testCatalog() {
        List catalogs = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show catalogs").collect());
        Assert.assertEquals((long)2L, (long)catalogs.size());
        this.tableEnv.executeSql("use catalog default_catalog");
        List databases = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show databases").collect());
        Assert.assertEquals((long)1L, (long)databases.size());
        Assert.assertEquals((Object)"+I[default_database]", (Object)((Row)databases.get(0)).toString());
        String catalogName = ((Row)this.tableEnv.executeSql("show current catalog").collect().next()).toString();
        Assert.assertEquals((Object)"+I[default_catalog]", (Object)catalogName);
        String databaseName = ((Row)this.tableEnv.executeSql("show current database").collect().next()).toString();
        Assert.assertEquals((Object)"+I[default_database]", (Object)databaseName);
    }

    @Test
    public void testAddDropPartitions() throws Exception {
        this.tableEnv.executeSql("create table tbl (x int,y binary) partitioned by (dt date,country string)");
        this.tableEnv.executeSql("alter table tbl add partition (dt='2020-04-30',country='china') partition (dt='2020-04-30',country='us')");
        ObjectPath tablePath = new ObjectPath("default", "tbl");
        Assert.assertEquals((long)2L, (long)this.hiveCatalog.listPartitions(tablePath).size());
        String partLocation = this.warehouse + "/part3_location";
        this.tableEnv.executeSql(String.format("alter table tbl add partition (dt='2020-05-01',country='belgium') location '%s'", partLocation));
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.hiveCatalog.getHiveTable(tablePath);
        CatalogPartitionSpec spec = new CatalogPartitionSpec((Map)new LinkedHashMap<String, String>(){
            {
                this.put("dt", "2020-05-01");
                this.put("country", "belgium");
            }
        });
        Partition hivePartition = this.hiveCatalog.getHivePartition(hiveTable, spec);
        Assert.assertEquals((Object)partLocation, (Object)HiveDialectITCase.locationPath(hivePartition.getSd().getLocation()));
        this.tableEnv.executeSql("alter table tbl drop partition (dt='2020-04-30',country='china'),partition (dt='2020-05-01',country='belgium')");
        Assert.assertEquals((long)1L, (long)this.hiveCatalog.listPartitions(tablePath).size());
    }

    @Test
    public void testShowPartitions() throws Exception {
        this.tableEnv.executeSql("create table tbl (x int,y binary) partitioned by (dt date, country string)");
        this.tableEnv.executeSql("alter table tbl add partition (dt='2020-04-30',country='china') partition (dt='2020-04-30',country='us')");
        ObjectPath tablePath = new ObjectPath("default", "tbl");
        Assert.assertEquals((long)2L, (long)this.hiveCatalog.listPartitions(tablePath).size());
        List partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl").collect());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30/country=china"));
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30/country=us"));
        partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl partition (dt='2020-04-30')").collect());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30/country=china"));
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30/country=us"));
        partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl partition (country='china')").collect());
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30/country=china"));
        partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl partition (dt='2020-04-30',country='china')").collect());
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30/country=china"));
        partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl partition (dt='2020-05-01',country='japan')").collect());
        Assert.assertEquals((long)0L, (long)partitions.size());
        try {
            CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl partition (de='2020-04-30',city='china')").collect());
        }
        catch (TableException e) {
            Assert.assertEquals((Object)String.format("Could not execute SHOW PARTITIONS %s.%s PARTITION (de=2020-04-30, city=china)", this.hiveCatalog.getName(), tablePath), (Object)e.getMessage());
        }
        this.tableEnv.executeSql("alter table tbl drop partition (dt='2020-04-30',country='china'),partition (dt='2020-04-30',country='us')");
        Assert.assertEquals((long)0L, (long)this.hiveCatalog.listPartitions(tablePath).size());
        this.tableEnv.executeSql("drop table tbl");
        this.tableEnv.executeSql("create table tbl (x int,y binary) partitioned by (dt timestamp, country string)");
        this.tableEnv.executeSql("alter table tbl add partition (dt='2020-04-30 01:02:03',country='china') partition (dt='2020-04-30 04:05:06',country='us')");
        partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl").collect());
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30 01:02:03/country=china"));
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30 04:05:06/country=us"));
        partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl partition (dt='2020-04-30 01:02:03')").collect());
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30 01:02:03/country=china"));
        partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl partition (dt='2020-04-30 04:05:06')").collect());
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30 04:05:06/country=us"));
        partitions = CollectionUtil.iteratorToList((Iterator)this.tableEnv.executeSql("show partitions tbl partition (dt='2020-04-30 01:02:03',country='china')").collect());
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertTrue((boolean)partitions.toString().contains("dt=2020-04-30 01:02:03/country=china"));
    }

    @Test
    public void testUnsupportedOperation() {
        List<String> statements = Arrays.asList("create or replace view v as select x from foo", "create materialized view v as select x from foo", "create temporary table foo (x int)", "create table foo (x int) stored by 'handler.class'", "create table foo (x int) clustered by (x) into 3 buckets", "create table foo (x int) skewed by (x) on (1,2,3)", "describe foo partition (p=1)", "describe db.tbl col", "show tables in db1", "show tables like 'tbl*'", "show views in db1", "show views like '*view'");
        for (String statement : statements) {
            this.verifyUnsupportedOperation(statement);
        }
    }

    private void verifyUnsupportedOperation(String ddl) {
        try {
            this.tableEnv.executeSql(ddl);
            Assert.fail((String)("We don't support " + ddl));
        }
        catch (ValidationException e) {
            Assert.assertTrue((String)("Expect UnsupportedOperationException for " + ddl), (boolean)(e.getCause() instanceof UnsupportedOperationException));
        }
    }

    private static String locationPath(String locationURI) throws URISyntaxException {
        return new URI(locationURI).getPath();
    }

    private static List<Row> queryResult(Table table) {
        return CollectionUtil.iteratorToList((Iterator)table.execute().collect());
    }
}

