/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Properties;
import org.apache.flink.connectors.hive.write.HiveOutputFormatFactory;
import org.apache.flink.connectors.hive.write.HiveWriterFactory;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Test;

public class HiveOutputFormatFactoryTest {
    private static final String TEST_URI_SCHEME = "testscheme";
    private static final String TEST_URI_AUTHORITY = "test-uri-auth:8888";

    @Test
    public void testCreateOutputFormat() {
        TableSchema schema = TableSchema.builder().field("x", DataTypes.INT()).build();
        SerDeInfo serDeInfo = new SerDeInfo("name", LazySimpleSerDe.class.getName(), Collections.emptyMap());
        HiveWriterFactory writerFactory = new HiveWriterFactory(new JobConf(), VerifyURIOutputFormat.class, serDeInfo, schema, new String[0], new Properties(), HiveShimLoader.loadHiveShim((String)HiveShimLoader.getHiveVersion()), false);
        HiveOutputFormatFactory factory = new HiveOutputFormatFactory(writerFactory);
        Path path = new Path(TEST_URI_SCHEME, TEST_URI_AUTHORITY, "/foo/path");
        factory.createOutputFormat(path);
    }

    public static class VerifyURIOutputFormat
    implements HiveOutputFormat {
        public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, org.apache.hadoop.fs.Path finalOutPath, Class valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
            URI uri = finalOutPath.toUri();
            Assert.assertEquals((Object)HiveOutputFormatFactoryTest.TEST_URI_SCHEME, (Object)uri.getScheme());
            Assert.assertEquals((Object)HiveOutputFormatFactoryTest.TEST_URI_AUTHORITY, (Object)uri.getAuthority());
            return null;
        }

        public RecordWriter getRecordWriter(FileSystem fileSystem, JobConf jobConf, String s, Progressable progressable) throws IOException {
            return null;
        }

        public void checkOutputSpecs(FileSystem fileSystem, JobConf jobConf) throws IOException {
        }
    }
}

