/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.connectors.hive.HiveOptions;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.planner.runtime.stream.sql.CompactionITCaseBase;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HiveSinkCompactionITCase
extends CompactionITCaseBase {
    @Parameterized.Parameter
    public String format;
    private HiveCatalog hiveCatalog;

    @Parameterized.Parameters(name="format = {0}")
    public static Collection<String> parameters() {
        return Arrays.asList("sequencefile", "parquet");
    }

    @Before
    public void init() throws IOException {
        this.hiveCatalog = HiveTestUtils.createHiveCatalog();
        this.tEnv().registerCatalog(this.hiveCatalog.getName(), (Catalog)this.hiveCatalog);
        this.tEnv().useCatalog(this.hiveCatalog.getName());
        this.tEnv().getConfig().getConfiguration().set(HiveOptions.TABLE_EXEC_HIVE_INFER_SOURCE_PARALLELISM, (Object)false);
        super.init();
    }

    @After
    public void tearDown() throws TableNotExistException {
        if (this.hiveCatalog != null) {
            this.hiveCatalog.dropTable(new ObjectPath(this.tEnv().getCurrentDatabase(), "sink_table"), true);
            this.hiveCatalog.close();
        }
    }

    private void create(String path, boolean part) {
        this.tEnv().getConfig().setSqlDialect(SqlDialect.HIVE);
        this.tEnv().executeSql("CREATE TABLE sink_table (a int, b string" + (part ? "" : ",c string") + ") " + (part ? "partitioned by (c string) " : "") + " stored as " + this.format + " location '" + path + "' TBLPROPERTIES ('sink.partition-commit.policy.kind'='metastore,success-file','auto-compaction'='true','compaction.file-size' = '128MB','sink.rolling-policy.file-size' = '1b')");
        this.tEnv().getConfig().setSqlDialect(SqlDialect.DEFAULT);
    }

    protected String partitionField() {
        return "c";
    }

    protected void createTable(String path) {
        this.create(path, false);
    }

    protected void createPartitionTable(String path) {
        this.create(path, true);
    }
}

