/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.File;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.connectors.hive.HiveOptions;
import org.apache.flink.table.HiveVersionTestUtil;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientFactory;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TableEnvHiveConnectorITCase {
    private static HiveCatalog hiveCatalog;
    private static HiveMetastoreClientWrapper hmsClient;
    @ClassRule
    public static TemporaryFolder tempFolder;

    @BeforeClass
    public static void setup() {
        hiveCatalog = HiveTestUtils.createHiveCatalog();
        hiveCatalog.open();
        hmsClient = HiveMetastoreClientFactory.create((HiveConf)hiveCatalog.getHiveConf(), (String)HiveShimLoader.getHiveVersion());
    }

    @Test
    public void testOverwriteWithEmptySource() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.useDatabase("db1");
            tableEnv.executeSql("create table src (x int,p int)");
            tableEnv.executeSql("create table dest (x int)");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "dest").addRow(new Object[]{1}).addRow(new Object[]{2}).commit();
            tableEnv.executeSql("insert overwrite table dest select x from src").await();
            List results = CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from dest").collect());
            Assert.assertEquals((long)0L, (long)results.size());
            tableEnv.executeSql("create table destp (x int) partitioned by (p int)");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "destp").addRow(new Object[]{1}).commit("p=1");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "destp").addRow(new Object[]{2}).commit("p=2");
            tableEnv.executeSql("insert overwrite table destp partition (p) select * from src").await();
            results = CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from destp order by x").collect());
            Assert.assertEquals((Object)"[+I[1, 1], +I[2, 2]]", (Object)results.toString());
            tableEnv.executeSql("insert overwrite table destp partition(p=1) select x from src").await();
            results = CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from destp order by x").collect());
            Assert.assertEquals((Object)"[+I[1, 1], +I[2, 2]]", (Object)results.toString());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    @Test
    public void testMultiInputBroadcast() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.useDatabase("db1");
            tableEnv.executeSql("create table src1(key string, val string)");
            tableEnv.executeSql("create table src2(key string, val string)");
            tableEnv.executeSql("create table dest(key string, val string)");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "src1").addRow(new Object[]{"1", "val1"}).addRow(new Object[]{"2", "val2"}).addRow(new Object[]{"3", "val3"}).commit();
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "src2").addRow(new Object[]{"3", "val4"}).addRow(new Object[]{"4", "val4"}).commit();
            tableEnv.executeSql("INSERT OVERWRITE dest\nSELECT j.*\nFROM (SELECT t1.key, p1.val\n      FROM src2 t1\n      LEFT OUTER JOIN src1 p1\n      ON (t1.key = p1.key)\n      UNION ALL\n      SELECT t2.key, p2.val\n      FROM src2 t2\n      LEFT OUTER JOIN src1 p2\n      ON (t2.key = p2.key)) j").await();
            List results = CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from dest order by key").collect());
            Assert.assertEquals((Object)"[+I[3, val3], +I[3, val3], +I[4, null], +I[4, null]]", (Object)results.toString());
        }
        finally {
            tableEnv.useDatabase("default");
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    @Test
    public void testDefaultPartitionName() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        tableEnv.executeSql("create table db1.src (x int, y int)");
        tableEnv.executeSql("create table db1.part (x int) partitioned by (y int)");
        HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "src").addRow(new Object[]{1, 1}).addRow(new Object[]{2, null}).commit();
        tableEnv.executeSql("insert into db1.part select * from db1.src").await();
        HiveConf hiveConf = hiveCatalog.getHiveConf();
        String defaultPartName = hiveConf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        Table hiveTable = hmsClient.getTable("db1", "part");
        Path defaultPartPath = new Path(hiveTable.getSd().getLocation(), "y=" + defaultPartName);
        FileSystem fs = defaultPartPath.getFileSystem((Configuration)hiveConf);
        Assert.assertTrue((boolean)fs.exists(defaultPartPath));
        TableImpl flinkTable = (TableImpl)tableEnv.sqlQuery("select y, x from db1.part order by x");
        List rows = CollectionUtil.iteratorToList((Iterator)flinkTable.execute().collect());
        Assert.assertEquals((Object)"[+I[1, 1], +I[null, 2]]", (Object)rows.toString());
        tableEnv.executeSql("drop database db1 cascade");
    }

    @Test
    public void testGetNonExistingFunction() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        tableEnv.executeSql("create table db1.src (d double, s string)");
        tableEnv.executeSql("create table db1.dest (x bigint)");
        tableEnv.executeSql("insert into db1.dest select count(d) from db1.src").await();
        tableEnv.executeSql("drop database db1 cascade");
    }

    @Test
    public void testDateTimestampPartitionColumns() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.executeSql("create table db1.part(x int) partitioned by (dt date,ts timestamp)");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "part").addRow(new Object[]{1}).addRow(new Object[]{2}).commit("dt='2019-12-23',ts='2019-12-23 00:00:00'");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "part").addRow(new Object[]{3}).commit("dt='2019-12-25',ts='2019-12-25 16:23:43.012'");
            List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select * from db1.part order by x").execute().collect());
            Assert.assertEquals((Object)"[+I[1, 2019-12-23, 2019-12-23T00:00], +I[2, 2019-12-23, 2019-12-23T00:00], +I[3, 2019-12-25, 2019-12-25T16:23:43.012]]", (Object)results.toString());
            results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select x from db1.part where dt=cast('2019-12-25' as date)").execute().collect());
            Assert.assertEquals((Object)"[+I[3]]", (Object)results.toString());
            tableEnv.executeSql("insert into db1.part select 4,cast('2019-12-31' as date),cast('2019-12-31 12:00:00.0' as timestamp)").await();
            results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select max(dt) from db1.part").execute().collect());
            Assert.assertEquals((Object)"[+I[2019-12-31]]", (Object)results.toString());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUDTF() throws Exception {
        String hiveVersion = HiveShimLoader.getHiveVersion();
        Assume.assumeTrue((hiveVersion.compareTo("2.0.0") >= 0 || hiveVersion.compareTo("1.3.0") >= 0 ? 1 : 0) != 0);
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.executeSql("create table db1.simple (i int,a array<int>)");
            tableEnv.executeSql("create table db1.nested (a array<map<int, string>>)");
            tableEnv.executeSql("create function hiveudtf as 'org.apache.hadoop.hive.ql.udf.generic.GenericUDTFExplode'");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "simple").addRow(new Object[]{3, Arrays.asList(1, 2, 3)}).commit();
            HashMap<Integer, String> map1 = new HashMap<Integer, String>();
            map1.put(1, "a");
            map1.put(2, "b");
            HashMap<Integer, String> map2 = new HashMap<Integer, String>();
            map2.put(3, "c");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "nested").addRow(new Object[]{Arrays.asList(map1, map2)}).commit();
            List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select x from db1.simple, lateral table(hiveudtf(a)) as T(x)").execute().collect());
            Assert.assertEquals((Object)"[+I[1], +I[2], +I[3]]", (Object)results.toString());
            results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select x from db1.nested, lateral table(hiveudtf(a)) as T(x)").execute().collect());
            Assert.assertEquals((Object)"[+I[{1=a, 2=b}], +I[{3=c}]]", (Object)results.toString());
            tableEnv.executeSql("create table db1.ts (a array<timestamp>)");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "ts").addRow(new Object[]{new Object[]{Timestamp.valueOf("2015-04-28 15:23:00"), Timestamp.valueOf("2016-06-03 17:05:52")}}).commit();
            results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select x from db1.ts, lateral table(hiveudtf(a)) as T(x)").execute().collect());
            Assert.assertEquals((Object)"[+I[2015-04-28T15:23], +I[2016-06-03T17:05:52]]", (Object)results.toString());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
            tableEnv.executeSql("drop function hiveudtf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotNullConstraints() throws Exception {
        Assume.assumeTrue((boolean)HiveVersionTestUtil.HIVE_310_OR_LATER);
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.executeSql("create table db1.tbl (x int,y bigint not null enable rely,z string not null enable norely)");
            CatalogBaseTable catalogTable = hiveCatalog.getTable(new ObjectPath("db1", "tbl"));
            TableSchema tableSchema = catalogTable.getSchema();
            Assert.assertTrue((String)"By default columns should be nullable", (boolean)tableSchema.getFieldDataTypes()[0].getLogicalType().isNullable());
            Assert.assertFalse((String)"NOT NULL columns should be reflected in table schema", (boolean)tableSchema.getFieldDataTypes()[1].getLogicalType().isNullable());
            Assert.assertTrue((String)"NOT NULL NORELY columns should be considered nullable", (boolean)tableSchema.getFieldDataTypes()[2].getLogicalType().isNullable());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPKConstraint() throws Exception {
        Assume.assumeTrue((boolean)HiveVersionTestUtil.HIVE_310_OR_LATER);
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.executeSql("create table db1.tbl1 (x tinyint,y smallint,z int, primary key (x,z) disable novalidate rely)");
            CatalogBaseTable catalogTable = hiveCatalog.getTable(new ObjectPath("db1", "tbl1"));
            TableSchema tableSchema = catalogTable.getSchema();
            Assert.assertTrue((boolean)tableSchema.getPrimaryKey().isPresent());
            UniqueConstraint pk = (UniqueConstraint)tableSchema.getPrimaryKey().get();
            Assert.assertEquals((long)2L, (long)pk.getColumns().size());
            Assert.assertTrue((boolean)pk.getColumns().containsAll(Arrays.asList("x", "z")));
            tableEnv.executeSql("create table db1.tbl2 (x tinyint,y smallint, primary key (x) disable norely)");
            catalogTable = hiveCatalog.getTable(new ObjectPath("db1", "tbl2"));
            tableSchema = catalogTable.getSchema();
            Assert.assertFalse((boolean)tableSchema.getPrimaryKey().isPresent());
            tableEnv.executeSql("create table db1.tbl3 (x tinyint)");
            catalogTable = hiveCatalog.getTable(new ObjectPath("db1", "tbl3"));
            tableSchema = catalogTable.getSchema();
            Assert.assertFalse((boolean)tableSchema.getPrimaryKey().isPresent());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    @Test
    public void testRegexSerDe() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.executeSql("create table db1.src (x int,y string) row format serde 'org.apache.hadoop.hive.serde2.RegexSerDe' with serdeproperties ('input.regex'='([\\\\d]+)\\u0001([\\\\S]+)')");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "src").addRow(new Object[]{1, "a"}).addRow(new Object[]{2, "ab"}).commit();
            Assert.assertEquals((Object)"[+I[1, a], +I[2, ab]]", (Object)CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select * from db1.src order by x").execute().collect()).toString());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    @Test
    public void testUpdatePartitionSD() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.executeSql("create table db1.dest (x int) partitioned by (p string) stored as rcfile");
            tableEnv.executeSql("insert overwrite db1.dest partition (p='1') select 1").await();
            tableEnv.executeSql("alter table db1.dest set fileformat sequencefile");
            tableEnv.executeSql("insert overwrite db1.dest partition (p='1') select 1").await();
            Assert.assertEquals((Object)"[+I[1, 1]]", (Object)CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select * from db1.dest").execute().collect()).toString());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParquetNameMapping() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.executeSql("create table db1.t1 (x int,y int) stored as parquet");
            tableEnv.executeSql("insert into table db1.t1 values (1,10),(2,20)").await();
            Table hiveTable = hiveCatalog.getHiveTable(new ObjectPath("db1", "t1"));
            String location = hiveTable.getSd().getLocation();
            tableEnv.executeSql(String.format("create table db1.t2 (y int,x int) stored as parquet location '%s'", location));
            tableEnv.getConfig().getConfiguration().setBoolean(HiveOptions.TABLE_EXEC_HIVE_FALLBACK_MAPRED_READER, true);
            Assert.assertEquals((Object)"[+I[1], +I[2]]", (Object)CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select x from db1.t1").execute().collect()).toString());
            Assert.assertEquals((Object)"[+I[1], +I[2]]", (Object)CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select x from db1.t2").execute().collect()).toString());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonExistingPartitionFolder() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create database db1");
        try {
            tableEnv.executeSql("create table db1.part (x int) partitioned by (p int)");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "part").addRow(new Object[]{1}).commit("p=1");
            HiveTestUtils.createTextTableInserter(hiveCatalog, "db1", "part").addRow(new Object[]{2}).commit("p=2");
            tableEnv.executeSql("alter table db1.part add partition (p=3)");
            Path toRemove = new Path(hiveCatalog.getHiveTable(new ObjectPath("db1", "part")).getSd().getLocation(), "p=2");
            FileSystem fs = toRemove.getFileSystem((Configuration)hiveCatalog.getHiveConf());
            fs.delete(toRemove, true);
            List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select * from db1.part").execute().collect());
            Assert.assertEquals((Object)"[+I[1, 1]]", (Object)results.toString());
        }
        finally {
            tableEnv.executeSql("drop database db1 cascade");
        }
    }

    @Test
    public void testInsertPartitionWithStarSource() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create table src (x int,y string)");
        HiveTestUtils.createTextTableInserter(hiveCatalog, "default", "src").addRow(new Object[]{1, "a"}).commit();
        tableEnv.executeSql("create table dest (x int) partitioned by (p1 int,p2 string)");
        tableEnv.executeSql("insert into dest partition (p1=1,p2) select * from src").await();
        List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select * from dest").execute().collect());
        Assert.assertEquals((Object)"[+I[1, 1, a]]", (Object)results.toString());
        tableEnv.executeSql("drop table if exists src");
        tableEnv.executeSql("drop table if exists dest");
    }

    @Test
    public void testInsertPartitionWithValuesSource() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create table dest (x int) partitioned by (p1 int,p2 string)");
        tableEnv.executeSql("insert into dest partition (p1=1,p2) values(1, 'a')").await();
        List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select * from dest").execute().collect());
        Assert.assertEquals((Object)"[+I[1, 1, a]]", (Object)results.toString());
        tableEnv.executeSql("drop table if exists dest");
    }

    @Test
    public void testDynamicPartWithOrderBy() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        tableEnv.executeSql("create table src(x int,y int)");
        tableEnv.executeSql("create table dest(x int) partitioned by (p int)");
        try {
            HiveTestUtils.createTextTableInserter(hiveCatalog, "default", "src").addRow(new Object[]{2, 0}).addRow(new Object[]{1, 0}).commit();
            tableEnv.executeSql("insert into dest partition(p) select * from src order by x").await();
            List results = CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from dest").collect());
            Assert.assertEquals((Object)"[+I[1, 0], +I[2, 0]]", (Object)results.toString());
        }
        finally {
            tableEnv.executeSql("drop table src");
            tableEnv.executeSql("drop table dest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocationWithComma() throws Exception {
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        File location = tempFolder.newFolder(",tbl1,location,");
        try {
            tableEnv.executeSql(String.format("create table tbl1 (x int) location '%s'", location.getAbsolutePath()));
            tableEnv.executeSql("insert into tbl1 values (1),(2)").await();
            List results = CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from tbl1").collect());
            Assert.assertEquals((Object)"[+I[1], +I[2]]", (Object)results.toString());
            tableEnv.executeSql("create table tbl2 (x int) partitioned by (p string)");
            location = tempFolder.newFolder(",");
            tableEnv.executeSql(String.format("alter table tbl2 add partition (p='a') location '%s'", location.getAbsolutePath()));
            tableEnv.executeSql("insert into tbl2 partition (p='a') values (1),(2)").await();
            results = CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from tbl2").collect());
            Assert.assertEquals((Object)"[+I[1, a], +I[2, a]]", (Object)results.toString());
            tableEnv.executeSql("insert into tbl2 partition (p) values (3,'b ,')").await();
            results = CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from tbl2 where p='b ,'").collect());
            Assert.assertEquals((Object)"[+I[3, b ,]]", (Object)results.toString());
        }
        finally {
            if (location != null) {
                IOUtils.deleteFileQuietly((java.nio.file.Path)location.toPath());
            }
            tableEnv.executeSql("drop table if exists tbl1");
            tableEnv.executeSql("drop table if exists tbl2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadEmptyCollectionFromParquet() throws Exception {
        Assume.assumeTrue((boolean)HiveShimLoader.getHiveVersion().equals("2.0.0"));
        TableEnvironment tableEnv = this.getTableEnvWithHiveCatalog();
        try {
            String format = "parquet";
            String folderURI = this.getClass().getResource("/parquet").getPath();
            tableEnv.getConfig().getConfiguration().set(HiveOptions.TABLE_EXEC_HIVE_FALLBACK_MAPRED_READER, (Object)true);
            tableEnv.executeSql(String.format("create external table src_t (a string, b map<string, string>, c array<string>) stored as %s location 'file://%s'", format, folderURI));
            List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select * from src_t").execute().collect());
            Assert.assertEquals((Object)"[+I[hehuiyuan, null, null]]", (Object)results.toString());
        }
        finally {
            tableEnv.executeSql("drop table if exists src_t");
        }
    }

    private TableEnvironment getTableEnvWithHiveCatalog() {
        TableEnvironment tableEnv = HiveTestUtils.createTableEnvInBatchMode(SqlDialect.HIVE);
        tableEnv.registerCatalog(hiveCatalog.getName(), (Catalog)hiveCatalog);
        tableEnv.useCatalog(hiveCatalog.getName());
        return tableEnv;
    }

    static {
        tempFolder = new TemporaryFolder();
    }
}

