/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.read.HiveInputFormatPartitionReader;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.CollectionUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;

public class HiveInputFormatPartitionReaderITCase {
    @Test
    public void testReadMultipleSplits() throws Exception {
        HiveCatalog hiveCatalog = HiveTestUtils.createHiveCatalog();
        TableEnvironment tableEnv = HiveTestUtils.createTableEnvInBatchMode(SqlDialect.HIVE);
        tableEnv.registerCatalog(hiveCatalog.getName(), (Catalog)hiveCatalog);
        tableEnv.useCatalog(hiveCatalog.getName());
        if (!HiveShimLoader.getHiveVersion().startsWith("2.0")) {
            this.testReadFormat(tableEnv, hiveCatalog, "orc");
        }
        this.testReadFormat(tableEnv, hiveCatalog, "parquet");
    }

    private void testReadFormat(TableEnvironment tableEnv, HiveCatalog hiveCatalog, String format) throws Exception {
        String tableName = this.prepareData(tableEnv, format);
        ObjectPath tablePath = new ObjectPath("default", tableName);
        TableSchema tableSchema = hiveCatalog.getTable(tablePath).getSchema();
        HiveInputFormatPartitionReader partitionReader = new HiveInputFormatPartitionReader(new JobConf((Configuration)hiveCatalog.getHiveConf()), hiveCatalog.getHiveVersion(), tablePath, tableSchema.getFieldDataTypes(), tableSchema.getFieldNames(), Collections.emptyList(), null, false);
        Table hiveTable = hiveCatalog.getHiveTable(tablePath);
        HiveTablePartition tablePartition = new HiveTablePartition(hiveTable.getSd(), HiveReflectionUtils.getTableMetadata((HiveShim)HiveShimLoader.loadHiveShim((String)hiveCatalog.getHiveVersion()), (Table)hiveTable));
        partitionReader.open(Collections.singletonList(tablePartition));
        GenericRowData reuse = new GenericRowData(tableSchema.getFieldCount());
        int count = 0;
        while (partitionReader.read((RowData)reuse) != null) {
            ++count;
        }
        Assert.assertEquals((long)CollectionUtil.iteratorToList((Iterator)tableEnv.executeSql("select * from " + tableName).collect()).size(), (long)count);
    }

    private String prepareData(TableEnvironment tableEnv, String format) throws Exception {
        String tableName = format + "_table";
        tableEnv.executeSql(String.format("create table %s (i int,s string) stored as %s", tableName, format));
        tableEnv.executeSql(String.format("insert into %s values (1,'a')", tableName)).await();
        tableEnv.executeSql(String.format("insert into %s values (2,'b')", tableName)).await();
        return tableName;
    }
}

