/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.connectors.hive.read.HivePartitionFetcherContextBase;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.filesystem.FileSystemConnectorOptions;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;

public class HivePartitionFetcherTest {
    @Test
    public void testIgnoreNonExistPartition() throws Exception {
        HiveCatalog hiveCatalog = HiveTestUtils.createHiveCatalog();
        hiveCatalog.open();
        String[] fieldNames = new String[]{"i", "date"};
        DataType[] fieldTypes = new DataType[]{DataTypes.INT(), DataTypes.STRING()};
        TableSchema schema = TableSchema.builder().fields(fieldNames, fieldTypes).build();
        List<String> partitionKeys = Collections.singletonList("date");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "hive");
        CatalogTableImpl catalogTable = new CatalogTableImpl(schema, partitionKeys, options, null);
        ObjectPath tablePath = new ObjectPath("default", "test");
        hiveCatalog.createTable(tablePath, (CatalogBaseTable)catalogTable, false);
        Table hiveTable = hiveCatalog.getHiveTable(tablePath);
        Path path = new Path(hiveTable.getSd().getLocation(), "date=2021-06-18");
        FileSystem fs = path.getFileSystem((org.apache.hadoop.conf.Configuration)hiveCatalog.getHiveConf());
        fs.mkdirs(path);
        Configuration flinkConf = new Configuration();
        flinkConf.set(FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_ORDER, (Object)FileSystemConnectorOptions.PartitionOrder.PARTITION_TIME);
        HiveShim hiveShim = HiveShimLoader.loadHiveShim((String)hiveCatalog.getHiveVersion());
        JobConfWrapper jobConfWrapper = new JobConfWrapper(new JobConf((org.apache.hadoop.conf.Configuration)hiveCatalog.getHiveConf()));
        String defaultPartName = "__HIVE_DEFAULT_PARTITION__";
        MyHivePartitionFetcherContext fetcherContext = new MyHivePartitionFetcherContext(tablePath, hiveShim, jobConfWrapper, partitionKeys, fieldTypes, fieldNames, flinkConf, defaultPartName);
        fetcherContext.open();
        Assert.assertEquals((long)0L, (long)fetcherContext.getComparablePartitionValueList().size());
        flinkConf.set(FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_ORDER, (Object)FileSystemConnectorOptions.PartitionOrder.CREATE_TIME);
        fetcherContext = new MyHivePartitionFetcherContext(tablePath, hiveShim, jobConfWrapper, partitionKeys, fieldTypes, fieldNames, flinkConf, defaultPartName);
        fetcherContext.open();
        Assert.assertEquals((long)0L, (long)fetcherContext.getComparablePartitionValueList().size());
        flinkConf.set(FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_ORDER, (Object)FileSystemConnectorOptions.PartitionOrder.PARTITION_NAME);
        fetcherContext = new MyHivePartitionFetcherContext(tablePath, hiveShim, jobConfWrapper, partitionKeys, fieldTypes, fieldNames, flinkConf, defaultPartName);
        fetcherContext.open();
        Assert.assertEquals((long)0L, (long)fetcherContext.getComparablePartitionValueList().size());
    }

    private static class MyHivePartitionFetcherContext
    extends HivePartitionFetcherContextBase<Partition> {
        private static final long serialVersionUID = 1L;

        public MyHivePartitionFetcherContext(ObjectPath tablePath, HiveShim hiveShim, JobConfWrapper confWrapper, List<String> partitionKeys, DataType[] fieldTypes, String[] fieldNames, Configuration configuration, String defaultPartitionName) {
            super(tablePath, hiveShim, confWrapper, partitionKeys, fieldTypes, fieldNames, configuration, defaultPartitionName);
        }

        public Optional<Partition> getPartition(List<String> partValues) throws Exception {
            return Optional.empty();
        }
    }
}

