/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HiveCatalogDataTypeTest {
    private static HiveCatalog catalog;
    protected final String db1 = "db1";
    protected final String db2 = "db2";
    protected final String t1 = "t1";
    protected final String t2 = "t2";
    protected final ObjectPath path1 = new ObjectPath("db1", "t1");
    protected final ObjectPath path2 = new ObjectPath("db2", "t2");
    protected final ObjectPath path3 = new ObjectPath("db1", "t2");
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void init() {
        catalog = HiveTestUtils.createHiveCatalog();
        catalog.open();
    }

    @After
    public void cleanup() throws Exception {
        if (catalog.tableExists(this.path1)) {
            catalog.dropTable(this.path1, true);
        }
        if (catalog.tableExists(this.path2)) {
            catalog.dropTable(this.path2, true);
        }
        if (catalog.tableExists(this.path3)) {
            catalog.dropTable(this.path3, true);
        }
        if (catalog.functionExists(this.path1)) {
            catalog.dropFunction(this.path1, true);
        }
        if (catalog.databaseExists("db1")) {
            catalog.dropDatabase("db1", true);
        }
        if (catalog.databaseExists("db2")) {
            catalog.dropDatabase("db2", true);
        }
    }

    @AfterClass
    public static void closeup() {
        if (catalog != null) {
            catalog.close();
        }
    }

    @Test
    public void testDataTypes() throws Exception {
        DataType[] types = new DataType[]{DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.BYTES(), DataTypes.DATE(), DataTypes.TIMESTAMP((int)9), DataTypes.CHAR((int)255), DataTypes.VARCHAR((int)65535), DataTypes.DECIMAL((int)5, (int)3)};
        this.verifyDataTypes(types);
    }

    @Test
    public void testNonSupportedBinaryDataTypes() throws Exception {
        DataType[] types = new DataType[]{DataTypes.BINARY((int)Integer.MAX_VALUE)};
        CatalogTable table = this.createCatalogTable(types);
        catalog.createDatabase("db1", HiveCatalogDataTypeTest.createDb(), false);
        this.exception.expect(UnsupportedOperationException.class);
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
    }

    @Test
    public void testNonSupportedVarBinaryDataTypes() throws Exception {
        DataType[] types = new DataType[]{DataTypes.VARBINARY((int)20)};
        CatalogTable table = this.createCatalogTable(types);
        catalog.createDatabase("db1", HiveCatalogDataTypeTest.createDb(), false);
        this.exception.expect(UnsupportedOperationException.class);
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
    }

    @Test
    public void testCharTypeLength() throws Exception {
        DataType[] types = new DataType[]{DataTypes.CHAR((int)256)};
        this.exception.expect(CatalogException.class);
        this.verifyDataTypes(types);
    }

    @Test
    public void testVarCharTypeLength() throws Exception {
        DataType[] types = new DataType[]{DataTypes.VARCHAR((int)65536)};
        this.exception.expect(CatalogException.class);
        this.verifyDataTypes(types);
    }

    @Test
    public void testComplexDataTypes() throws Exception {
        DataType[] types = new DataType[]{DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.MAP((DataType)DataTypes.FLOAT(), (DataType)DataTypes.BIGINT()), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"1", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"2", (DataType)DataTypes.DATE())}), DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT())), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"3", (DataType)DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)5, (int)3))), DataTypes.FIELD((String)"4", (DataType)DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.SMALLINT())), DataTypes.FIELD((String)"5", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"3", (DataType)DataTypes.TIMESTAMP((int)9))}))})};
        this.verifyDataTypes(types);
    }

    private CatalogTable createCatalogTable(DataType[] types) {
        String[] colNames = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            colNames[i] = String.format("%s_%d", types[i].toString().toLowerCase(), i);
        }
        TableSchema schema = TableSchema.builder().fields(colNames, types).build();
        return new CatalogTableImpl(schema, (Map)new HashMap<String, String>(){
            {
                this.put("is_streaming", "false");
                this.put(FactoryUtil.CONNECTOR.key(), "hive");
            }
        }, "");
    }

    private void verifyDataTypes(DataType[] types) throws Exception {
        CatalogTable table = this.createCatalogTable(types);
        catalog.createDatabase("db1", HiveCatalogDataTypeTest.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        Assert.assertEquals((Object)table.getSchema(), (Object)catalog.getTable(this.path1).getSchema());
    }

    private static CatalogDatabase createDb() {
        return new CatalogDatabaseImpl((Map)new HashMap<String, String>(){
            {
                this.put("k1", "v1");
            }
        }, "");
    }
}

