/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveCatalogMetadataTestBase;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.functions.TestGenericUDF;
import org.apache.flink.table.functions.TestSimpleUDF;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HiveCatalogGenericMetadataTest
extends HiveCatalogMetadataTestBase {
    @BeforeClass
    public static void init() {
        catalog = HiveTestUtils.createHiveCatalog();
        catalog.open();
    }

    @Test
    public void testGenericTableSchema() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        TableSchema tableSchema = TableSchema.builder().fields(new String[]{"col1", "col2", "col3"}, new DataType[]{DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP((int)6), DataTypes.TIMESTAMP((int)9)}).watermark("col3", "col3", DataTypes.TIMESTAMP((int)9)).build();
        ObjectPath tablePath = new ObjectPath("db1", "generic_table");
        try {
            catalog.createTable(tablePath, (CatalogBaseTable)new CatalogTableImpl(tableSchema, this.getBatchTableProperties(), "test comment"), false);
            Assert.assertEquals((Object)tableSchema, (Object)catalog.getTable(tablePath).getSchema());
        }
        finally {
            catalog.dropTable(tablePath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableSchemaCompatibility() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        try {
            ObjectPath tablePath = new ObjectPath("db1", "generic1");
            org.apache.hadoop.hive.metastore.api.Table hiveTable = Table.getEmptyTable((String)tablePath.getDatabaseName(), (String)tablePath.getObjectName());
            hiveTable.setDbName(tablePath.getDatabaseName());
            hiveTable.setTableName(tablePath.getObjectName());
            HiveCatalogGenericMetadataTest.setLegacyGeneric(hiveTable.getParameters());
            hiveTable.getParameters().put("flink.generic.table.schema.0.name", "ti");
            hiveTable.getParameters().put("flink.generic.table.schema.0.data-type", "TINYINT");
            hiveTable.getParameters().put("flink.generic.table.schema.1.name", "si");
            hiveTable.getParameters().put("flink.generic.table.schema.1.data-type", "SMALLINT");
            hiveTable.getParameters().put("flink.generic.table.schema.2.name", "i");
            hiveTable.getParameters().put("flink.generic.table.schema.2.data-type", "INT");
            hiveTable.getParameters().put("flink.generic.table.schema.3.name", "bi");
            hiveTable.getParameters().put("flink.generic.table.schema.3.data-type", "BIGINT");
            hiveTable.getParameters().put("flink.generic.table.schema.4.name", "f");
            hiveTable.getParameters().put("flink.generic.table.schema.4.data-type", "FLOAT");
            hiveTable.getParameters().put("flink.generic.table.schema.5.name", "d");
            hiveTable.getParameters().put("flink.generic.table.schema.5.data-type", "DOUBLE");
            hiveTable.getParameters().put("flink.generic.table.schema.6.name", "de");
            hiveTable.getParameters().put("flink.generic.table.schema.6.data-type", "DECIMAL(10, 5)");
            hiveTable.getParameters().put("flink.generic.table.schema.7.name", "cost");
            hiveTable.getParameters().put("flink.generic.table.schema.7.expr", "`d` * `bi`");
            hiveTable.getParameters().put("flink.generic.table.schema.7.data-type", "DOUBLE");
            ((HiveCatalog)HiveCatalogGenericMetadataTest.catalog).client.createTable(hiveTable);
            CatalogBaseTable catalogBaseTable = catalog.getTable(tablePath);
            Assert.assertFalse((boolean)HiveCatalog.isHiveTable((Map)catalogBaseTable.getOptions()));
            TableSchema expectedSchema = TableSchema.builder().fields(new String[]{"ti", "si", "i", "bi", "f", "d", "de"}, new DataType[]{DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.DECIMAL((int)10, (int)5)}).field("cost", DataTypes.DOUBLE(), "`d` * `bi`").build();
            Assert.assertEquals((Object)expectedSchema, (Object)catalogBaseTable.getSchema());
            tablePath = new ObjectPath("db1", "generic2");
            hiveTable = Table.getEmptyTable((String)tablePath.getDatabaseName(), (String)tablePath.getObjectName());
            hiveTable.setDbName(tablePath.getDatabaseName());
            hiveTable.setTableName(tablePath.getObjectName());
            HiveCatalogGenericMetadataTest.setLegacyGeneric(hiveTable.getParameters());
            hiveTable.setTableName(tablePath.getObjectName());
            hiveTable.getParameters().put("flink.generic.table.schema.0.name", "c");
            hiveTable.getParameters().put("flink.generic.table.schema.0.data-type", "CHAR(265)");
            hiveTable.getParameters().put("flink.generic.table.schema.1.name", "vc");
            hiveTable.getParameters().put("flink.generic.table.schema.1.data-type", "VARCHAR(65536)");
            hiveTable.getParameters().put("flink.generic.table.schema.2.name", "s");
            hiveTable.getParameters().put("flink.generic.table.schema.2.data-type", "VARCHAR(2147483647)");
            hiveTable.getParameters().put("flink.generic.table.schema.3.name", "b");
            hiveTable.getParameters().put("flink.generic.table.schema.3.data-type", "BINARY(1)");
            hiveTable.getParameters().put("flink.generic.table.schema.4.name", "vb");
            hiveTable.getParameters().put("flink.generic.table.schema.4.data-type", "VARBINARY(255)");
            hiveTable.getParameters().put("flink.generic.table.schema.5.name", "bs");
            hiveTable.getParameters().put("flink.generic.table.schema.5.data-type", "VARBINARY(2147483647)");
            hiveTable.getParameters().put("flink.generic.table.schema.6.name", "len");
            hiveTable.getParameters().put("flink.generic.table.schema.6.expr", "CHAR_LENGTH(`s`)");
            hiveTable.getParameters().put("flink.generic.table.schema.6.data-type", "INT");
            ((HiveCatalog)HiveCatalogGenericMetadataTest.catalog).client.createTable(hiveTable);
            catalogBaseTable = catalog.getTable(tablePath);
            expectedSchema = TableSchema.builder().fields(new String[]{"c", "vc", "s", "b", "vb", "bs"}, new DataType[]{DataTypes.CHAR((int)265), DataTypes.VARCHAR((int)65536), DataTypes.STRING(), DataTypes.BINARY((int)1), DataTypes.VARBINARY((int)255), DataTypes.BYTES()}).field("len", DataTypes.INT(), "CHAR_LENGTH(`s`)").build();
            Assert.assertEquals((Object)expectedSchema, (Object)catalogBaseTable.getSchema());
            tablePath = new ObjectPath("db1", "generic3");
            hiveTable = Table.getEmptyTable((String)tablePath.getDatabaseName(), (String)tablePath.getObjectName());
            hiveTable.setDbName(tablePath.getDatabaseName());
            hiveTable.setTableName(tablePath.getObjectName());
            HiveCatalogGenericMetadataTest.setLegacyGeneric(hiveTable.getParameters());
            hiveTable.setTableName(tablePath.getObjectName());
            hiveTable.getParameters().put("flink.generic.table.schema.0.name", "dt");
            hiveTable.getParameters().put("flink.generic.table.schema.0.data-type", "DATE");
            hiveTable.getParameters().put("flink.generic.table.schema.1.name", "t");
            hiveTable.getParameters().put("flink.generic.table.schema.1.data-type", "TIME(0)");
            hiveTable.getParameters().put("flink.generic.table.schema.2.name", "ts");
            hiveTable.getParameters().put("flink.generic.table.schema.2.data-type", "TIMESTAMP(3)");
            hiveTable.getParameters().put("flink.generic.table.schema.3.name", "tstz");
            hiveTable.getParameters().put("flink.generic.table.schema.3.data-type", "TIMESTAMP(6) WITH LOCAL TIME ZONE");
            hiveTable.getParameters().put("flink.generic.table.schema.watermark.0.rowtime", "ts");
            hiveTable.getParameters().put("flink.generic.table.schema.watermark.0.strategy.data-type", "TIMESTAMP(3)");
            hiveTable.getParameters().put("flink.generic.table.schema.watermark.0.strategy.expr", "ts");
            ((HiveCatalog)HiveCatalogGenericMetadataTest.catalog).client.createTable(hiveTable);
            catalogBaseTable = catalog.getTable(tablePath);
            expectedSchema = TableSchema.builder().fields(new String[]{"dt", "t", "ts", "tstz"}, new DataType[]{DataTypes.DATE(), DataTypes.TIME(), DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE()}).watermark("ts", "ts", DataTypes.TIMESTAMP((int)3)).build();
            Assert.assertEquals((Object)expectedSchema, (Object)catalogBaseTable.getSchema());
            tablePath = new ObjectPath("db1", "generic4");
            hiveTable = Table.getEmptyTable((String)tablePath.getDatabaseName(), (String)tablePath.getObjectName());
            hiveTable.setDbName(tablePath.getDatabaseName());
            hiveTable.setTableName(tablePath.getObjectName());
            HiveCatalogGenericMetadataTest.setLegacyGeneric(hiveTable.getParameters());
            hiveTable.setTableName(tablePath.getObjectName());
            hiveTable.getParameters().put("flink.generic.table.schema.0.name", "a");
            hiveTable.getParameters().put("flink.generic.table.schema.0.data-type", "ARRAY<INT>");
            hiveTable.getParameters().put("flink.generic.table.schema.1.name", "m");
            hiveTable.getParameters().put("flink.generic.table.schema.1.data-type", "MAP<BIGINT, TIMESTAMP(6)>");
            hiveTable.getParameters().put("flink.generic.table.schema.2.name", "mul");
            hiveTable.getParameters().put("flink.generic.table.schema.2.data-type", "MULTISET<DOUBLE>");
            hiveTable.getParameters().put("flink.generic.table.schema.3.name", "r");
            hiveTable.getParameters().put("flink.generic.table.schema.3.data-type", "ROW<`f1` INT, `f2` VARCHAR(2147483647)>");
            hiveTable.getParameters().put("flink.generic.table.schema.4.name", "b");
            hiveTable.getParameters().put("flink.generic.table.schema.4.data-type", "BOOLEAN");
            hiveTable.getParameters().put("flink.generic.table.schema.5.name", "ts");
            hiveTable.getParameters().put("flink.generic.table.schema.5.data-type", "TIMESTAMP(3)");
            hiveTable.getParameters().put("flink.generic.table.schema.watermark.0.rowtime", "ts");
            hiveTable.getParameters().put("flink.generic.table.schema.watermark.0.strategy.data-type", "TIMESTAMP(3)");
            hiveTable.getParameters().put("flink.generic.table.schema.watermark.0.strategy.expr", "`ts` - INTERVAL '5' SECOND");
            ((HiveCatalog)HiveCatalogGenericMetadataTest.catalog).client.createTable(hiveTable);
            catalogBaseTable = catalog.getTable(tablePath);
            expectedSchema = TableSchema.builder().fields(new String[]{"a", "m", "mul", "r", "b", "ts"}, new DataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MULTISET((DataType)DataTypes.DOUBLE()), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.STRING())}), DataTypes.BOOLEAN(), DataTypes.TIMESTAMP((int)3)}).watermark("ts", "`ts` - INTERVAL '5' SECOND", DataTypes.TIMESTAMP((int)3)).build();
            Assert.assertEquals((Object)expectedSchema, (Object)catalogBaseTable.getSchema());
        }
        finally {
            catalog.dropDatabase("db1", true, true);
        }
    }

    @Test
    public void testFunctionCompatibility() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        ((HiveCatalog)HiveCatalogGenericMetadataTest.catalog).client.createFunction(new Function(this.path1.getObjectName().toLowerCase(), this.path1.getDatabaseName(), "flink:class.name", null, PrincipalType.GROUP, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, new ArrayList()));
        CatalogFunction catalogFunction = catalog.getFunction(this.path1);
        Assert.assertEquals((Object)"class.name", (Object)catalogFunction.getClassName());
        Assert.assertEquals((Object)FunctionLanguage.JAVA, (Object)catalogFunction.getFunctionLanguage());
    }

    @Test
    public void testGenericTableWithoutConnectorProp() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        TableSchema tableSchema = TableSchema.builder().fields(new String[]{"s", "ts"}, new DataType[]{DataTypes.STRING(), DataTypes.TIMESTAMP_LTZ((int)3)}).watermark("ts", "ts-INTERVAL '1' SECOND", DataTypes.TIMESTAMP_LTZ((int)3)).build();
        CatalogTableImpl catalogTable = new CatalogTableImpl(tableSchema, Collections.emptyMap(), null);
        catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        CatalogTable retrievedTable = (CatalogTable)catalog.getTable(this.path1);
        Assert.assertEquals((Object)tableSchema, (Object)retrievedTable.getSchema());
        Assert.assertEquals(Collections.emptyMap(), (Object)retrievedTable.getOptions());
    }

    @Test
    public void testFunctionWithNonExistClass() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl("non.exist.scala.class", FunctionLanguage.SCALA);
        catalog.createFunction(this.path1, (CatalogFunction)catalogFunction, false);
        Assert.assertEquals((Object)catalogFunction.getClassName(), (Object)catalog.getFunction(this.path1).getClassName());
        Assert.assertEquals((Object)catalogFunction.getFunctionLanguage(), (Object)catalog.getFunction(this.path1).getFunctionLanguage());
        catalogFunction = new CatalogFunctionImpl("non.exist.java.class", FunctionLanguage.JAVA);
        catalog.alterFunction(this.path1, (CatalogFunction)catalogFunction, false);
        Assert.assertEquals((Object)catalogFunction.getClassName(), (Object)catalog.getFunction(this.path1).getClassName());
        Assert.assertEquals((Object)catalogFunction.getFunctionLanguage(), (Object)catalog.getFunction(this.path1).getFunctionLanguage());
        catalogFunction = new CatalogFunctionImpl("non.exist.python.class", FunctionLanguage.PYTHON);
        catalog.alterFunction(this.path1, (CatalogFunction)catalogFunction, false);
        Assert.assertEquals((Object)catalogFunction.getClassName(), (Object)catalog.getFunction(this.path1).getClassName());
        Assert.assertEquals((Object)catalogFunction.getFunctionLanguage(), (Object)catalog.getFunction(this.path1).getFunctionLanguage());
    }

    @Test
    public void testCreatePartition() throws Exception {
    }

    @Test
    public void testCreatePartition_TableNotExistException() throws Exception {
    }

    @Test
    public void testCreatePartition_TableNotPartitionedException() throws Exception {
    }

    @Test
    public void testCreatePartition_PartitionSpecInvalidException() throws Exception {
    }

    @Test
    public void testCreatePartition_PartitionAlreadyExistsException() throws Exception {
    }

    @Test
    public void testCreatePartition_PartitionAlreadyExists_ignored() throws Exception {
    }

    @Test
    public void testDropPartition() throws Exception {
    }

    @Test
    public void testDropPartition_TableNotExist() throws Exception {
    }

    @Test
    public void testDropPartition_TableNotPartitioned() throws Exception {
    }

    @Test
    public void testDropPartition_PartitionSpecInvalid() throws Exception {
    }

    @Test
    public void testDropPartition_PartitionNotExist() throws Exception {
    }

    @Test
    public void testDropPartition_PartitionNotExist_ignored() throws Exception {
    }

    @Test
    public void testAlterPartition() throws Exception {
    }

    @Test
    public void testAlterPartition_TableNotExist() throws Exception {
    }

    @Test
    public void testAlterPartition_TableNotPartitioned() throws Exception {
    }

    @Test
    public void testAlterPartition_PartitionSpecInvalid() throws Exception {
    }

    @Test
    public void testAlterPartition_PartitionNotExist() throws Exception {
    }

    @Test
    public void testAlterPartition_PartitionNotExist_ignored() throws Exception {
    }

    @Test
    public void testGetPartition_TableNotExist() throws Exception {
    }

    @Test
    public void testGetPartition_TableNotPartitioned() throws Exception {
    }

    @Test
    public void testGetPartition_PartitionSpecInvalid_invalidPartitionSpec() throws Exception {
    }

    @Test
    public void testGetPartition_PartitionSpecInvalid_sizeNotEqual() throws Exception {
    }

    @Test
    public void testGetPartition_PartitionNotExist() throws Exception {
    }

    @Test
    public void testPartitionExists() throws Exception {
    }

    @Test
    public void testListPartitionPartialSpec() throws Exception {
    }

    public void testGetPartitionStats() throws Exception {
    }

    public void testAlterPartitionTableStats() throws Exception {
    }

    public void testAlterTableStats_partitionedTable() throws Exception {
    }

    protected boolean isGeneric() {
        return true;
    }

    public CatalogPartition createPartition() {
        throw new UnsupportedOperationException();
    }

    protected CatalogFunction createFunction() {
        return new CatalogFunctionImpl(TestGenericUDF.class.getCanonicalName());
    }

    protected CatalogFunction createAnotherFunction() {
        return new CatalogFunctionImpl(TestSimpleUDF.class.getCanonicalName(), FunctionLanguage.SCALA);
    }

    private static void setLegacyGeneric(Map<String, String> properties) {
        properties.put("is_generic", "true");
    }
}

