/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogTestBase;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.junit.Assume;
import org.junit.Test;

public abstract class HiveCatalogMetadataTestBase
extends CatalogTestBase {
    @Test
    public void testAlterTableStats() throws Exception {
        String hiveVersion = ((HiveCatalog)catalog).getHiveVersion();
        Assume.assumeTrue((hiveVersion.compareTo("1.2.1") >= 0 ? 1 : 0) != 0);
        super.testAlterTableStats();
    }

    @Test
    public void testCreateFunctionCaseInsensitive() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        String functionName = "myUdf";
        ObjectPath functionPath = new ObjectPath("db1", functionName);
        catalog.createFunction(functionPath, this.createFunction(), false);
        catalog.getFunction(functionPath);
        catalog.dropFunction(functionPath, false);
    }

    protected CatalogFunction createPythonFunction() {
        return new CatalogFunctionImpl("test.func1", FunctionLanguage.PYTHON);
    }
}

