/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.flink.sql.parser.SqlPartitionUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAddHivePartitions;
import org.apache.flink.sql.parser.hive.impl.FlinkHiveSqlParserImpl;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.junit.rules.TemporaryFolder;

public class HiveTestUtils {
    private static final String HIVE_WAREHOUSE_URI_FORMAT = "jdbc:derby:;databaseName=%s;create=true";
    private static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    private static final int MIN_EPH_PORT = 49152;
    private static final int MAX_EPH_PORT = 61000;
    private static final byte[] SEPARATORS = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};

    public static HiveCatalog createHiveCatalog() {
        return HiveTestUtils.createHiveCatalog("test-catalog", null);
    }

    public static HiveCatalog createHiveCatalog(String name, String hiveVersion) {
        return new HiveCatalog(name, null, HiveTestUtils.createHiveConf(), StringUtils.isNullOrWhitespaceOnly((String)hiveVersion) ? HiveShimLoader.getHiveVersion() : hiveVersion, true);
    }

    public static HiveCatalog createHiveCatalog(String name, String hiveConfDir, String hadoopConfDir, String hiveVersion) {
        return new HiveCatalog(name, null, hiveConfDir, hadoopConfDir, StringUtils.isNullOrWhitespaceOnly((String)hiveVersion) ? HiveShimLoader.getHiveVersion() : hiveVersion);
    }

    public static HiveCatalog createHiveCatalog(HiveConf hiveConf) {
        return new HiveCatalog("test-catalog", null, hiveConf, HiveShimLoader.getHiveVersion(), true);
    }

    public static HiveConf createHiveConf() {
        ClassLoader classLoader = HiveTestUtils.class.getClassLoader();
        try {
            TEMPORARY_FOLDER.create();
            String warehouseDir = TEMPORARY_FOLDER.newFolder().getAbsolutePath() + "/metastore_db";
            String warehouseUri = String.format(HIVE_WAREHOUSE_URI_FORMAT, warehouseDir);
            HiveConf hiveConf = new HiveConf();
            hiveConf.addResource(classLoader.getResource("hive-site.xml"));
            hiveConf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, TEMPORARY_FOLDER.newFolder("hive_warehouse").getAbsolutePath());
            hiveConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, warehouseUri);
            return hiveConf;
        }
        catch (IOException e) {
            throw new CatalogException("Failed to create test HiveConf to HiveCatalog.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFreePort() throws IOException {
        int numPorts = 11849;
        int numAttempt = 0;
        while (numAttempt++ < 11849) {
            int p = ThreadLocalRandom.current().nextInt(11849) + 49152;
            try (ServerSocket socket = new ServerSocket();){
                socket.bind(new InetSocketAddress("localhost", p));
                int n = socket.getLocalPort();
                return n;
            }
            catch (BindException bindException) {
            }
        }
        throw new RuntimeException("Exhausted all ephemeral ports and didn't find a free one");
    }

    public static TableEnvironment createTableEnvInBatchMode() {
        return HiveTestUtils.createTableEnvInBatchMode(SqlDialect.DEFAULT);
    }

    public static TableEnvironment createTableEnvInBatchMode(SqlDialect dialect) {
        TableEnvironment tableEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inBatchMode());
        tableEnv.getConfig().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM.key(), 1);
        tableEnv.getConfig().setSqlDialect(dialect);
        return tableEnv;
    }

    public static StreamTableEnvironment createTableEnvInStreamingMode(StreamExecutionEnvironment env) {
        return HiveTestUtils.createTableEnvInStreamingMode(env, SqlDialect.DEFAULT);
    }

    public static StreamTableEnvironment createTableEnvInStreamingMode(StreamExecutionEnvironment env, SqlDialect dialect) {
        StreamTableEnvironment tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        tableEnv.getConfig().getConfiguration().setInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM.key(), 1);
        tableEnv.getConfig().setSqlDialect(dialect);
        return tableEnv;
    }

    public static TableEnvironment createTableEnvWithHiveCatalog(HiveCatalog catalog) {
        TableEnvironment tableEnv = HiveTestUtils.createTableEnvInBatchMode();
        tableEnv.registerCatalog(catalog.getName(), (Catalog)catalog);
        tableEnv.useCatalog(catalog.getName());
        return tableEnv;
    }

    public static TextTableInserter createTextTableInserter(HiveCatalog hiveCatalog, String dbName, String tableName) {
        return new TextTableInserter(hiveCatalog, dbName, tableName);
    }

    public static class TextTableInserter {
        private final HiveCatalog hiveCatalog;
        private final TableEnvironment tableEnv;
        private final String dbName;
        private final String tableName;
        private final List<Object[]> rows;

        public TextTableInserter(HiveCatalog hiveCatalog, String dbName, String tableName) {
            this.hiveCatalog = hiveCatalog;
            this.tableEnv = HiveTestUtils.createTableEnvWithHiveCatalog(hiveCatalog);
            this.tableEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
            this.dbName = dbName;
            this.tableName = tableName;
            this.rows = new ArrayList<Object[]>();
        }

        public TextTableInserter addRow(Object[] row) {
            this.rows.add(row);
            return this;
        }

        public void commit() throws Exception {
            this.commit(null);
        }

        public void commit(String partitionSpec) throws Exception {
            Path dest;
            File file = File.createTempFile("table_data_", null);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (int i = 0; i < this.rows.size(); ++i) {
                    if (i > 0) {
                        writer.newLine();
                    }
                    writer.write(this.toText(this.rows.get(i)));
                }
                writer.newLine();
            }
            Path src = new Path(file.toURI());
            ObjectPath tablePath = new ObjectPath(this.dbName, this.tableName);
            Table hiveTable = this.hiveCatalog.getHiveTable(tablePath);
            String addPartDDL = null;
            if (partitionSpec != null) {
                addPartDDL = String.format("alter table `%s`.`%s` add if not exists partition (%s)", this.dbName, this.tableName, partitionSpec);
                SqlParser parser = SqlParser.create((String)addPartDDL, (SqlParser.Config)SqlParser.config().withParserFactory(FlinkHiveSqlParserImpl.FACTORY).withLex(Lex.JAVA));
                SqlAddHivePartitions sqlAddPart = (SqlAddHivePartitions)parser.parseStmt();
                LinkedHashMap spec = SqlPartitionUtils.getPartitionKVs((SqlNodeList)((SqlNodeList)sqlAddPart.getPartSpecs().get(0)));
                Path partLocation = new Path(hiveTable.getSd().getLocation(), PartitionPathUtils.generatePartitionPath((LinkedHashMap)spec));
                dest = new Path(partLocation, src.getName());
            } else {
                dest = new Path(hiveTable.getSd().getLocation(), src.getName());
            }
            FileSystem fs = dest.getFileSystem((Configuration)this.hiveCatalog.getHiveConf());
            Preconditions.checkState((boolean)fs.rename(src, dest));
            if (addPartDDL != null) {
                this.tableEnv.executeSql(addPartDDL + String.format(" location '%s'", dest.getParent().toString()));
            }
        }

        private String toText(Object[] row) {
            StringBuilder builder = new StringBuilder();
            for (Object col : row) {
                String colStr;
                if (builder.length() > 0) {
                    builder.appendCodePoint(SEPARATORS[0]);
                }
                if ((colStr = this.toText(col, 1)) == null) continue;
                builder.append(colStr);
            }
            return builder.toString();
        }

        private String toText(Object obj, int level) {
            if (obj == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            if (obj instanceof Map) {
                for (Object key : ((Map)obj).keySet()) {
                    if (builder.length() > 0) {
                        builder.appendCodePoint(SEPARATORS[level]);
                    }
                    builder.append(this.toText(key, level + 2));
                    builder.appendCodePoint(SEPARATORS[level + 1]);
                    builder.append(this.toText(((Map)obj).get(key), level + 2));
                }
            } else if (obj instanceof Object[]) {
                Object[] array;
                for (Object element : array = (Object[])obj) {
                    if (builder.length() > 0) {
                        builder.appendCodePoint(SEPARATORS[level]);
                    }
                    builder.append(this.toText(element, level + 1));
                }
            } else if (obj instanceof List) {
                for (Object element : (List)obj) {
                    if (builder.length() > 0) {
                        builder.appendCodePoint(SEPARATORS[level]);
                    }
                    builder.append(this.toText(element, level + 1));
                }
            } else {
                builder.append(obj);
            }
            return builder.toString();
        }
    }
}

