/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.factories;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.catalog.hive.factories.HiveCatalogFactoryOptions;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.TestLogger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class HiveCatalogFactoryTest
extends TestLogger {
    private static final URL CONF_DIR = Thread.currentThread().getContextClassLoader().getResource("test-catalog-factory-conf");
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCreateHiveCatalog() {
        String catalogName = "mycatalog";
        HiveCatalog expectedCatalog = HiveTestUtils.createHiveCatalog("mycatalog", null);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hive");
        options.put(HiveCatalogFactoryOptions.HIVE_CONF_DIR.key(), CONF_DIR.getPath());
        Catalog actualCatalog = FactoryUtil.createCatalog((String)"mycatalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assert.assertEquals((Object)"dummy-hms", (Object)((HiveCatalog)actualCatalog).getHiveConf().getVar(HiveConf.ConfVars.METASTOREURIS));
        HiveCatalogFactoryTest.checkEquals(expectedCatalog, (HiveCatalog)actualCatalog);
    }

    @Test
    public void testCreateHiveCatalogWithHadoopConfDir() throws IOException {
        String catalogName = "mycatalog";
        String hadoopConfDir = this.tempFolder.newFolder().getAbsolutePath();
        File mapredSiteFile = new File(hadoopConfDir, "mapred-site.xml");
        String mapredKey = "mapred.site.config.key";
        String mapredVal = "mapred.site.config.val";
        HiveCatalogFactoryTest.writeProperty(mapredSiteFile, "mapred.site.config.key", "mapred.site.config.val");
        HiveCatalog expectedCatalog = HiveTestUtils.createHiveCatalog("mycatalog", CONF_DIR.getPath(), hadoopConfDir, null);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hive");
        options.put(HiveCatalogFactoryOptions.HIVE_CONF_DIR.key(), CONF_DIR.getPath());
        options.put(HiveCatalogFactoryOptions.HADOOP_CONF_DIR.key(), hadoopConfDir);
        Catalog actualCatalog = FactoryUtil.createCatalog((String)"mycatalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        HiveCatalogFactoryTest.checkEquals(expectedCatalog, (HiveCatalog)actualCatalog);
        Assert.assertEquals((Object)"mapred.site.config.val", (Object)((HiveCatalog)actualCatalog).getHiveConf().get("mapred.site.config.key"));
    }

    @Test
    public void testCreateHiveCatalogWithIllegalHadoopConfDir() throws IOException {
        String catalogName = "mycatalog";
        String hadoopConfDir = this.tempFolder.newFolder().getAbsolutePath();
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hive");
            options.put(HiveCatalogFactoryOptions.HIVE_CONF_DIR.key(), CONF_DIR.getPath());
            options.put(HiveCatalogFactoryOptions.HADOOP_CONF_DIR.key(), hadoopConfDir);
            Catalog actualCatalog = FactoryUtil.createCatalog((String)"mycatalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
            Assert.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadHadoopConfigFromEnv() throws IOException {
        HiveConf hiveConf;
        HashMap<String, String> customProps = new HashMap<String, String>();
        String k1 = "what is connector?";
        String v1 = "Hive";
        String catalogName = "HiveCatalog";
        File hadoopConfDir = this.tempFolder.newFolder();
        File hdfsSiteFile = new File(hadoopConfDir, "hdfs-site.xml");
        HiveCatalogFactoryTest.writeProperty(hdfsSiteFile, k1, v1);
        customProps.put(k1, v1);
        File mapredSiteFile = new File(hadoopConfDir, "mapred-site.xml");
        k1 = "mapred.site.config.key";
        v1 = "mapred.site.config.val";
        HiveCatalogFactoryTest.writeProperty(mapredSiteFile, k1, v1);
        customProps.put(k1, v1);
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>(originalEnv);
        newEnv.put("HADOOP_CONF_DIR", hadoopConfDir.getAbsolutePath());
        newEnv.remove("HADOOP_HOME");
        CommonTestUtils.setEnv(newEnv);
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hive");
            options.put(HiveCatalogFactoryOptions.HIVE_CONF_DIR.key(), CONF_DIR.getPath());
            HiveCatalog hiveCatalog = (HiveCatalog)FactoryUtil.createCatalog((String)"HiveCatalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
            hiveConf = hiveCatalog.getHiveConf();
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        for (String key : customProps.keySet()) {
            Assert.assertEquals(customProps.get(key), (Object)hiveConf.get(key, null));
        }
    }

    @Test
    public void testDisallowEmbedded() {
        this.expectedException.expect(ValidationException.class);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hive");
        FactoryUtil.createCatalog((String)"my_catalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void testCreateMultipleHiveCatalog() throws Exception {
        HashMap<String, String> props1 = new HashMap<String, String>();
        props1.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hive");
        props1.put(HiveCatalogFactoryOptions.HIVE_CONF_DIR.key(), Thread.currentThread().getContextClassLoader().getResource("test-multi-hive-conf1").getPath());
        HashMap<String, String> props2 = new HashMap<String, String>();
        props2.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hive");
        props2.put(HiveCatalogFactoryOptions.HIVE_CONF_DIR.key(), Thread.currentThread().getContextClassLoader().getResource("test-multi-hive-conf2").getPath());
        Callable<Catalog> callable1 = () -> FactoryUtil.createCatalog((String)"cat1", (Map)props1, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Callable<Catalog> callable2 = () -> FactoryUtil.createCatalog((String)"cat2", (Map)props2, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Catalog> future1 = executorService.submit(callable1);
        Future<Catalog> future2 = executorService.submit(callable2);
        executorService.shutdown();
        HiveCatalog catalog1 = (HiveCatalog)future1.get();
        HiveCatalog catalog2 = (HiveCatalog)future2.get();
        Assert.assertEquals((Object)"val1", (Object)catalog1.getHiveConf().get("key"));
        Assert.assertNotNull((Object)catalog1.getHiveConf().get("conf1", null));
        Assert.assertNull((Object)catalog1.getHiveConf().get("conf2", null));
        Assert.assertEquals((Object)"val2", (Object)catalog2.getHiveConf().get("key"));
        Assert.assertNotNull((Object)catalog2.getHiveConf().get("conf2", null));
        Assert.assertNull((Object)catalog2.getHiveConf().get("conf1", null));
    }

    private static void checkEquals(HiveCatalog c1, HiveCatalog c2) {
        Assert.assertEquals((Object)c1.getName(), (Object)c2.getName());
        Assert.assertEquals((Object)c1.getDefaultDatabase(), (Object)c2.getDefaultDatabase());
    }

    private static void writeProperty(File file, String key, String value) throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream(file));){
            out.println("<?xml version=\"1.0\"?>");
            out.println("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>");
            out.println("<configuration>");
            out.println("\t<property>");
            out.println("\t\t<name>" + key + "</name>");
            out.println("\t\t<value>" + value + "</value>");
            out.println("\t</property>");
            out.println("</configuration>");
        }
    }
}

