/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.HiveGenericUDAF;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.junit.Assert;
import org.junit.Test;

public class HiveGenericUDAFTest {
    @Test
    public void testUDAFMin() throws Exception {
        Object[] constantArgs = new Object[]{null};
        DataType[] argTypes = new DataType[]{DataTypes.BIGINT()};
        HiveGenericUDAF udf = HiveGenericUDAFTest.init(GenericUDAFMin.class, constantArgs, argTypes);
        GenericUDAFEvaluator.AggregationBuffer acc = udf.createAccumulator();
        udf.accumulate(acc, new Object[]{2L});
        udf.accumulate(acc, new Object[]{3L});
        udf.accumulate(acc, new Object[]{1L});
        udf.merge(acc, Arrays.asList(new GenericUDAFEvaluator.AggregationBuffer[0]));
        Assert.assertEquals((Object)1L, (Object)udf.getValue(acc));
    }

    @Test
    public void testUDAFSum() throws Exception {
        Object[] constantArgs = new Object[]{null};
        DataType[] argTypes = new DataType[]{DataTypes.DOUBLE()};
        HiveGenericUDAF udf = HiveGenericUDAFTest.init(GenericUDAFSum.class, constantArgs, argTypes);
        GenericUDAFEvaluator.AggregationBuffer acc = udf.createAccumulator();
        udf.accumulate(acc, new Object[]{0.5});
        udf.accumulate(acc, new Object[]{0.3});
        udf.accumulate(acc, new Object[]{5.3});
        udf.merge(acc, Arrays.asList(new GenericUDAFEvaluator.AggregationBuffer[0]));
        Assert.assertEquals((Object)6.1, (Object)udf.getValue(acc));
        constantArgs = new Object[]{null};
        argTypes = new DataType[]{DataTypes.DECIMAL((int)5, (int)3)};
        udf = HiveGenericUDAFTest.init(GenericUDAFSum.class, constantArgs, argTypes);
        acc = udf.createAccumulator();
        udf.accumulate(acc, new Object[]{BigDecimal.valueOf(10.111)});
        udf.accumulate(acc, new Object[]{BigDecimal.valueOf(3.222)});
        udf.accumulate(acc, new Object[]{BigDecimal.valueOf(5.333)});
        udf.merge(acc, Arrays.asList(new GenericUDAFEvaluator.AggregationBuffer[0]));
        Assert.assertEquals((Object)BigDecimal.valueOf(18.666), (Object)udf.getValue(acc));
    }

    @Test
    public void testUDAFCount() throws Exception {
        Object[] constantArgs = new Object[]{null};
        DataType[] argTypes = new DataType[]{DataTypes.DOUBLE()};
        HiveGenericUDAF udf = HiveGenericUDAFTest.init(GenericUDAFCount.class, constantArgs, argTypes);
        GenericUDAFEvaluator.AggregationBuffer acc = udf.createAccumulator();
        udf.accumulate(acc, new Object[]{0.5});
        udf.accumulate(acc, new Object[]{0.3});
        udf.accumulate(acc, new Object[]{5.3});
        udf.merge(acc, Arrays.asList(new GenericUDAFEvaluator.AggregationBuffer[0]));
        Assert.assertEquals((Object)3L, (Object)udf.getValue(acc));
    }

    private static HiveGenericUDAF init(Class hiveUdfClass, Object[] constantArgs, DataType[] argTypes) throws Exception {
        HiveFunctionWrapper wrapper = new HiveFunctionWrapper(hiveUdfClass.getName());
        HiveGenericUDAF udf = new HiveGenericUDAF(wrapper, HiveShimLoader.loadHiveShim((String)HiveShimLoader.getHiveVersion()));
        udf.setArgumentTypesAndConstants(constantArgs, argTypes);
        udf.getHiveResultType(constantArgs, argTypes);
        udf.open(null);
        return udf;
    }
}

