/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.HiveGenericUDTF;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFInline;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFPosExplode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFStack;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.junit.Assert;
import org.junit.Test;

public class HiveGenericUDTFTest {
    private static HiveShim hiveShim = HiveShimLoader.loadHiveShim((String)HiveShimLoader.getHiveVersion());
    private static TestCollector collector;

    @Test
    public void testOverSumInt() throws Exception {
        Object[] constantArgs = new Object[]{null, 4};
        DataType[] dataTypes = new DataType[]{DataTypes.INT(), DataTypes.INT()};
        HiveGenericUDTF udf = HiveGenericUDTFTest.init(TestOverSumIntUDTF.class, constantArgs, dataTypes);
        udf.eval(new Object[]{5, 4});
        Assert.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{9}), Row.of((Object[])new Object[]{9})), HiveGenericUDTFTest.collector.result);
        constantArgs = new Object[]{};
        dataTypes = new DataType[]{};
        udf = HiveGenericUDTFTest.init(TestOverSumIntUDTF.class, constantArgs, dataTypes);
        udf.eval(new Object[0]);
        Assert.assertEquals(Arrays.asList(new Object[0]), HiveGenericUDTFTest.collector.result);
    }

    @Test
    public void testSplit() throws Exception {
        Object[] constantArgs = new Object[]{null};
        DataType[] dataTypes = new DataType[]{DataTypes.STRING()};
        HiveGenericUDTF udf = HiveGenericUDTFTest.init(TestSplitUDTF.class, constantArgs, dataTypes);
        udf.eval(new Object[]{"1,2,3,5"});
        Assert.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"1"}), Row.of((Object[])new Object[]{"2"}), Row.of((Object[])new Object[]{"3"}), Row.of((Object[])new Object[]{"5"})), HiveGenericUDTFTest.collector.result);
    }

    @Test
    public void testStack() throws Exception {
        Object[] constantArgs = new Object[]{2, null, null, null, null};
        DataType[] dataTypes = new DataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()};
        HiveGenericUDTF udf = HiveGenericUDTFTest.init(GenericUDTFStack.class, constantArgs, dataTypes);
        udf.eval(new Object[]{2, "a", "b", "c", "d"});
        Assert.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"a", "b"}), Row.of((Object[])new Object[]{"c", "d"})), HiveGenericUDTFTest.collector.result);
    }

    @Test
    public void testArray() throws Exception {
        Object[] constantArgs = new Object[]{null};
        DataType[] dataTypes = new DataType[]{DataTypes.ARRAY((DataType)DataTypes.INT())};
        HiveGenericUDTF udf = HiveGenericUDTFTest.init(GenericUDTFPosExplode.class, constantArgs, dataTypes);
        udf.eval((Object[])new Integer[]{1, 2, 3});
        Assert.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{0, 1}), Row.of((Object[])new Object[]{1, 2}), Row.of((Object[])new Object[]{2, 3})), HiveGenericUDTFTest.collector.result);
    }

    @Test
    public void testStruct() throws Exception {
        Object[] constantArgs = new Object[]{null};
        DataType[] dataTypes = new DataType[]{DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"1", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"2", (DataType)DataTypes.DOUBLE())}))};
        HiveGenericUDTF udf = HiveGenericUDTFTest.init(GenericUDTFInline.class, constantArgs, dataTypes);
        udf.eval((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2.2}), Row.of((Object[])new Object[]{3, 4.4})});
        Assert.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{1, 2.2}), Row.of((Object[])new Object[]{3, 4.4})), HiveGenericUDTFTest.collector.result);
    }

    private static HiveGenericUDTF init(Class hiveUdfClass, Object[] constantArgs, DataType[] argTypes) throws Exception {
        HiveFunctionWrapper wrapper = new HiveFunctionWrapper(hiveUdfClass.getName());
        HiveGenericUDTF udf = new HiveGenericUDTF(wrapper, hiveShim);
        udf.setArgumentTypesAndConstants(constantArgs, argTypes);
        udf.getHiveResultType(constantArgs, argTypes);
        ObjectInspector[] argumentInspectors = HiveInspectors.toInspectors((HiveShim)hiveShim, (Object[])constantArgs, (DataType[])argTypes);
        StructObjectInspector returnInspector = ((GenericUDTF)wrapper.createFunction()).initialize(argumentInspectors);
        udf.open(null);
        collector = new TestCollector((ObjectInspector)returnInspector);
        udf.setCollector((Collector)collector);
        return udf;
    }

    public static class TestSplitUDTF
    extends GenericUDTF {
        public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
            return ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("col1"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        }

        public void process(Object[] args) throws HiveException {
            String str = (String)args[0];
            for (String s : str.split(",")) {
                this.forward(s);
            }
        }

        public void close() {
        }
    }

    public static class TestOverSumIntUDTF
    extends GenericUDTF {
        ObjectInspectorConverters.Converter[] converters;

        public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
            this.converters = new ObjectInspectorConverters.Converter[argOIs.length];
            for (int i = 0; i < this.converters.length; ++i) {
                this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)argOIs[i], (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
            }
            return ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("col1"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        }

        public void process(Object[] args) throws HiveException {
            int total = 0;
            for (int i = 0; i < args.length; ++i) {
                total += ((Integer)this.converters[i].convert(args[i])).intValue();
            }
            for (Object ignored : args) {
                this.forward(total);
            }
        }

        public void close() {
        }
    }

    private static class TestCollector
    implements Collector {
        List<Row> result = new ArrayList<Row>();
        ObjectInspector returnInspector;

        public TestCollector(ObjectInspector returnInspector) {
            this.returnInspector = returnInspector;
        }

        public void collect(Object o) {
            Row row = (Row)HiveInspectors.toFlinkObject((ObjectInspector)this.returnInspector, (Object)o, (HiveShim)hiveShim);
            this.result.add(row);
        }
    }
}

