/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.Assert;
import org.junit.Test;

public class HiveASTParserTest {
    private static final HiveConf hiveConf = HiveTestUtils.createHiveConf();

    @Test
    public void testDatabase() throws Exception {
        this.assertDDLType(915, "show databases");
        this.assertDDLType(951, "use db1");
        this.assertDDLType(710, "create database db1", "create database db1 comment 'comment db1' location '/path/to/db1'", "create database db1 with dbproperties ('k1'='v1','k2'='v2')");
        this.assertDDLType(655, "alter database db1 set dbproperties('k1'='v1')");
        this.assertDDLType(653, "alter database db1 set location '/new/path'");
        this.assertDDLType(654, "alter database db1 set owner user user1", "alter database db1 set owner role role1");
        this.assertDDLType(743, "drop schema db1", "drop database db1 cascade");
        this.assertDDLType(734, "describe schema db1", "describe database extended db1");
    }

    @Test
    public void testTable() throws Exception {
        this.assertDDLType(921, "show tables");
        this.assertDDLType(736, "describe tbl", "describe extended tbl", "describe formatted tbl");
        this.assertDDLType(716, "create table tbl (x int) row format delimited fields terminated by ',' escaped by '\\\\' collection items terminated by ',' map keys terminated by ':' lines terminated by '\\n' null defined as 'null' location '/path/to/table'", "create table tbl (x double) stored as orc tblproperties ('k1'='v1')", "create table tbl (x decimal(5,2)) row format serde 'serde.class.name' with serdeproperties ('serde.k1'='v1')", "create table tbl (x date) row format delimited fields terminated by '\\u0001' stored as inputformat 'input.format.class' outputformat 'output.format.class'", "create table tbl (x struct<f1:timestamp,f2:int>) partitioned by (p1 string,p2 bigint) stored as rcfile", "create external table tbl (x map<timestamp,array<timestamp>>) location '/table/path'", "create temporary table tbl (x varchar(50)) partitioned by (p timestamp)", "create table if not exists tbl (x int)", "create table tbl (x int not null enable rely, y string not null disable novalidate norely)", "create table tbl (x int,y timestamp not null,z string,primary key (x,z) disable novalidate rely)", "create table tbl (x binary,y date,z string,constraint pk_cons primary key(x))");
        this.assertDDLType(748, "drop table tbl", "drop table if exists cat.tbl");
        this.assertDDLType(658, "alter table tbl rename to tbl1", "alter table tbl set serde 'serde.class' with serdeproperties ('field.delim'='\\u0001')", "alter table tbl set serdeproperties('line.delim'='\\n')", "alter table tbl set location '/new/table/path'", "alter table tbl partition (p1=1,p2='a') set location '/new/partition/location'", "alter table tbl partition (p=1) rename to partition (p=2)", "alter table tbl set tblproperties('k1'='v1','k2'='v2')", "alter table tbl set fileformat rcfile", "alter table tbl partition (p=1) set fileformat sequencefile", "alter table tbl change c c1 struct<f0:timestamp,f1:array<char(5)>> restrict", "alter table tbl change column c c decimal(5,2) comment 'new comment' first cascade", "alter table tbl add columns (a float,b timestamp,c binary) cascade", "alter table tbl replace columns (a char(100),b tinyint comment 'tiny comment',c smallint) restrict", "alter table tbl add partition (p1=1,p2='a') location '/part1/location'", "alter table tbl add if not exists partition (p=1) partition (p=2) location '/part2/location'", "alter table tbl drop if exists partition (p=1)", "alter table tbl drop partition (p1='a',p2=1), partition(p1='b',p2=2)");
        this.assertDDLType(920, "show partitions tbl", "show partitions tbl partition (p=1)");
    }

    @Test
    public void testView() throws Exception {
        this.assertDDLType(717, "create view db1.v1 as select x,y from tbl", "create view if not exists v1 (c1,c2) as select * from tbl", "create view v1 comment 'v1 comment' tblproperties('k1'='v1','k2'='v2') as select * from tbl");
        this.assertDDLType(749, "drop view v1", "drop view if exists v1");
        this.assertDDLType(688, "alter view v1 rename to v2", "alter view v1 set tblproperties ('k1'='v1')", "alter view v1 as select c1,c2 from tbl");
    }

    @Test
    public void testFunction() throws Exception {
        this.assertDDLType(711, "create function func as 'class.name'", "create temporary function func as 'class.name'");
        this.assertDDLType(744, "drop function if exists func", "drop temporary function func");
        this.assertDDLType(917, "show functions");
    }

    @Test
    public void testConstraints() throws Exception {
        this.assertDDLType(716, "create table foo (x int not null norely,y string not null disable validate)", "create table foo(x int,y int, primary key(x) enable rely)", "create table foo(x int,y decimal, constraint pk primary key (x,y))");
    }

    private void assertDDLType(int type, String ... sqls) throws Exception {
        for (String sql : sqls) {
            HiveParserContext parserContext = new HiveParserContext((Configuration)hiveConf);
            Assert.assertEquals((long)type, (long)HiveASTParseUtils.parse((String)sql, (HiveParserContext)parserContext).getType());
        }
    }
}

