/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.FileSourceSplitSerializer;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.read.HiveSourceSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

public class HiveSourceSplitSerializer
implements SimpleVersionedSerializer<HiveSourceSplit> {
    private static final int VERSION = 1;
    public static final HiveSourceSplitSerializer INSTANCE = new HiveSourceSplitSerializer();

    private HiveSourceSplitSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(HiveSourceSplit split) throws IOException {
        Preconditions.checkArgument((((Object)((Object)split)).getClass() == HiveSourceSplit.class ? 1 : 0) != 0, (Object)"Cannot serialize subclasses of HiveSourceSplit");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);){
            this.serialize(outputStream, split);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public HiveSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            try (ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(serialized));){
                HiveSourceSplit hiveSourceSplit = this.deserializeV1(inputStream);
                return hiveSourceSplit;
            }
        }
        throw new IOException("Unknown version: " + version);
    }

    private void serialize(ObjectOutputStream outputStream, HiveSourceSplit split) throws IOException {
        byte[] superBytes = FileSourceSplitSerializer.INSTANCE.serialize(new FileSourceSplit(split.splitId(), split.path(), split.offset(), split.length(), split.hostnames(), (CheckpointedPosition)split.getReaderPosition().orElse(null)));
        outputStream.writeInt(superBytes.length);
        outputStream.write(superBytes);
        outputStream.writeObject(split.getHiveTablePartition());
    }

    private HiveSourceSplit deserializeV1(ObjectInputStream inputStream) throws IOException {
        try {
            int superLen = inputStream.readInt();
            byte[] superBytes = new byte[superLen];
            inputStream.readFully(superBytes);
            FileSourceSplit superSplit = FileSourceSplitSerializer.INSTANCE.deserialize(FileSourceSplitSerializer.INSTANCE.getVersion(), superBytes);
            HiveTablePartition hiveTablePartition = (HiveTablePartition)inputStream.readObject();
            return new HiveSourceSplit(superSplit.splitId(), superSplit.path(), superSplit.offset(), superSplit.length(), superSplit.hostnames(), superSplit.getReaderPosition().orElse(null), hiveTablePartition);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to deserialize HiveSourceSplit", e);
        }
    }
}

