/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.hive.shaded.formats.parquet.vector.reader.AbstractColumnReader;
import org.apache.flink.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.flink.hive.shaded.parquet.column.page.PageReader;
import org.apache.flink.hive.shaded.parquet.schema.PrimitiveType;
import org.apache.flink.table.data.vector.writable.WritableBytesVector;
import org.apache.flink.table.data.vector.writable.WritableIntVector;

public class BytesColumnReader
extends AbstractColumnReader<WritableBytesVector> {
    public BytesColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.BINARY);
    }

    @Override
    protected void readBatch(int rowId, int num, WritableBytesVector column) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    if (this.runLenDecoder.currentValue == this.maxDefLevel) {
                        this.readBinary(n, column, rowId);
                        break;
                    }
                    column.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] == this.maxDefLevel) {
                            this.readBinary(1, column, rowId + i);
                            continue;
                        }
                        column.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableBytesVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            byte[] bytes = this.dictionary.decodeToBinary(dictionaryIds.getInt(i)).getBytes();
            column.appendBytes(i, bytes, 0, bytes.length);
        }
    }

    private void readBinary(int total, WritableBytesVector v, int rowId) {
        for (int i = 0; i < total; ++i) {
            int len = this.readDataBuffer(4).getInt();
            ByteBuffer buffer = this.readDataBuffer(len);
            if (buffer.hasArray()) {
                v.appendBytes(rowId + i, buffer.array(), buffer.arrayOffset() + buffer.position(), len);
                continue;
            }
            byte[] bytes = new byte[len];
            buffer.get(bytes);
            v.appendBytes(rowId + i, bytes, 0, bytes.length);
        }
    }
}

