/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.fs.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.hive.shaded.fs.hdfs.HadoopFsRecoverable;
import org.apache.hadoop.fs.Path;

@Internal
class HadoopRecoverableSerializer
implements SimpleVersionedSerializer<HadoopFsRecoverable> {
    static final HadoopRecoverableSerializer INSTANCE = new HadoopRecoverableSerializer();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final int MAGIC_NUMBER = -683447202;

    private HadoopRecoverableSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(HadoopFsRecoverable obj) throws IOException {
        byte[] targetFileBytes = obj.targetFile().toString().getBytes(CHARSET);
        byte[] tempFileBytes = obj.tempFile().toString().getBytes(CHARSET);
        byte[] targetBytes = new byte[20 + targetFileBytes.length + tempFileBytes.length];
        ByteBuffer bb = ByteBuffer.wrap(targetBytes).order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(-683447202);
        bb.putLong(obj.offset());
        bb.putInt(targetFileBytes.length);
        bb.putInt(tempFileBytes.length);
        bb.put(targetFileBytes);
        bb.put(tempFileBytes);
        return targetBytes;
    }

    public HadoopFsRecoverable deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: {
                return HadoopRecoverableSerializer.deserializeV1(serialized);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private static HadoopFsRecoverable deserializeV1(byte[] serialized) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(serialized).order(ByteOrder.LITTLE_ENDIAN);
        if (bb.getInt() != -683447202) {
            throw new IOException("Corrupt data: Unexpected magic number.");
        }
        long offset = bb.getLong();
        byte[] targetFileBytes = new byte[bb.getInt()];
        byte[] tempFileBytes = new byte[bb.getInt()];
        bb.get(targetFileBytes);
        bb.get(tempFileBytes);
        String targetPath = new String(targetFileBytes, CHARSET);
        String tempPath = new String(tempFileBytes, CHARSET);
        return new HadoopFsRecoverable(new Path(targetPath), new Path(tempPath), offset);
    }
}

