/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.hadoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.hive.shaded.parquet.Strings;
import org.apache.flink.hive.shaded.parquet.bytes.BytesInput;
import org.apache.flink.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.flink.hive.shaded.parquet.column.Encoding;
import org.apache.flink.hive.shaded.parquet.column.EncodingStats;
import org.apache.flink.hive.shaded.parquet.column.page.DictionaryPage;
import org.apache.flink.hive.shaded.parquet.column.page.DictionaryPageReadStore;
import org.apache.flink.hive.shaded.parquet.hadoop.ColumnChunkPageReadStore;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetFileReader;
import org.apache.flink.hive.shaded.parquet.hadoop.metadata.BlockMetaData;
import org.apache.flink.hive.shaded.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.flink.hive.shaded.parquet.io.ParquetDecodingException;

class DictionaryPageReader
implements DictionaryPageReadStore {
    private final ParquetFileReader reader;
    private final Map<String, ColumnChunkMetaData> columns;
    private final Map<String, DictionaryPage> cache = new HashMap<String, DictionaryPage>();
    private ColumnChunkPageReadStore rowGroup = null;

    DictionaryPageReader(ParquetFileReader reader, BlockMetaData block) {
        this.reader = reader;
        this.columns = new HashMap<String, ColumnChunkMetaData>();
        for (ColumnChunkMetaData column : block.getColumns()) {
            this.columns.put(column.getPath().toDotString(), column);
        }
    }

    void setRowGroup(ColumnChunkPageReadStore rowGroup) {
        this.rowGroup = rowGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DictionaryPage readDictionaryPage(ColumnDescriptor descriptor) {
        if (this.rowGroup != null) {
            return this.rowGroup.readDictionaryPage(descriptor);
        }
        String dotPath = Strings.join(descriptor.getPath(), ".");
        ColumnChunkMetaData column = this.columns.get(dotPath);
        if (column == null) {
            throw new ParquetDecodingException("Cannot load dictionary, unknown column: " + dotPath);
        }
        if (this.cache.containsKey(dotPath)) {
            return this.cache.get(dotPath);
        }
        try {
            Map<String, DictionaryPage> map = this.cache;
            synchronized (map) {
                if (!this.cache.containsKey(dotPath)) {
                    DictionaryPage dict = this.hasDictionaryPage(column) ? this.reader.readDictionary(column) : null;
                    this.cache.put(dotPath, DictionaryPageReader.reusableCopy(dict));
                }
            }
            return this.cache.get(dotPath);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read dictionary", e);
        }
    }

    private static DictionaryPage reusableCopy(DictionaryPage dict) {
        if (dict == null) {
            return null;
        }
        try {
            return new DictionaryPage(BytesInput.from(dict.getBytes().toByteArray()), dict.getDictionarySize(), dict.getEncoding());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Cannot read dictionary", e);
        }
    }

    private boolean hasDictionaryPage(ColumnChunkMetaData column) {
        EncodingStats stats = column.getEncodingStats();
        if (stats != null) {
            return stats.hasDictionaryPages() && stats.hasDictionaryEncodedPages();
        }
        Set<Encoding> encodings = column.getEncodings();
        return encodings.contains((Object)Encoding.PLAIN_DICTIONARY) || encodings.contains((Object)Encoding.RLE_DICTIONARY);
    }
}

