/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.orc.vector.RowDataVectorizer;
import org.apache.flink.orc.writer.OrcBulkWriterFactory;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShimV122;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;

public class HiveShimV200
extends HiveShimV122 {
    @Override
    public IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) {
        try {
            Class[] constructorArgTypes = new Class[]{HiveConf.class};
            Object[] constructorArgs = new Object[]{hiveConf};
            Method method = RetryingMetaStoreClient.class.getMethod("getProxy", HiveConf.class, constructorArgTypes.getClass(), constructorArgs.getClass(), String.class);
            return (IMetaStoreClient)method.invoke(null, hiveConf, constructorArgTypes, constructorArgs, HiveMetaStoreClient.class.getName());
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to create Hive Metastore client", (Throwable)ex);
        }
    }

    @Override
    public BulkWriter.Factory<RowData> createOrcBulkWriterFactory(Configuration conf, String schema, LogicalType[] fieldTypes) {
        return new OrcBulkWriterFactory<RowData>(new RowDataVectorizer(schema, fieldTypes), new Properties(), conf);
    }
}

