/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShimV201;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;

public class HiveShimV210
extends HiveShimV201 {
    @Override
    public void alterPartition(IMetaStoreClient client, String databaseName, String tableName, Partition partition) throws InvalidOperationException, MetaException, TException {
        String errorMsg = "Failed to alter partition for table %s in database %s";
        try {
            Method method = client.getClass().getMethod("alter_partition", String.class, String.class, Partition.class, EnvironmentContext.class);
            method.invoke((Object)client, databaseName, tableName, partition, null);
        }
        catch (InvocationTargetException ite) {
            Throwable targetEx = ite.getTargetException();
            if (targetEx instanceof TException) {
                throw (TException)targetEx;
            }
            throw new CatalogException(String.format(errorMsg, tableName, databaseName), targetEx);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new CatalogException(String.format(errorMsg, tableName, databaseName), (Throwable)e);
        }
    }

    @Override
    public Optional<UniqueConstraint> getPrimaryKey(IMetaStoreClient client, String dbName, String tableName, byte requiredTrait) {
        try {
            Class<?> requestClz = Class.forName("org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest");
            Object request = requestClz.getDeclaredConstructor(String.class, String.class).newInstance(dbName, tableName);
            List constraints = (List)HiveReflectionUtils.invokeMethod(client.getClass(), client, "getPrimaryKeys", new Class[]{requestClz}, new Object[]{request});
            if (constraints.isEmpty()) {
                return Optional.empty();
            }
            Class<?> constraintClz = Class.forName("org.apache.hadoop.hive.metastore.api.SQLPrimaryKey");
            Method colNameMethod = constraintClz.getDeclaredMethod("getColumn_name", new Class[0]);
            Method isEnableMethod = constraintClz.getDeclaredMethod("isEnable_cstr", new Class[0]);
            Method isValidateMethod = constraintClz.getDeclaredMethod("isValidate_cstr", new Class[0]);
            Method isRelyMethod = constraintClz.getDeclaredMethod("isRely_cstr", new Class[0]);
            ArrayList<String> colNames = new ArrayList<String>();
            for (Object constraint : constraints) {
                boolean satisfy;
                boolean bl = satisfy = !HiveTableUtil.requireEnableConstraint(requiredTrait) || (Boolean)isEnableMethod.invoke(constraint, new Object[0]) != false;
                if (satisfy) {
                    boolean bl2 = satisfy = !HiveTableUtil.requireValidateConstraint(requiredTrait) || (Boolean)isValidateMethod.invoke(constraint, new Object[0]) != false;
                }
                if (satisfy) {
                    boolean bl3 = satisfy = !HiveTableUtil.requireRelyConstraint(requiredTrait) || (Boolean)isRelyMethod.invoke(constraint, new Object[0]) != false;
                }
                if (satisfy) {
                    colNames.add((String)colNameMethod.invoke(constraint, new Object[0]));
                    continue;
                }
                return Optional.empty();
            }
            String pkName = (String)HiveReflectionUtils.invokeMethod(constraintClz, constraints.get(0), "getPk_name", null, null);
            return Optional.of(UniqueConstraint.primaryKey((String)pkName, colNames));
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if (t instanceof TApplicationException && t.getMessage() != null && t.getMessage().contains("Invalid method name")) {
                return Optional.empty();
            }
            throw new CatalogException("Failed to get PrimaryKey constraints", t);
        }
    }

    @Override
    public void createTableWithConstraints(IMetaStoreClient client, Table table, Configuration conf, UniqueConstraint pk, List<Byte> pkTraits, List<String> notNullCols, List<Byte> nnTraits) {
        if (!notNullCols.isEmpty()) {
            throw new UnsupportedOperationException("NOT NULL constraints not supported until 3.0.0");
        }
        try {
            List<Object> hivePKs = this.createHivePKs(table, pk, pkTraits);
            HiveReflectionUtils.invokeMethod(client.getClass(), client, "createTableWithConstraints", new Class[]{Table.class, List.class, List.class}, new Object[]{table, hivePKs, Collections.emptyList()});
        }
        catch (Exception e) {
            throw new CatalogException("Failed to create Hive table with constraints", (Throwable)e);
        }
    }

    List<Object> createHivePKs(Table table, UniqueConstraint pk, List<Byte> traits) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ArrayList<Object> res = new ArrayList<Object>();
        if (pk != null) {
            Class<?> pkClz = Class.forName("org.apache.hadoop.hive.metastore.api.SQLPrimaryKey");
            Constructor<?> constructor = pkClz.getConstructor(String.class, String.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            int seq = 1;
            Preconditions.checkArgument((pk.getColumns().size() == traits.size() ? 1 : 0) != 0, (Object)"Number of PK columns and traits mismatch");
            for (int i = 0; i < pk.getColumns().size(); ++i) {
                String col = (String)pk.getColumns().get(i);
                byte trait = traits.get(i);
                boolean enable = HiveTableUtil.requireEnableConstraint(trait);
                boolean validate = HiveTableUtil.requireValidateConstraint(trait);
                boolean rely = HiveTableUtil.requireRelyConstraint(trait);
                Object hivePK = constructor.newInstance(table.getDbName(), table.getTableName(), col, seq++, pk.getName(), enable, validate, rely);
                res.add(hivePK);
            }
        }
        return res;
    }
}

