/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShimV235;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.io.Writable;

public class HiveShimV310
extends HiveShimV235 {
    private static Class hiveTimestampClz;
    private static Constructor hiveTimestampConstructor;
    private static Field hiveTimestampLocalDateTime;
    private static Constructor timestampWritableConstructor;
    private static Class hiveDateClz;
    private static Constructor hiveDateConstructor;
    private static Field hiveDateLocalDate;
    private static Constructor dateWritableConstructor;
    private static boolean hiveClassesInited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initDateTimeClasses() {
        if (hiveClassesInited) return;
        Class<HiveShimV310> clazz = HiveShimV310.class;
        synchronized (HiveShimV310.class) {
            if (hiveClassesInited) return;
            try {
                hiveTimestampClz = Class.forName("org.apache.hadoop.hive.common.type.Timestamp");
                hiveTimestampConstructor = hiveTimestampClz.getDeclaredConstructor(LocalDateTime.class);
                hiveTimestampConstructor.setAccessible(true);
                hiveTimestampLocalDateTime = hiveTimestampClz.getDeclaredField("localDateTime");
                hiveTimestampLocalDateTime.setAccessible(true);
                timestampWritableConstructor = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritableV2").getDeclaredConstructor(hiveTimestampClz);
                hiveDateClz = Class.forName("org.apache.hadoop.hive.common.type.Date");
                hiveDateConstructor = hiveDateClz.getDeclaredConstructor(LocalDate.class);
                hiveDateConstructor.setAccessible(true);
                hiveDateLocalDate = hiveDateClz.getDeclaredField("localDate");
                hiveDateLocalDate.setAccessible(true);
                dateWritableConstructor = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritableV2").getDeclaredConstructor(hiveDateClz);
            }
            catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
                throw new FlinkHiveException("Failed to get Hive timestamp class and constructor", e);
            }
            hiveClassesInited = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) {
        try {
            Method method = RetryingMetaStoreClient.class.getMethod("getProxy", Configuration.class, Boolean.TYPE);
            return (IMetaStoreClient)method.invoke(null, hiveConf, true);
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to create Hive Metastore client", (Throwable)ex);
        }
    }

    @Override
    public Class<?> getMetaStoreUtilsClass() {
        try {
            return Class.forName("org.apache.hadoop.hive.metastore.utils.MetaStoreUtils");
        }
        catch (ClassNotFoundException e) {
            throw new CatalogException("Failed to find class MetaStoreUtils", (Throwable)e);
        }
    }

    @Override
    public Class<?> getHiveMetaStoreUtilsClass() {
        try {
            return Class.forName("org.apache.hadoop.hive.metastore.HiveMetaStoreUtils");
        }
        catch (ClassNotFoundException e) {
            throw new CatalogException("Failed to find class HiveMetaStoreUtils", (Throwable)e);
        }
    }

    @Override
    public Class<?> getDateDataTypeClass() {
        HiveShimV310.initDateTimeClasses();
        return hiveDateClz;
    }

    @Override
    public Class<?> getTimestampDataTypeClass() {
        HiveShimV310.initDateTimeClasses();
        return hiveTimestampClz;
    }

    @Override
    public Set<String> getNotNullColumns(IMetaStoreClient client, Configuration conf, String dbName, String tableName) {
        try {
            String hiveDefaultCatalog = this.getHMSDefaultCatalog(conf);
            Class<?> requestClz = Class.forName("org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest");
            Object request = requestClz.getDeclaredConstructor(String.class, String.class, String.class).newInstance(hiveDefaultCatalog, dbName, tableName);
            List constraints = (List)HiveReflectionUtils.invokeMethod(client.getClass(), client, "getNotNullConstraints", new Class[]{requestClz}, new Object[]{request});
            Class<?> constraintClz = Class.forName("org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint");
            Method colNameMethod = constraintClz.getDeclaredMethod("getColumn_name", new Class[0]);
            Method isRelyMethod = constraintClz.getDeclaredMethod("isRely_cstr", new Class[0]);
            HashSet<String> res = new HashSet<String>();
            for (Object constraint : constraints) {
                if (!((Boolean)isRelyMethod.invoke(constraint, new Object[0])).booleanValue()) continue;
                res.add((String)colNameMethod.invoke(constraint, new Object[0]));
            }
            return res;
        }
        catch (Exception e) {
            throw new CatalogException("Failed to get NOT NULL constraints", (Throwable)e);
        }
    }

    @Override
    public Object toHiveTimestamp(Object flinkTimestamp) {
        if (flinkTimestamp == null) {
            return null;
        }
        this.ensureSupportedFlinkTimestamp(flinkTimestamp);
        HiveShimV310.initDateTimeClasses();
        if (flinkTimestamp instanceof Timestamp) {
            flinkTimestamp = ((Timestamp)flinkTimestamp).toLocalDateTime();
        }
        try {
            return hiveTimestampConstructor.newInstance(flinkTimestamp);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FlinkHiveException("Failed to convert to Hive timestamp", e);
        }
    }

    @Override
    public LocalDateTime toFlinkTimestamp(Object hiveTimestamp) {
        HiveShimV310.initDateTimeClasses();
        Preconditions.checkArgument((boolean)hiveTimestampClz.isAssignableFrom(hiveTimestamp.getClass()), (String)"Expecting Hive timestamp to be an instance of %s, but actually got %s", (Object[])new Object[]{hiveTimestampClz.getName(), hiveTimestamp.getClass().getName()});
        try {
            return (LocalDateTime)hiveTimestampLocalDateTime.get(hiveTimestamp);
        }
        catch (IllegalAccessException e) {
            throw new FlinkHiveException("Failed to convert to Flink timestamp", e);
        }
    }

    @Override
    public Object toHiveDate(Object flinkDate) {
        if (flinkDate == null) {
            return null;
        }
        this.ensureSupportedFlinkDate(flinkDate);
        HiveShimV310.initDateTimeClasses();
        if (flinkDate instanceof Date) {
            flinkDate = ((Date)flinkDate).toLocalDate();
        }
        try {
            return hiveDateConstructor.newInstance(flinkDate);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FlinkHiveException("Failed to convert to Hive date", e);
        }
    }

    @Override
    public LocalDate toFlinkDate(Object hiveDate) {
        HiveShimV310.initDateTimeClasses();
        Preconditions.checkArgument((boolean)hiveDateClz.isAssignableFrom(hiveDate.getClass()), (String)"Expecting Hive date to be an instance of %s, but actually got %s", (Object[])new Object[]{hiveDateClz.getName(), hiveDate.getClass().getName()});
        try {
            return (LocalDate)hiveDateLocalDate.get(hiveDate);
        }
        catch (IllegalAccessException e) {
            throw new FlinkHiveException("Failed to convert to Flink date", e);
        }
    }

    @Override
    public Writable hivePrimitiveToWritable(Object value) {
        if (value == null) {
            return null;
        }
        Optional<Writable> optional = this.javaToWritable(value);
        if (optional.isPresent()) {
            return optional.get();
        }
        try {
            if (this.getDateDataTypeClass().isInstance(value)) {
                return (Writable)dateWritableConstructor.newInstance(value);
            }
            if (this.getTimestampDataTypeClass().isInstance(value)) {
                return (Writable)timestampWritableConstructor.newInstance(value);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FlinkHiveException("Failed to create writable objects", e);
        }
        throw new FlinkHiveException("Unsupported primitive java value of class " + value.getClass().getName());
    }

    @Override
    public void createTableWithConstraints(IMetaStoreClient client, Table table, Configuration conf, UniqueConstraint pk, List<Byte> pkTraits, List<String> notNullCols, List<Byte> nnTraits) {
        try {
            List<Object> hivePKs = this.createHivePKs(table, pk, pkTraits);
            List<Object> hiveNNs = this.createHiveNNs(table, conf, notNullCols, nnTraits);
            HiveReflectionUtils.invokeMethod(client.getClass(), client, "createTableWithConstraints", new Class[]{Table.class, List.class, List.class, List.class, List.class, List.class, List.class}, new Object[]{table, hivePKs, Collections.emptyList(), Collections.emptyList(), hiveNNs, Collections.emptyList(), Collections.emptyList()});
        }
        catch (Exception e) {
            throw new CatalogException("Failed to create Hive table with constraints", (Throwable)e);
        }
    }

    List<Object> createHiveNNs(Table table, Configuration conf, List<String> nnCols, List<Byte> traits) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        ArrayList<Object> res = new ArrayList<Object>();
        if (!nnCols.isEmpty()) {
            Preconditions.checkArgument((nnCols.size() == traits.size() ? 1 : 0) != 0, (Object)"Number of NN columns and traits mismatch");
            Class<?> nnClz = Class.forName("org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint");
            Constructor<?> constructor = nnClz.getConstructor(String.class, String.class, String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            String catName = this.getHMSDefaultCatalog(conf);
            for (int i = 0; i < nnCols.size(); ++i) {
                String col = nnCols.get(i);
                byte trait = traits.get(i);
                boolean enable = HiveTableUtil.requireEnableConstraint(trait);
                boolean validate = HiveTableUtil.requireValidateConstraint(trait);
                boolean rely = HiveTableUtil.requireRelyConstraint(trait);
                Object hiveNN = constructor.newInstance(catName, table.getDbName(), table.getTableName(), col, null, enable, validate, rely);
                res.add(hiveNN);
            }
        }
        return res;
    }

    String getHMSDefaultCatalog(Configuration conf) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)HiveReflectionUtils.invokeMethod(this.getMetaStoreUtilsClass(), null, "getDefaultCatalog", new Class[]{Configuration.class}, new Object[]{conf});
    }
}

