/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.functions.hive.HiveFunction;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.functions.hive.conversion.HiveObjectConversion;
import org.apache.flink.table.functions.hive.conversion.IdentityConversion;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Internal
public class HiveGenericUDAF
extends AggregateFunction<Object, GenericUDAFEvaluator.AggregationBuffer>
implements HiveFunction {
    private final HiveFunctionWrapper hiveFunctionWrapper;
    private final boolean isUDAFBridgeRequired;
    private Object[] constantArguments;
    private DataType[] argTypes;
    private transient GenericUDAFEvaluator partialEvaluator;
    private transient GenericUDAFEvaluator finalEvaluator;
    private transient ObjectInspector partialResultObjectInspector;
    private transient ObjectInspector finalResultObjectInspector;
    private transient HiveObjectConversion[] conversions;
    private transient boolean allIdentityConverter;
    private transient boolean initialized;
    private final HiveShim hiveShim;

    public HiveGenericUDAF(HiveFunctionWrapper funcWrapper, HiveShim hiveShim) {
        this(funcWrapper, false, hiveShim);
    }

    public HiveGenericUDAF(HiveFunctionWrapper funcWrapper, boolean isUDAFBridgeRequired, HiveShim hiveShim) {
        this.hiveFunctionWrapper = funcWrapper;
        this.isUDAFBridgeRequired = isUDAFBridgeRequired;
        this.hiveShim = hiveShim;
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        this.init();
    }

    private void init() throws HiveException {
        ObjectInspector[] inputInspectors = HiveInspectors.toInspectors(this.hiveShim, this.constantArguments, this.argTypes);
        this.partialEvaluator = this.createEvaluator(inputInspectors);
        this.partialResultObjectInspector = this.partialEvaluator.init(GenericUDAFEvaluator.Mode.PARTIAL1, inputInspectors);
        this.finalEvaluator = this.createEvaluator(inputInspectors);
        this.finalResultObjectInspector = this.finalEvaluator.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{this.partialResultObjectInspector});
        this.conversions = new HiveObjectConversion[inputInspectors.length];
        for (int i = 0; i < inputInspectors.length; ++i) {
            this.conversions[i] = HiveInspectors.getConversion(inputInspectors[i], this.argTypes[i].getLogicalType(), this.hiveShim);
        }
        this.allIdentityConverter = Arrays.stream(this.conversions).allMatch(conv -> conv instanceof IdentityConversion);
        this.initialized = true;
    }

    public GenericUDAFEvaluator createEvaluator(ObjectInspector[] inputInspectors) throws SemanticException {
        Object resolver = this.isUDAFBridgeRequired ? new GenericUDAFBridge((UDAF)this.hiveFunctionWrapper.createFunction()) : (GenericUDAFResolver2)this.hiveFunctionWrapper.createFunction();
        return resolver.getEvaluator((GenericUDAFParameterInfo)this.hiveShim.createUDAFParameterInfo(inputInspectors, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE));
    }

    public GenericUDAFEvaluator.AggregationBuffer createAccumulator() {
        try {
            if (!this.initialized) {
                this.init();
            }
            return this.partialEvaluator.getNewAggregationBuffer();
        }
        catch (Exception e) {
            throw new FlinkHiveUDFException(String.format("Failed to create accumulator for %s", this.hiveFunctionWrapper.getClassName()), e);
        }
    }

    public void accumulate(GenericUDAFEvaluator.AggregationBuffer acc, Object ... inputs) throws HiveException {
        if (!this.allIdentityConverter) {
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = this.conversions[i].toHiveObject(inputs[i]);
            }
        }
        this.partialEvaluator.iterate(acc, inputs);
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer accumulator, Iterable<GenericUDAFEvaluator.AggregationBuffer> its) throws HiveException {
        for (GenericUDAFEvaluator.AggregationBuffer buffer : its) {
            this.finalEvaluator.merge(accumulator, this.partialEvaluator.terminatePartial(buffer));
        }
    }

    public Object getValue(GenericUDAFEvaluator.AggregationBuffer accumulator) {
        try {
            return HiveInspectors.toFlinkObject(this.finalResultObjectInspector, this.finalEvaluator.terminate(accumulator), this.hiveShim);
        }
        catch (HiveException e) {
            throw new FlinkHiveUDFException(String.format("Failed to get final result on %s", this.hiveFunctionWrapper.getClassName()), e);
        }
    }

    @Override
    public void setArgumentTypesAndConstants(Object[] constantArguments, DataType[] argTypes) {
        this.constantArguments = constantArguments;
        this.argTypes = argTypes;
    }

    @Override
    public DataType getHiveResultType(Object[] constantArguments, DataType[] argTypes) {
        try {
            if (!this.initialized) {
                this.setArgumentTypesAndConstants(constantArguments, argTypes);
                this.init();
            }
            return HiveTypeUtil.toFlinkType(this.finalResultObjectInspector);
        }
        catch (Exception e) {
            throw new FlinkHiveUDFException(String.format("Failed to get Hive result type from %s", this.hiveFunctionWrapper.getClassName()), e);
        }
    }

    public TypeInformation getResultType() {
        return TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)this.getHiveResultType(this.constantArguments, this.argTypes));
    }

    public TypeInformation<GenericUDAFEvaluator.AggregationBuffer> getAccumulatorType() {
        return new GenericTypeInfo(GenericUDAFEvaluator.AggregationBuffer.class);
    }
}

