/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserDefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class HiveParserExpressionWalker
extends HiveParserDefaultGraphWalker {
    public HiveParserExpressionWalker(Dispatcher disp) {
        super(disp);
    }

    private boolean shouldByPass(Node childNode, Node parentNode) {
        if (parentNode instanceof HiveParserASTNode && ((HiveParserASTNode)parentNode).getType() == 946) {
            HiveParserASTNode parentOp = (HiveParserASTNode)parentNode;
            assert (parentOp.getChildCount() == 2 || parentOp.getChildCount() == 3);
            return parentOp.getChildCount() != 3 || childNode != parentOp.getChild(2);
        }
        return false;
    }

    @Override
    protected void walk(Node nd) throws SemanticException {
        this.opStack.push(nd);
        block0: while (!this.opStack.empty()) {
            Node node = (Node)this.opStack.peek();
            if (node.getChildren() == null || this.getDispatchedList().containsAll(node.getChildren())) {
                if (!this.getDispatchedList().contains(node)) {
                    this.dispatch(node, this.opStack);
                    this.opQueue.add(node);
                }
                this.opStack.pop();
                continue;
            }
            for (Node childNode : node.getChildren()) {
                if (this.getDispatchedList().contains(childNode)) continue;
                if (this.shouldByPass(childNode, node)) {
                    this.retMap.put(childNode, null);
                    continue block0;
                }
                this.opStack.push(childNode);
                continue block0;
            }
        }
    }
}

