/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;

public class HiveParserPTFInvocationSpec {
    PartitionedTableFunctionSpec function;

    public void setFunction(PartitionedTableFunctionSpec function) {
        this.function = function;
    }

    public PartitionedTableFunctionSpec getFunction() {
        return this.function;
    }

    public static class PartitionExpression {
        HiveParserASTNode expression;

        public PartitionExpression() {
        }

        public PartitionExpression(PartitionExpression peSpec) {
            this.expression = peSpec.getExpression();
        }

        public HiveParserASTNode getExpression() {
            return this.expression;
        }

        public void setExpression(HiveParserASTNode expression) {
            this.expression = expression;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expression == null ? 0 : this.expression.toStringTree().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isAssignableFrom(obj.getClass())) {
                return false;
            }
            PartitionExpression other = (PartitionExpression)obj;
            return !(this.expression == null ? other.expression != null : !this.expression.toStringTree().equals(other.expression.toStringTree()));
        }

        public String toString() {
            return this.expression.toStringTree();
        }
    }

    public static class PTFQueryInputSpec
    extends PTFInputSpec {
        String source;
        PTFInvocationSpec.PTFQueryInputType type;

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public PTFInvocationSpec.PTFQueryInputType getType() {
            return this.type;
        }

        public void setType(PTFInvocationSpec.PTFQueryInputType type) {
            this.type = type;
        }

        @Override
        public PTFInputSpec getInput() {
            return null;
        }

        @Override
        public String getQueryInputName() {
            return this.getSource();
        }

        @Override
        public PTFQueryInputSpec getQueryInput() {
            return this;
        }
    }

    public static abstract class PTFInputSpec {
        HiveParserASTNode astNode;

        public HiveParserASTNode getAstNode() {
            return this.astNode;
        }

        public void setAstNode(HiveParserASTNode astNode) {
            this.astNode = astNode;
        }

        public abstract PTFInputSpec getInput();

        public abstract String getQueryInputName();

        public abstract PTFQueryInputSpec getQueryInput();
    }

    public static class PartitionedTableFunctionSpec
    extends PTFInputSpec {
        String name;
        String alias;
        List<HiveParserASTNode> args;
        PartitioningSpec partitioning;
        PTFInputSpec input;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public List<HiveParserASTNode> getArgs() {
            return this.args;
        }

        public void setArgs(List<HiveParserASTNode> args) {
            this.args = args;
        }

        public PartitioningSpec getPartitioning() {
            return this.partitioning;
        }

        public void setPartitioning(PartitioningSpec partitioning) {
            this.partitioning = partitioning;
        }

        @Override
        public PTFInputSpec getInput() {
            return this.input;
        }

        public void setInput(PTFInputSpec input) {
            this.input = input;
        }

        public PartitionSpec getPartition() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getPartSpec();
        }

        public void setPartition(PartitionSpec partSpec) {
            this.partitioning = this.partitioning == null ? new PartitioningSpec() : this.partitioning;
            this.partitioning.setPartSpec(partSpec);
        }

        public OrderSpec getOrder() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getOrderSpec();
        }

        public void setOrder(OrderSpec orderSpec) {
            this.partitioning = this.partitioning == null ? new PartitioningSpec() : this.partitioning;
            this.partitioning.setOrderSpec(orderSpec);
        }

        public void addArg(HiveParserASTNode arg) {
            this.args = this.args == null ? new ArrayList() : this.args;
            this.args.add(arg);
        }

        @Override
        public String getQueryInputName() {
            return this.input.getQueryInputName();
        }

        @Override
        public PTFQueryInputSpec getQueryInput() {
            return this.input.getQueryInput();
        }
    }

    public static class PartitioningSpec {
        PartitionSpec partSpec;
        OrderSpec orderSpec;

        public PartitionSpec getPartSpec() {
            return this.partSpec;
        }

        public void setPartSpec(PartitionSpec partSpec) {
            this.partSpec = partSpec;
        }

        public OrderSpec getOrderSpec() {
            return this.orderSpec;
        }

        public void setOrderSpec(OrderSpec orderSpec) {
            this.orderSpec = orderSpec;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.orderSpec == null ? 0 : this.orderSpec.hashCode());
            result = 31 * result + (this.partSpec == null ? 0 : this.partSpec.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitioningSpec other = (PartitioningSpec)obj;
            if (this.orderSpec == null ? other.orderSpec != null : !this.orderSpec.equals(other.orderSpec)) {
                return false;
            }
            if (this.partSpec == null) {
                return other.partSpec == null;
            }
            return this.partSpec.equals(other.partSpec);
        }

        public String toString() {
            return String.format("PartitioningSpec=[%s%s]", this.partSpec == null ? "" : this.partSpec, this.orderSpec == null ? "" : this.orderSpec);
        }
    }

    public static class PartitionSpec {
        ArrayList<PartitionExpression> expressions;

        public ArrayList<PartitionExpression> getExpressions() {
            return this.expressions;
        }

        public void setExpressions(ArrayList<PartitionExpression> columns) {
            this.expressions = columns;
        }

        public void addExpression(PartitionExpression c) {
            this.expressions = this.expressions == null ? new ArrayList<PartitionExpression>() : this.expressions;
            this.expressions.add(c);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expressions == null ? 0 : this.expressions.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionSpec other = (PartitionSpec)obj;
            return !(this.expressions == null ? other.expressions != null : !this.expressions.equals(other.expressions));
        }

        public String toString() {
            return String.format("partitionColumns=%s", PTFUtils.toString(this.expressions));
        }
    }

    public static class OrderExpression
    extends PartitionExpression {
        PTFInvocationSpec.Order order = PTFInvocationSpec.Order.ASC;
        NullOrder nullOrder = NullOrder.NULLS_FIRST;

        public OrderExpression() {
        }

        public OrderExpression(PartitionExpression peSpec) {
            super(peSpec);
        }

        public PTFInvocationSpec.Order getOrder() {
            return this.order;
        }

        public void setOrder(PTFInvocationSpec.Order order) {
            this.order = order;
        }

        public NullOrder getNullOrder() {
            return this.nullOrder;
        }

        public void setNullOrder(NullOrder nullOrder) {
            this.nullOrder = nullOrder;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
            result = 31 * result + (this.nullOrder == null ? 0 : this.nullOrder.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrderExpression other = (OrderExpression)obj;
            if (this.order != other.order) {
                return false;
            }
            return this.nullOrder == other.nullOrder;
        }

        @Override
        public String toString() {
            return String.format("%s %s %s", new Object[]{super.toString(), this.order, this.nullOrder});
        }
    }

    public static class OrderSpec {
        ArrayList<OrderExpression> expressions;

        public ArrayList<OrderExpression> getExpressions() {
            return this.expressions;
        }

        public void addExpression(OrderExpression c) {
            this.expressions = this.expressions == null ? new ArrayList<OrderExpression>() : this.expressions;
            this.expressions.add(c);
        }

        protected void prefixBy(PartitionSpec pSpec) {
            if (pSpec == null || pSpec.getExpressions() == null) {
                return;
            }
            if (this.expressions == null) {
                this.expressions = new ArrayList();
            }
            for (int i = pSpec.getExpressions().size() - 1; i >= 0; --i) {
                this.expressions.add(0, new OrderExpression(pSpec.getExpressions().get(i)));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expressions == null ? 0 : this.expressions.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrderSpec other = (OrderSpec)obj;
            if (this.expressions == null) {
                return other.expressions == null;
            }
            return this.expressions.equals(other.expressions);
        }

        public String toString() {
            return String.format("orderColumns=%s", PTFUtils.toString(this.expressions));
        }
    }

    public static enum NullOrder {
        NULLS_FIRST,
        NULLS_LAST;

    }
}

