/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserQBParseInfo {
    private final boolean isSubQ;
    private String alias;
    private HiveParserASTNode joinExpr;
    private HiveParserASTNode hints;
    private final HashMap<String, HiveParserASTNode> aliasToSrc = new HashMap();
    private final HashMap<String, HiveParserASTNode> nameToDest = new HashMap();
    private final Map<String, List<String>> nameToDestSchema = new HashMap<String, List<String>>();
    private final Set<String> tableSampleAliases = new HashSet<String>();
    private final Map<HiveParserASTNode, String> exprToColumnAlias = new HashMap<HiveParserASTNode, String>();
    private final Map<String, HiveParserASTNode> destToSelExpr;
    private final HashMap<String, HiveParserASTNode> destToWhereExpr;
    private final HashMap<String, HiveParserASTNode> destToGroupby;
    private final Set<String> destRollups;
    private final Set<String> destCubes;
    private final Set<String> destGroupingSets;
    private final Map<String, HiveParserASTNode> destToHaving;
    private final Map<String, HiveParserASTNode> insertIntoTables;
    private final Map<String, HiveParserASTNode> insertOverwriteTables;
    private HiveParserASTNode queryFromExpr;
    private boolean isAnalyzeCommand;
    private boolean isNoScanAnalyzeCommand;
    private boolean isPartialScanAnalyzeCommand;
    private final HashMap<String, HiveParserBaseSemanticAnalyzer.TableSpec> tableSpecs;
    private final HashMap<String, HiveParserASTNode> destToClusterby;
    private final HashMap<String, HiveParserASTNode> destToDistributeby;
    private final HashMap<String, HiveParserASTNode> destToSortby;
    private final HashMap<String, ArrayList<HiveParserASTNode>> aliasToLateralViews;
    private final HashMap<String, HiveParserASTNode> destToLateralView = new HashMap();
    private final HashMap<String, HiveParserASTNode> destToOrderby;
    private final HashMap<String, AbstractMap.SimpleEntry<Integer, Integer>> destToLimit;
    private final int outerQueryLimit;
    private final LinkedHashMap<String, LinkedHashMap<String, HiveParserASTNode>> destToAggregationExprs;
    private final HashMap<String, List<HiveParserASTNode>> destToDistinctFuncExprs;
    private final LinkedHashMap<String, LinkedHashMap<String, HiveParserASTNode>> destToWindowingExprs;
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserQBParseInfo.class);

    public HiveParserQBParseInfo(String alias, boolean isSubQ) {
        this.destToSelExpr = new LinkedHashMap<String, HiveParserASTNode>();
        this.destToWhereExpr = new HashMap();
        this.destToGroupby = new HashMap();
        this.destToHaving = new HashMap<String, HiveParserASTNode>();
        this.destToClusterby = new HashMap();
        this.destToDistributeby = new HashMap();
        this.destToSortby = new HashMap();
        this.destToOrderby = new HashMap();
        this.destToLimit = new HashMap();
        this.insertIntoTables = new HashMap<String, HiveParserASTNode>();
        this.insertOverwriteTables = new HashMap<String, HiveParserASTNode>();
        this.destRollups = new HashSet<String>();
        this.destCubes = new HashSet<String>();
        this.destGroupingSets = new HashSet<String>();
        this.destToAggregationExprs = new LinkedHashMap();
        this.destToWindowingExprs = new LinkedHashMap();
        this.destToDistinctFuncExprs = new HashMap();
        this.alias = alias;
        this.isSubQ = isSubQ;
        this.outerQueryLimit = -1;
        this.aliasToLateralViews = new HashMap();
        this.tableSpecs = new HashMap();
    }

    public void setAggregationExprsForClause(String clause, LinkedHashMap<String, HiveParserASTNode> aggregationTrees) {
        this.destToAggregationExprs.put(clause, aggregationTrees);
    }

    public void addAggregationExprsForClause(String clause, LinkedHashMap<String, HiveParserASTNode> aggregationTrees) {
        if (this.destToAggregationExprs.containsKey(clause)) {
            this.destToAggregationExprs.get(clause).putAll(aggregationTrees);
        } else {
            this.destToAggregationExprs.put(clause, aggregationTrees);
        }
    }

    public void addInsertIntoTable(String fullName, HiveParserASTNode ast) {
        this.insertIntoTables.put(fullName.toLowerCase(), ast);
    }

    public boolean isInsertIntoTable(String dbName, String table) {
        String fullName = dbName + "." + table;
        return this.insertIntoTables.containsKey(fullName.toLowerCase());
    }

    public HashMap<String, HiveParserASTNode> getAggregationExprsForClause(String clause) {
        return this.destToAggregationExprs.get(clause);
    }

    public void addWindowingExprToClause(String clause, HiveParserASTNode windowingExprNode) {
        LinkedHashMap windowingExprs = this.destToWindowingExprs.computeIfAbsent(clause, k -> new LinkedHashMap());
        windowingExprs.put(windowingExprNode.toStringTree(), windowingExprNode);
    }

    public HashMap<String, HiveParserASTNode> getWindowingExprsForClause(String clause) {
        return this.destToWindowingExprs.get(clause);
    }

    public void setDistinctFuncExprsForClause(String clause, List<HiveParserASTNode> ast) {
        this.destToDistinctFuncExprs.put(clause, ast);
    }

    public List<HiveParserASTNode> getDistinctFuncExprsForClause(String clause) {
        return this.destToDistinctFuncExprs.get(clause);
    }

    public void setSelExprForClause(String clause, HiveParserASTNode ast) {
        this.destToSelExpr.put(clause, ast);
    }

    public void setQueryFromExpr(HiveParserASTNode ast) {
        this.queryFromExpr = ast;
    }

    public void setWhrExprForClause(String clause, HiveParserASTNode ast) {
        this.destToWhereExpr.put(clause, ast);
    }

    public void setHavingExprForClause(String clause, HiveParserASTNode ast) {
        this.destToHaving.put(clause, ast);
    }

    public void setGroupByExprForClause(String clause, HiveParserASTNode ast) {
        this.destToGroupby.put(clause, ast);
    }

    public void setDestForClause(String clause, HiveParserASTNode ast) {
        this.nameToDest.put(clause, ast);
    }

    List<String> setDestSchemaForClause(String clause, List<String> columnList) {
        return this.nameToDestSchema.put(clause, columnList);
    }

    public List<String> getDestSchemaForClause(String clause) {
        return this.nameToDestSchema.get(clause);
    }

    public void setClusterByExprForClause(String clause, HiveParserASTNode ast) {
        this.destToClusterby.put(clause, ast);
    }

    public void setDistributeByExprForClause(String clause, HiveParserASTNode ast) {
        this.destToDistributeby.put(clause, ast);
    }

    public void setSortByExprForClause(String clause, HiveParserASTNode ast) {
        this.destToSortby.put(clause, ast);
    }

    public void setOrderByExprForClause(String clause, HiveParserASTNode ast) {
        this.destToOrderby.put(clause, ast);
    }

    public void setSrcForAlias(String alias, HiveParserASTNode ast) {
        this.aliasToSrc.put(alias.toLowerCase(), ast);
    }

    public Set<String> getClauseNames() {
        return this.destToSelExpr.keySet();
    }

    public Set<String> getClauseNamesForDest() {
        return this.nameToDest.keySet();
    }

    public HiveParserASTNode getDestForClause(String clause) {
        return this.nameToDest.get(clause);
    }

    public HashMap<String, HiveParserASTNode> getDestToWhereExpr() {
        return this.destToWhereExpr;
    }

    public HiveParserASTNode getGroupByForClause(String clause) {
        return this.destToGroupby.get(clause);
    }

    public Set<String> getDestRollups() {
        return this.destRollups;
    }

    public Set<String> getDestCubes() {
        return this.destCubes;
    }

    public Set<String> getDestGroupingSets() {
        return this.destGroupingSets;
    }

    public HashMap<String, HiveParserASTNode> getDestToGroupBy() {
        return this.destToGroupby;
    }

    public HiveParserASTNode getHavingForClause(String clause) {
        return this.destToHaving.get(clause);
    }

    public HiveParserASTNode getSelForClause(String clause) {
        return this.destToSelExpr.get(clause);
    }

    public HiveParserASTNode getQueryFrom() {
        return this.queryFromExpr;
    }

    public HiveParserASTNode getClusterByForClause(String clause) {
        return this.destToClusterby.get(clause);
    }

    public HashMap<String, HiveParserASTNode> getDestToClusterBy() {
        return this.destToClusterby;
    }

    public HiveParserASTNode getDistributeByForClause(String clause) {
        return this.destToDistributeby.get(clause);
    }

    public HashMap<String, HiveParserASTNode> getDestToDistributeBy() {
        return this.destToDistributeby;
    }

    public HiveParserASTNode getSortByForClause(String clause) {
        return this.destToSortby.get(clause);
    }

    public HiveParserASTNode getOrderByForClause(String clause) {
        return this.destToOrderby.get(clause);
    }

    public HashMap<String, HiveParserASTNode> getDestToSortBy() {
        return this.destToSortby;
    }

    public HashMap<String, HiveParserASTNode> getDestToOrderBy() {
        return this.destToOrderby;
    }

    public HiveParserASTNode getSrcForAlias(String alias) {
        return this.aliasToSrc.get(alias.toLowerCase());
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean getIsSubQ() {
        return this.isSubQ;
    }

    public HiveParserASTNode getJoinExpr() {
        return this.joinExpr;
    }

    public void setJoinExpr(HiveParserASTNode joinExpr) {
        this.joinExpr = joinExpr;
    }

    public boolean needTableSample(String alias) {
        return this.tableSampleAliases.contains(alias.toLowerCase());
    }

    public void setTabSample(String alias) {
        this.tableSampleAliases.add(alias.toLowerCase());
    }

    public Map<HiveParserASTNode, String> getAllExprToColumnAlias() {
        return this.exprToColumnAlias;
    }

    public void setExprToColumnAlias(HiveParserASTNode expr, String alias) {
        this.exprToColumnAlias.put(expr, alias);
    }

    public void setDestLimit(String dest, Integer offset, Integer limit) {
        this.destToLimit.put(dest, new AbstractMap.SimpleEntry<Integer, Integer>(offset, limit));
    }

    public Integer getDestLimit(String dest) {
        return this.destToLimit.get(dest) == null ? null : this.destToLimit.get(dest).getValue();
    }

    public boolean isSimpleSelectQuery() {
        if (!(this.joinExpr == null && this.destToOrderby.isEmpty() && this.destToSortby.isEmpty() && this.destToGroupby.isEmpty() && this.destToClusterby.isEmpty() && this.destToDistributeby.isEmpty() && this.destRollups.isEmpty() && this.destCubes.isEmpty() && this.destGroupingSets.isEmpty() && this.destToHaving.isEmpty())) {
            return false;
        }
        for (Map map : this.destToAggregationExprs.values()) {
            if (map == null || map.isEmpty()) continue;
            return false;
        }
        for (Map map : this.destToWindowingExprs.values()) {
            if (map == null || map.isEmpty()) continue;
            return false;
        }
        for (List list : this.destToDistinctFuncExprs.values()) {
            if (list.isEmpty()) continue;
            return false;
        }
        for (HiveParserASTNode hiveParserASTNode : this.nameToDest.values()) {
            if (hiveParserASTNode.getChild(0).getType() == 990) continue;
            return false;
        }
        return true;
    }

    public void setHints(HiveParserASTNode hint) {
        this.hints = hint;
    }

    public HiveParserASTNode getHints() {
        return this.hints;
    }

    public Map<String, ArrayList<HiveParserASTNode>> getAliasToLateralViews() {
        return this.aliasToLateralViews;
    }

    public void addLateralViewForAlias(String alias, HiveParserASTNode lateralView) {
        ArrayList lateralViews = this.aliasToLateralViews.computeIfAbsent(alias, k -> new ArrayList());
        lateralViews.add(lateralView);
    }

    public void setIsAnalyzeCommand(boolean isAnalyzeCommand) {
        this.isAnalyzeCommand = isAnalyzeCommand;
    }

    public boolean isAnalyzeCommand() {
        return this.isAnalyzeCommand;
    }

    public void addTableSpec(String tName, HiveParserBaseSemanticAnalyzer.TableSpec tSpec) {
        this.tableSpecs.put(tName, tSpec);
    }

    public HashMap<String, AbstractMap.SimpleEntry<Integer, Integer>> getDestToLimit() {
        return this.destToLimit;
    }

    public HashMap<String, HiveParserASTNode> getDestToLateralView() {
        return this.destToLateralView;
    }

    public void setNoScanAnalyzeCommand(boolean isNoScanAnalyzeCommand) {
        this.isNoScanAnalyzeCommand = isNoScanAnalyzeCommand;
    }

    public boolean isPartialScanAnalyzeCommand() {
        return this.isPartialScanAnalyzeCommand;
    }

    public void setPartialScanAnalyzeCommand(boolean isPartialScanAnalyzeCommand) {
        this.isPartialScanAnalyzeCommand = isPartialScanAnalyzeCommand;
    }

    public Map<String, HiveParserASTNode> getInsertOverwriteTables() {
        return this.insertOverwriteTables;
    }
}

