/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.catalog.PostgresTablePath;
import org.apache.flink.connector.jdbc.table.JdbcConnectorOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PostgresCatalog
extends AbstractJdbcCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresCatalog.class);
    public static final String DEFAULT_DATABASE = "postgres";
    private static final Set<String> builtinDatabases = new HashSet<String>(){
        {
            this.add("template0");
            this.add("template1");
        }
    };
    private static final Set<String> builtinSchemas = new HashSet<String>(){
        {
            this.add("pg_toast");
            this.add("pg_temp_1");
            this.add("pg_toast_temp_1");
            this.add("pg_catalog");
            this.add("information_schema");
        }
    };
    public static final String PG_SERIAL = "serial";
    public static final String PG_BIGSERIAL = "bigserial";
    public static final String PG_BYTEA = "bytea";
    public static final String PG_BYTEA_ARRAY = "_bytea";
    public static final String PG_SMALLINT = "int2";
    public static final String PG_SMALLINT_ARRAY = "_int2";
    public static final String PG_INTEGER = "int4";
    public static final String PG_INTEGER_ARRAY = "_int4";
    public static final String PG_BIGINT = "int8";
    public static final String PG_BIGINT_ARRAY = "_int8";
    public static final String PG_REAL = "float4";
    public static final String PG_REAL_ARRAY = "_float4";
    public static final String PG_DOUBLE_PRECISION = "float8";
    public static final String PG_DOUBLE_PRECISION_ARRAY = "_float8";
    public static final String PG_NUMERIC = "numeric";
    public static final String PG_NUMERIC_ARRAY = "_numeric";
    public static final String PG_BOOLEAN = "bool";
    public static final String PG_BOOLEAN_ARRAY = "_bool";
    public static final String PG_TIMESTAMP = "timestamp";
    public static final String PG_TIMESTAMP_ARRAY = "_timestamp";
    public static final String PG_TIMESTAMPTZ = "timestamptz";
    public static final String PG_TIMESTAMPTZ_ARRAY = "_timestamptz";
    public static final String PG_DATE = "date";
    public static final String PG_DATE_ARRAY = "_date";
    public static final String PG_TIME = "time";
    public static final String PG_TIME_ARRAY = "_time";
    public static final String PG_TEXT = "text";
    public static final String PG_TEXT_ARRAY = "_text";
    public static final String PG_CHAR = "bpchar";
    public static final String PG_CHAR_ARRAY = "_bpchar";
    public static final String PG_CHARACTER = "character";
    public static final String PG_CHARACTER_ARRAY = "_character";
    public static final String PG_CHARACTER_VARYING = "varchar";
    public static final String PG_CHARACTER_VARYING_ARRAY = "_varchar";

    protected PostgresCatalog(String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        super(catalogName, defaultDatabase, username, pwd, baseUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatabases() throws CatalogException {
        ArrayList<String> pgDatabases = new ArrayList<String>();
        try (Connection conn = DriverManager.getConnection(this.defaultUrl, this.username, this.pwd);){
            PreparedStatement ps = conn.prepareStatement("SELECT datname FROM pg_database;");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String dbName = rs.getString(1);
                if (builtinDatabases.contains(dbName)) continue;
                pgDatabases.add(rs.getString(1));
            }
            ArrayList<String> arrayList = pgDatabases;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.getName()), (Throwable)e);
        }
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (this.listDatabases().contains(databaseName)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        try (Connection conn = DriverManager.getConnection(this.baseUrl + databaseName, this.username, this.pwd);){
            PreparedStatement ps = conn.prepareStatement("SELECT schema_name FROM information_schema.schemata;");
            ResultSet rs = ps.executeQuery();
            ArrayList<String> schemas = new ArrayList<String>();
            while (rs.next()) {
                String pgSchema = rs.getString(1);
                if (builtinSchemas.contains(pgSchema)) continue;
                schemas.add(pgSchema);
            }
            ArrayList<String> tables = new ArrayList<String>();
            for (String schema : schemas) {
                PreparedStatement stmt = conn.prepareStatement("SELECT * \nFROM information_schema.tables \nWHERE table_type = 'BASE TABLE' \n    AND table_schema = ? \nORDER BY table_type, table_name;");
                stmt.setString(1, schema);
                ResultSet rstables = stmt.executeQuery();
                while (rstables.next()) {
                    tables.add(schema + "." + rstables.getString(3));
                }
            }
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.getName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        PostgresTablePath pgPath = PostgresTablePath.fromFlinkTableName(tablePath.getObjectName());
        String dbUrl = this.baseUrl + tablePath.getDatabaseName();
        try (Connection conn = DriverManager.getConnection(dbUrl, this.username, this.pwd);){
            DatabaseMetaData metaData = conn.getMetaData();
            Optional<UniqueConstraint> primaryKey = this.getPrimaryKey(metaData, pgPath.getPgSchemaName(), pgPath.getPgTableName());
            PreparedStatement ps = conn.prepareStatement(String.format("SELECT * FROM %s;", pgPath.getFullPath()));
            ResultSetMetaData rsmd = ps.getMetaData();
            String[] names = new String[rsmd.getColumnCount()];
            DataType[] types = new DataType[rsmd.getColumnCount()];
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                names[i - 1] = rsmd.getColumnName(i);
                types[i - 1] = this.fromJDBCType(rsmd, i);
                if (rsmd.isNullable(i) != 0) continue;
                types[i - 1] = (DataType)types[i - 1].notNull();
            }
            TableSchema.Builder tableBuilder = new TableSchema.Builder().fields(names, types);
            primaryKey.ifPresent(pk -> tableBuilder.primaryKey(pk.getName(), pk.getColumns().toArray(new String[0])));
            TableSchema tableSchema = tableBuilder.build();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(FactoryUtil.CONNECTOR.key(), "jdbc");
            props.put(JdbcConnectorOptions.URL.key(), dbUrl);
            props.put(JdbcConnectorOptions.TABLE_NAME.key(), pgPath.getFullPath());
            props.put(JdbcConnectorOptions.USERNAME.key(), this.username);
            props.put(JdbcConnectorOptions.PASSWORD.key(), this.pwd);
            CatalogTableImpl catalogTableImpl = new CatalogTableImpl(tableSchema, props, "");
            return catalogTableImpl;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    private DataType fromJDBCType(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String pgType = metadata.getColumnTypeName(colIndex);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (pgType) {
            case "bool": {
                return DataTypes.BOOLEAN();
            }
            case "_bool": {
                return DataTypes.ARRAY((DataType)DataTypes.BOOLEAN());
            }
            case "bytea": {
                return DataTypes.BYTES();
            }
            case "_bytea": {
                return DataTypes.ARRAY((DataType)DataTypes.BYTES());
            }
            case "int2": {
                return DataTypes.SMALLINT();
            }
            case "_int2": {
                return DataTypes.ARRAY((DataType)DataTypes.SMALLINT());
            }
            case "int4": 
            case "serial": {
                return DataTypes.INT();
            }
            case "_int4": {
                return DataTypes.ARRAY((DataType)DataTypes.INT());
            }
            case "int8": 
            case "bigserial": {
                return DataTypes.BIGINT();
            }
            case "_int8": {
                return DataTypes.ARRAY((DataType)DataTypes.BIGINT());
            }
            case "float4": {
                return DataTypes.FLOAT();
            }
            case "_float4": {
                return DataTypes.ARRAY((DataType)DataTypes.FLOAT());
            }
            case "float8": {
                return DataTypes.DOUBLE();
            }
            case "_float8": {
                return DataTypes.ARRAY((DataType)DataTypes.DOUBLE());
            }
            case "numeric": {
                if (precision > 0) {
                    return DataTypes.DECIMAL((int)precision, (int)metadata.getScale(colIndex));
                }
                return DataTypes.DECIMAL((int)38, (int)18);
            }
            case "_numeric": {
                if (precision > 0) {
                    return DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)precision, (int)metadata.getScale(colIndex)));
                }
                return DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)38, (int)18));
            }
            case "bpchar": 
            case "character": {
                return DataTypes.CHAR((int)precision);
            }
            case "_bpchar": 
            case "_character": {
                return DataTypes.ARRAY((DataType)DataTypes.CHAR((int)precision));
            }
            case "varchar": {
                return DataTypes.VARCHAR((int)precision);
            }
            case "_varchar": {
                return DataTypes.ARRAY((DataType)DataTypes.VARCHAR((int)precision));
            }
            case "text": {
                return DataTypes.STRING();
            }
            case "_text": {
                return DataTypes.ARRAY((DataType)DataTypes.STRING());
            }
            case "timestamp": {
                return DataTypes.TIMESTAMP((int)scale);
            }
            case "_timestamp": {
                return DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP((int)scale));
            }
            case "timestamptz": {
                return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)scale);
            }
            case "_timestamptz": {
                return DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)scale));
            }
            case "time": {
                return DataTypes.TIME((int)scale);
            }
            case "_time": {
                return DataTypes.ARRAY((DataType)DataTypes.TIME((int)scale));
            }
            case "date": {
                return DataTypes.DATE();
            }
            case "_date": {
                return DataTypes.ARRAY((DataType)DataTypes.DATE());
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support Postgres type '%s' yet", pgType));
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        List<String> tables = null;
        try {
            tables = this.listTables(tablePath.getDatabaseName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
        return tables.contains(PostgresTablePath.fromFlinkTableName(tablePath.getObjectName()).getFullPath());
    }
}

