/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.converter;

import java.lang.reflect.Array;
import org.apache.flink.connector.jdbc.internal.converter.AbstractJdbcRowConverter;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.postgresql.jdbc.PgArray;
import org.postgresql.util.PGobject;

public class PostgresRowConverter
extends AbstractJdbcRowConverter {
    private static final long serialVersionUID = 1L;

    @Override
    public String converterName() {
        return "PostgreSQL";
    }

    public PostgresRowConverter(RowType rowType) {
        super(rowType);
    }

    @Override
    public AbstractJdbcRowConverter.JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        LogicalTypeRoot root = type.getTypeRoot();
        if (root == LogicalTypeRoot.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            return this.createPostgresArrayConverter(arrayType);
        }
        return this.createPrimitiveConverter(type);
    }

    @Override
    protected AbstractJdbcRowConverter.JdbcSerializationConverter createNullableExternalConverter(LogicalType type) {
        LogicalTypeRoot root = type.getTypeRoot();
        if (root == LogicalTypeRoot.ARRAY) {
            return (val, index, statement) -> {
                throw new IllegalStateException(String.format("Writing ARRAY type is not yet supported in JDBC:%s.", this.converterName()));
            };
        }
        return super.createNullableExternalConverter(type);
    }

    private AbstractJdbcRowConverter.JdbcDeserializationConverter createPostgresArrayConverter(ArrayType arrayType) {
        if (LogicalTypeChecks.hasFamily((LogicalType)arrayType.getElementType(), (LogicalTypeFamily)LogicalTypeFamily.BINARY_STRING)) {
            Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
            AbstractJdbcRowConverter.JdbcDeserializationConverter elementConverter = this.createNullableInternalConverter(arrayType.getElementType());
            return val -> {
                PgArray pgArray = (PgArray)val;
                Object[] in = (Object[])pgArray.getArray();
                Object[] array = (Object[])Array.newInstance(elementClass, in.length);
                for (int i = 0; i < in.length; ++i) {
                    array[i] = elementConverter.deserialize(((PGobject)in[i]).getValue().getBytes());
                }
                return new GenericArrayData(array);
            };
        }
        Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
        AbstractJdbcRowConverter.JdbcDeserializationConverter elementConverter = this.createNullableInternalConverter(arrayType.getElementType());
        return val -> {
            PgArray pgArray = (PgArray)val;
            Object[] in = (Object[])pgArray.getArray();
            Object[] array = (Object[])Array.newInstance(elementClass, in.length);
            for (int i = 0; i < in.length; ++i) {
                array[i] = elementConverter.deserialize(in[i]);
            }
            return new GenericArrayData(array);
        };
    }

    private AbstractJdbcRowConverter.JdbcDeserializationConverter createPrimitiveConverter(LogicalType type) {
        return super.createInternalConverter(type);
    }
}

