/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.testutils;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Properties;
import org.apache.flink.connectors.test.common.external.SourceSplitDataWriter;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;

public class KafkaPartitionDataWriter
implements SourceSplitDataWriter<String> {
    private final KafkaProducer<byte[], byte[]> kafkaProducer;
    private final TopicPartition topicPartition;

    public KafkaPartitionDataWriter(Properties producerProperties, TopicPartition topicPartition) {
        this.kafkaProducer = new KafkaProducer(producerProperties);
        this.topicPartition = topicPartition;
    }

    public void writeRecords(Collection<String> records) {
        for (String record : records) {
            ProducerRecord producerRecord = new ProducerRecord(this.topicPartition.topic(), Integer.valueOf(this.topicPartition.partition()), null, (Object)record.getBytes(StandardCharsets.UTF_8));
            this.kafkaProducer.send(producerRecord);
        }
        this.kafkaProducer.flush();
    }

    public void close() {
        this.kafkaProducer.close();
    }
}

