/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.testutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplit;
import org.apache.flink.streaming.connectors.kafka.KafkaTestBase;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;

public class KafkaSourceTestEnv
extends KafkaTestBase {
    public static final String GROUP_ID = "KafkaSourceTestEnv";
    public static final int NUM_PARTITIONS = 10;
    public static final int NUM_RECORDS_PER_PARTITION = 10;
    private static AdminClient adminClient;
    private static KafkaConsumer<String, Integer> consumer;

    public static void setup() throws Throwable {
        KafkaSourceTestEnv.prepare();
        adminClient = KafkaSourceTestEnv.getAdminClient();
        consumer = KafkaSourceTestEnv.getConsumer();
    }

    public static void tearDown() throws Exception {
        consumer.close();
        adminClient.close();
        KafkaSourceTestEnv.shutDownServices();
    }

    public static AdminClient getAdminClient() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)standardProps);
        return AdminClient.create((Properties)props);
    }

    public static KafkaConsumer<String, Integer> getConsumer() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)standardProps);
        props.setProperty("group.id", GROUP_ID);
        props.setProperty("key.deserializer", StringDeserializer.class.getName());
        props.setProperty("value.deserializer", IntegerDeserializer.class.getName());
        return new KafkaConsumer(props);
    }

    public static Properties getConsumerProperties(Class<?> deserializerClass) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)standardProps);
        props.setProperty("group.id", GROUP_ID);
        props.setProperty("key.deserializer", deserializerClass.getName());
        props.setProperty("value.deserializer", deserializerClass.getName());
        return props;
    }

    public static Map<Integer, Map<String, KafkaPartitionSplit>> getSplitsByOwners(Collection<String> topics, int numSubtasks) {
        HashMap<Integer, Map<String, KafkaPartitionSplit>> splitsByOwners = new HashMap<Integer, Map<String, KafkaPartitionSplit>>();
        for (String topic : topics) {
            KafkaSourceTestEnv.getPartitionsForTopic(topic).forEach(tp -> {
                int ownerReader = Math.abs(tp.hashCode()) % numSubtasks;
                KafkaPartitionSplit split = new KafkaPartitionSplit(tp, KafkaSourceTestEnv.getEarliestOffset(tp), 10L);
                splitsByOwners.computeIfAbsent(ownerReader, r -> new HashMap()).put(KafkaPartitionSplit.toSplitId((TopicPartition)tp), split);
            });
        }
        return splitsByOwners;
    }

    public static List<ProducerRecord<String, Integer>> getRecordsForPartition(TopicPartition tp) {
        ArrayList<ProducerRecord<String, Integer>> records = new ArrayList<ProducerRecord<String, Integer>>();
        for (int i = 0; i < 10; ++i) {
            records.add((ProducerRecord<String, Integer>)new ProducerRecord(tp.topic(), Integer.valueOf(tp.partition()), Long.valueOf((long)i * 1000L), (Object)tp.toString(), (Object)i));
        }
        return records;
    }

    public static List<ProducerRecord<String, Integer>> getRecordsForPartitionWithoutTimestamp(TopicPartition tp) {
        ArrayList<ProducerRecord<String, Integer>> records = new ArrayList<ProducerRecord<String, Integer>>();
        for (int i = 0; i < 10; ++i) {
            records.add((ProducerRecord<String, Integer>)new ProducerRecord(tp.topic(), Integer.valueOf(tp.partition()), null, (Object)tp.toString(), (Object)i));
        }
        return records;
    }

    public static List<ProducerRecord<String, Integer>> getRecordsForTopic(String topic) {
        ArrayList<ProducerRecord<String, Integer>> records = new ArrayList<ProducerRecord<String, Integer>>();
        for (TopicPartition tp : KafkaSourceTestEnv.getPartitionsForTopic(topic)) {
            records.addAll(KafkaSourceTestEnv.getRecordsForPartition(tp));
        }
        return records;
    }

    public static List<ProducerRecord<String, Integer>> getRecordsForTopicWithoutTimestamp(String topic) {
        ArrayList<ProducerRecord<String, Integer>> records = new ArrayList<ProducerRecord<String, Integer>>();
        for (TopicPartition tp : KafkaSourceTestEnv.getPartitionsForTopic(topic)) {
            records.addAll(KafkaSourceTestEnv.getRecordsForPartitionWithoutTimestamp(tp));
        }
        return records;
    }

    public static List<TopicPartition> getPartitionsForTopics(Collection<String> topics) {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        topics.forEach(t -> partitions.addAll(KafkaSourceTestEnv.getPartitionsForTopic(t)));
        return partitions;
    }

    public static List<TopicPartition> getPartitionsForTopic(String topic) {
        return consumer.partitionsFor(topic).stream().map(pi -> new TopicPartition(pi.topic(), pi.partition())).collect(Collectors.toList());
    }

    public static Map<TopicPartition, Long> getEarliestOffsets(List<TopicPartition> partitions) {
        HashMap<TopicPartition, Long> earliestOffsets = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : partitions) {
            earliestOffsets.put(tp, KafkaSourceTestEnv.getEarliestOffset(tp));
        }
        return earliestOffsets;
    }

    public static Map<TopicPartition, OffsetAndMetadata> getCommittedOffsets(List<TopicPartition> partitions) {
        HashMap<TopicPartition, OffsetAndMetadata> committedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (TopicPartition tp : partitions) {
            committedOffsets.put(tp, new OffsetAndMetadata((long)(tp.partition() + 2)));
        }
        return committedOffsets;
    }

    public static long getEarliestOffset(TopicPartition tp) {
        return tp.partition();
    }

    public static void createTestTopic(String topic) {
        KafkaSourceTestEnv.createTestTopic((String)topic, (int)10, (int)1);
    }

    public static void setupEarliestOffsets(String topic) throws Throwable {
        List<TopicPartition> partitions = KafkaSourceTestEnv.getPartitionsForTopic(topic);
        HashMap toDelete = new HashMap();
        KafkaSourceTestEnv.getEarliestOffsets(partitions).forEach((tp, offset) -> toDelete.put(tp, RecordsToDelete.beforeOffset((long)offset)));
        adminClient.deleteRecords(toDelete).all().get();
    }

    public static void setupCommittedOffsets(String topic) throws ExecutionException, InterruptedException {
        List<TopicPartition> partitions = KafkaSourceTestEnv.getPartitionsForTopic(topic);
        Map<TopicPartition, OffsetAndMetadata> committedOffsets = KafkaSourceTestEnv.getCommittedOffsets(partitions);
        consumer.commitSync(committedOffsets);
        Map toVerify = (Map)adminClient.listConsumerGroupOffsets(GROUP_ID, new ListConsumerGroupOffsetsOptions().topicPartitions(new ArrayList<TopicPartition>(committedOffsets.keySet()))).partitionsToOffsetAndMetadata().get();
        Assert.assertEquals((String)"The offsets are not committed", committedOffsets, (Object)toVerify);
    }

    public static void produceToKafka(Collection<ProducerRecord<String, Integer>> records) throws Throwable {
        KafkaSourceTestEnv.produceToKafka(records, StringSerializer.class, IntegerSerializer.class);
    }

    public static void setupTopic(String topic, boolean setupEarliestOffsets, boolean setupCommittedOffsets, Function<String, List<ProducerRecord<String, Integer>>> testDataGenerator) throws Throwable {
        KafkaSourceTestEnv.createTestTopic(topic);
        KafkaSourceTestEnv.produceToKafka((Collection<ProducerRecord<String, Integer>>)testDataGenerator.apply(topic));
        if (setupEarliestOffsets) {
            KafkaSourceTestEnv.setupEarliestOffsets(topic);
        }
        if (setupCommittedOffsets) {
            KafkaSourceTestEnv.setupCommittedOffsets(topic);
        }
    }
}

