/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.io.File;
import java.net.BindException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.io.FileUtils;
import org.apache.curator.test.TestingServer;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaUtil;
import org.apache.flink.connector.kafka.source.KafkaSource;
import org.apache.flink.connector.kafka.source.KafkaSourceBuilder;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaRecordDeserializationSchema;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.KafkaSerializationSchema;
import org.apache.flink.streaming.connectors.kafka.KafkaTestEnvironment;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.util.serialization.KeyedSerializationSchema;
import org.apache.flink.util.NetUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.ArraySeq;

public class KafkaTestEnvironmentImpl
extends KafkaTestEnvironment {
    protected static final Logger LOG = LoggerFactory.getLogger(KafkaTestEnvironmentImpl.class);
    private final List<KafkaServer> brokers = new ArrayList<KafkaServer>();
    private File tmpZkDir;
    private File tmpKafkaParent;
    private List<File> tmpKafkaDirs;
    private TestingServer zookeeper;
    private String zookeeperConnectionString;
    private String brokerConnectionString = "";
    private Properties standardProps;
    private FlinkKafkaProducer.Semantic producerSemantic = FlinkKafkaProducer.Semantic.EXACTLY_ONCE;
    private int zkTimeout = 30000;
    private KafkaTestEnvironment.Config config;
    private static final int DELETE_TIMEOUT_SECONDS = 30;

    public void setProducerSemantic(FlinkKafkaProducer.Semantic producerSemantic) {
        this.producerSemantic = producerSemantic;
    }

    @Override
    public void prepare(KafkaTestEnvironment.Config config) throws Exception {
        if (config.isSecureMode()) {
            config.setKafkaServersNumber(1);
            this.zkTimeout *= 15;
        }
        this.config = config;
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        this.tmpZkDir = new File(tempDir, "kafkaITcase-zk-dir-" + UUID.randomUUID());
        Assert.assertTrue((String)"cannot create zookeeper temp dir", (boolean)this.tmpZkDir.mkdirs());
        this.tmpKafkaParent = new File(tempDir, "kafkaITcase-kafka-dir-" + UUID.randomUUID());
        Assert.assertTrue((String)"cannot create kafka temp dir", (boolean)this.tmpKafkaParent.mkdirs());
        this.tmpKafkaDirs = new ArrayList<File>(config.getKafkaServersNumber());
        for (int i = 0; i < config.getKafkaServersNumber(); ++i) {
            File tmpDir = new File(this.tmpKafkaParent, "server-" + i);
            Assert.assertTrue((String)"cannot create kafka temp dir", (boolean)tmpDir.mkdir());
            this.tmpKafkaDirs.add(tmpDir);
        }
        this.zookeeper = null;
        this.brokers.clear();
        this.zookeeper = new TestingServer(-1, this.tmpZkDir);
        this.zookeeperConnectionString = this.zookeeper.getConnectString();
        LOG.info("Starting Zookeeper with zookeeperConnectionString: {}", (Object)this.zookeeperConnectionString);
        LOG.info("Starting KafkaServer");
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)(config.isSecureMode() ? SecurityProtocol.SASL_PLAINTEXT : SecurityProtocol.PLAINTEXT));
        for (int i = 0; i < config.getKafkaServersNumber(); ++i) {
            KafkaServer kafkaServer = this.getKafkaServer(i, this.tmpKafkaDirs.get(i));
            this.brokers.add(kafkaServer);
            this.brokerConnectionString = this.brokerConnectionString + NetUtils.hostAndPortToUrlString((String)"localhost", (int)kafkaServer.socketServer().boundPort(listenerName));
            this.brokerConnectionString = this.brokerConnectionString + ",";
        }
        LOG.info("ZK and KafkaServer started.");
        this.standardProps = new Properties();
        this.standardProps.setProperty("bootstrap.servers", this.brokerConnectionString);
        this.standardProps.setProperty("group.id", "flink-tests");
        this.standardProps.setProperty("enable.auto.commit", "false");
        this.standardProps.setProperty("zookeeper.session.timeout.ms", String.valueOf(this.zkTimeout));
        this.standardProps.setProperty("zookeeper.connection.timeout.ms", String.valueOf(this.zkTimeout));
        this.standardProps.setProperty("auto.offset.reset", "earliest");
        this.standardProps.setProperty("max.partition.fetch.bytes", "256");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTestTopic(String topic) {
        LOG.info("Deleting topic {}", (Object)topic);
        Properties props = this.getSecureProperties();
        props.putAll((Map<?, ?>)this.getStandardProperties());
        String clientId = Long.toString(new Random().nextLong());
        props.put("client.id", clientId);
        AdminClient adminClient = AdminClient.create((Properties)props);
        try {
            this.tryDelete(adminClient, topic);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)String.format("Delete test topic : %s failed, %s", topic, e.getMessage()));
        }
        finally {
            adminClient.close(Duration.ofMillis(5000L));
            this.maybePrintDanglingThreadStacktrace(clientId);
        }
    }

    private void tryDelete(AdminClient adminClient, String topic) throws Exception {
        block3: {
            try {
                adminClient.deleteTopics(Collections.singleton(topic)).all().get(30L, TimeUnit.SECONDS);
                for (KafkaServer kafkaServer : this.brokers) {
                    CommonTestUtils.waitUtil(() -> !kafkaServer.metadataCache().contains(topic), (Duration)Duration.ofSeconds(10L), (String)"The topic metadata failed to propagate to Kafka broker for deleted topics.");
                }
            }
            catch (TimeoutException e) {
                LOG.info("Did not receive delete topic response within {} seconds. Checking if it succeeded", (Object)30);
                if (!((Set)adminClient.listTopics().names().get(30L, TimeUnit.SECONDS)).contains(topic)) break block3;
                throw new Exception("Topic still exists after timeout");
            }
        }
    }

    @Override
    public void createTestTopic(String topic, int numberOfPartitions, int replicationFactor, Properties properties) {
        LOG.info("Creating topic {}", (Object)topic);
        try (AdminClient adminClient = AdminClient.create((Properties)this.getStandardProperties());){
            NewTopic topicObj = new NewTopic(topic, numberOfPartitions, (short)replicationFactor);
            adminClient.createTopics(Collections.singleton(topicObj)).all().get();
            for (KafkaServer kafkaServer : this.brokers) {
                CommonTestUtils.waitUtil(() -> kafkaServer.metadataCache().contains(topic), (Duration)Duration.ofSeconds(10L), (String)"The topic metadata failed to propagate to Kafka broker.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Create test topic : " + topic + " failed, " + e.getMessage()));
        }
    }

    @Override
    public Properties getStandardProperties() {
        return this.standardProps;
    }

    @Override
    public Properties getSecureProperties() {
        Properties prop = new Properties();
        if (this.config.isSecureMode()) {
            prop.put("security.inter.broker.protocol", "SASL_PLAINTEXT");
            prop.put("security.protocol", "SASL_PLAINTEXT");
            prop.put("sasl.kerberos.service.name", "kafka");
            prop.setProperty("zookeeper.session.timeout.ms", String.valueOf(this.zkTimeout));
            prop.setProperty("zookeeper.connection.timeout.ms", String.valueOf(this.zkTimeout));
            prop.setProperty("metadata.fetch.timeout.ms", "120000");
        }
        return prop;
    }

    @Override
    public String getBrokerConnectionString() {
        return this.brokerConnectionString;
    }

    @Override
    public String getVersion() {
        return "2.0";
    }

    @Override
    public List<KafkaServer> getBrokers() {
        return this.brokers;
    }

    @Override
    public <T> FlinkKafkaConsumerBase<T> getConsumer(List<String> topics, KafkaDeserializationSchema<T> readSchema, Properties props) {
        return new FlinkKafkaConsumer(topics, readSchema, props);
    }

    @Override
    public <T> KafkaSourceBuilder<T> getSourceBuilder(List<String> topics, KafkaDeserializationSchema<T> schema, Properties props) {
        return KafkaSource.builder().setTopics(topics).setDeserializer(KafkaRecordDeserializationSchema.of(schema)).setProperties(props);
    }

    @Override
    public <K, V> Collection<ConsumerRecord<K, V>> getAllRecordsFromTopic(Properties properties, String topic) {
        return UnmodifiableList.decorate((List)KafkaUtil.drainAllRecordsFromTopic((String)topic, (Properties)properties));
    }

    @Override
    public <T> StreamSink<T> getProducerSink(String topic, SerializationSchema<T> serSchema, Properties props, FlinkKafkaPartitioner<T> partitioner) {
        return new StreamSink((SinkFunction)new FlinkKafkaProducer(topic, serSchema, props, partitioner, this.producerSemantic, 5));
    }

    @Override
    public <T> DataStreamSink<T> produceIntoKafka(DataStream<T> stream, String topic, KeyedSerializationSchema<T> serSchema, Properties props, FlinkKafkaPartitioner<T> partitioner) {
        return stream.addSink((SinkFunction)new FlinkKafkaProducer(topic, serSchema, props, Optional.ofNullable(partitioner), this.producerSemantic, 5));
    }

    @Override
    public <T> DataStreamSink<T> produceIntoKafka(DataStream<T> stream, String topic, SerializationSchema<T> serSchema, Properties props, FlinkKafkaPartitioner<T> partitioner) {
        return stream.addSink((SinkFunction)new FlinkKafkaProducer(topic, serSchema, props, partitioner, this.producerSemantic, 5));
    }

    @Override
    public <T> DataStreamSink<T> produceIntoKafka(DataStream<T> stream, String topic, KafkaSerializationSchema<T> serSchema, Properties props) {
        return stream.addSink((SinkFunction)new FlinkKafkaProducer(topic, serSchema, props, this.producerSemantic));
    }

    @Override
    public KafkaTestEnvironment.KafkaOffsetHandler createOffsetHandler() {
        return new KafkaOffsetHandlerImpl();
    }

    @Override
    public void restartBroker(int leaderId) throws Exception {
        this.brokers.set(leaderId, this.getKafkaServer(leaderId, this.tmpKafkaDirs.get(leaderId)));
    }

    @Override
    public int getLeaderToShutDown(String topic) throws Exception {
        try (AdminClient client = AdminClient.create((Properties)this.getStandardProperties());){
            TopicDescription result = (TopicDescription)((Map)client.describeTopics(Collections.singleton(topic)).all().get()).get(topic);
            int n = ((TopicPartitionInfo)result.partitions().get(0)).leader().id();
            return n;
        }
    }

    @Override
    public int getBrokerId(KafkaServer server) {
        return server.config().brokerId();
    }

    @Override
    public boolean isSecureRunSupported() {
        return true;
    }

    @Override
    public void shutdown() throws Exception {
        for (KafkaServer broker : this.brokers) {
            if (broker == null) continue;
            broker.shutdown();
            broker.awaitShutdown();
        }
        this.brokers.clear();
        if (this.zookeeper != null) {
            try {
                this.zookeeper.stop();
            }
            catch (Exception e) {
                LOG.warn("ZK.stop() failed", (Throwable)e);
            }
            this.zookeeper = null;
        }
        if (this.tmpKafkaParent != null && this.tmpKafkaParent.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.tmpKafkaParent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tmpZkDir != null && this.tmpZkDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.tmpZkDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected KafkaServer getKafkaServer(int brokerId, File tmpFolder) throws Exception {
        Properties kafkaProperties = new Properties();
        kafkaProperties.put("advertised.host.name", "localhost");
        kafkaProperties.put("broker.id", Integer.toString(brokerId));
        kafkaProperties.put("log.dir", tmpFolder.toString());
        kafkaProperties.put("zookeeper.connect", this.zookeeperConnectionString);
        kafkaProperties.put("message.max.bytes", String.valueOf(0x3200000));
        kafkaProperties.put("replica.fetch.max.bytes", String.valueOf(0x3200000));
        kafkaProperties.put("transaction.max.timeout.ms", Integer.toString(0x6DDD00));
        kafkaProperties.put("zookeeper.session.timeout.ms", (Object)this.zkTimeout);
        kafkaProperties.put("zookeeper.connection.timeout.ms", (Object)this.zkTimeout);
        if (this.config.getKafkaServerProperties() != null) {
            kafkaProperties.putAll((Map<?, ?>)this.config.getKafkaServerProperties());
        }
        int numTries = 5;
        for (int i = 1; i <= 5; ++i) {
            int kafkaPort = NetUtils.getAvailablePort();
            kafkaProperties.put("port", Integer.toString(kafkaPort));
            if (this.config.isSecureMode()) {
                LOG.info("Adding Kafka secure configurations");
                kafkaProperties.put("listeners", "SASL_PLAINTEXT://localhost:" + kafkaPort);
                kafkaProperties.put("advertised.listeners", "SASL_PLAINTEXT://localhost:" + kafkaPort);
                kafkaProperties.putAll((Map<?, ?>)this.getSecureProperties());
            }
            KafkaConfig kafkaConfig = new KafkaConfig((Map)kafkaProperties);
            try {
                Option stringNone = Option.apply(null);
                KafkaServer server = new KafkaServer(kafkaConfig, Time.SYSTEM, stringNone, (Seq)new ArraySeq(0));
                server.startup();
                return server;
            }
            catch (KafkaException e) {
                if (!(e.getCause() instanceof BindException)) {
                    throw e;
                }
                LOG.info("Port conflict when starting Kafka Broker. Retrying...");
                continue;
            }
        }
        throw new Exception("Could not start Kafka after 5 retries due to port conflicts.");
    }

    private class KafkaOffsetHandlerImpl
    implements KafkaTestEnvironment.KafkaOffsetHandler {
        private final KafkaConsumer<byte[], byte[]> offsetClient;

        public KafkaOffsetHandlerImpl() {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)KafkaTestEnvironmentImpl.this.standardProps);
            props.setProperty("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            props.setProperty("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            this.offsetClient = new KafkaConsumer(props);
        }

        @Override
        public Long getCommittedOffset(String topicName, int partition) {
            OffsetAndMetadata committed = this.offsetClient.committed(new TopicPartition(topicName, partition));
            return committed != null ? Long.valueOf(committed.offset()) : null;
        }

        @Override
        public void setCommittedOffset(String topicName, int partition, long offset) {
            HashMap<TopicPartition, OffsetAndMetadata> partitionAndOffset = new HashMap<TopicPartition, OffsetAndMetadata>();
            partitionAndOffset.put(new TopicPartition(topicName, partition), new OffsetAndMetadata(offset));
            this.offsetClient.commitSync(partitionAndOffset);
        }

        @Override
        public void close() {
            this.offsetClient.close();
        }
    }
}

