/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.testutils;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSStaticCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.BasicAWSCredentials;
import org.apache.flink.kinesis.shaded.com.amazonaws.client.builder.AwsClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ListStreamsResult;
import org.apache.flink.streaming.connectors.kinesis.config.AWSConfigConstants;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class KinesaliteContainer
extends GenericContainer<KinesaliteContainer> {
    private static final String ACCESS_KEY = "access key";
    private static final String SECRET_KEY = "secret key";

    public KinesaliteContainer(DockerImageName imageName) {
        super(imageName);
        this.withEnv("AWS_ACCESS_KEY_ID", ACCESS_KEY);
        this.withEnv("AWS_SECRET_KEY", ACCESS_KEY);
        this.withExposedPorts(new Integer[]{4567});
        this.waitingFor((WaitStrategy)new ListStreamsWaitStrategy());
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"/tini", "--", "/usr/src/app/node_modules/kinesalite/cli.js", "--path", "/var/lib/kinesalite", "--ssl"}));
    }

    public String getContainerEndpointUrl() {
        return String.format("https://%s:%s", this.getContainerIpAddress(), this.getMappedPort(4567));
    }

    public String getHostEndpointUrl() {
        return String.format("https://%s:%s", this.getHost(), this.getMappedPort(4567));
    }

    public String getAccessKey() {
        return ACCESS_KEY;
    }

    public String getSecretKey() {
        return SECRET_KEY;
    }

    public Properties getContainerProperties() {
        return this.getProperties(this.getContainerEndpointUrl());
    }

    public Properties getHostProperties() {
        return this.getProperties(this.getHostEndpointUrl());
    }

    public AmazonKinesis getContainerClient() {
        return this.getClient(this.getContainerEndpointUrl());
    }

    public AmazonKinesis getHostClient() {
        return this.getClient(this.getHostEndpointUrl());
    }

    private AmazonKinesis getClient(String endPoint) {
        return (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.getAccessKey(), this.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endPoint, "us-east-1"))).build();
    }

    private Properties getProperties(String endpointUrl) {
        Properties config = new Properties();
        config.setProperty("aws.region", "us-east-1");
        config.setProperty("aws.endpoint", endpointUrl);
        config.setProperty(AWSConfigConstants.AWS_ACCESS_KEY_ID, this.getAccessKey());
        config.setProperty(AWSConfigConstants.AWS_SECRET_ACCESS_KEY, this.getSecretKey());
        return config;
    }

    private class ListStreamsWaitStrategy
    extends AbstractWaitStrategy {
        private ListStreamsWaitStrategy() {
        }

        protected void waitUntilReady() {
            Unreliables.retryUntilSuccess((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> (ListStreamsResult)this.getRateLimiter().getWhenReady(() -> this.tryList()));
        }

        private ListStreamsResult tryList() {
            return KinesaliteContainer.this.getContainerClient().listStreams();
        }
    }
}

