/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.testutils;

import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;

public class TestRuntimeContext
extends StreamingRuntimeContext {
    private final boolean isCheckpointingEnabled;
    private final int numParallelSubtasks;
    private final int subtaskIndex;

    public TestRuntimeContext(boolean isCheckpointingEnabled, int numParallelSubtasks, int subtaskIndex) {
        super((AbstractStreamOperator)new TestStreamOperator(), (Environment)new MockEnvironmentBuilder().setTaskName("mockTask").setManagedMemorySize(131072L).build(), Collections.emptyMap());
        this.isCheckpointingEnabled = isCheckpointingEnabled;
        this.numParallelSubtasks = numParallelSubtasks;
        this.subtaskIndex = subtaskIndex;
    }

    public OperatorMetricGroup getMetricGroup() {
        return UnregisteredMetricsGroup.createOperatorMetricGroup();
    }

    public boolean isCheckpointingEnabled() {
        return this.isCheckpointingEnabled;
    }

    public int getIndexOfThisSubtask() {
        return this.subtaskIndex;
    }

    public int getNumberOfParallelSubtasks() {
        return this.numParallelSubtasks;
    }

    private static class TestStreamOperator
    extends AbstractStreamOperator<Integer> {
        private static final long serialVersionUID = -2547912462252989589L;

        private TestStreamOperator() {
        }

        public ExecutionConfig getExecutionConfig() {
            return new ExecutionConfig();
        }

        public OperatorID getOperatorID() {
            return new OperatorID(42L, 44L);
        }
    }
}

