/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.testutils;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.kinesis.shaded.com.amazonaws.kinesis.agg.AggRecord;
import org.apache.flink.kinesis.shaded.com.amazonaws.kinesis.agg.RecordAggregator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.HashKeyRange;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Record;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.SequenceNumberRange;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.streaming.connectors.kinesis.config.AWSConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.config.ConsumerConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.RecordBatch;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.RecordPublisher;
import org.apache.flink.streaming.connectors.kinesis.model.SequenceNumber;
import org.apache.flink.streaming.connectors.kinesis.model.StreamShardHandle;
import org.mockito.Mockito;

public class TestUtils {
    public static Properties getStandardProperties() {
        Properties config = new Properties();
        config.setProperty("aws.region", "us-east-1");
        config.setProperty(AWSConfigConstants.AWS_ACCESS_KEY_ID, "accessKeyId");
        config.setProperty(AWSConfigConstants.AWS_SECRET_ACCESS_KEY, "secretKey");
        return config;
    }

    public static List<Record> createAggregatedRecordBatch(int numOfAggregatedRecords, int numOfChildRecords, AtomicInteger sequenceNumber) {
        ArrayList<Record> recordBatch = new ArrayList<Record>();
        RecordAggregator recordAggregator = new RecordAggregator();
        for (int record = 0; record < numOfAggregatedRecords; ++record) {
            String partitionKey = UUID.randomUUID().toString();
            for (int child = 0; child < numOfChildRecords; ++child) {
                byte[] data = RandomStringUtils.randomAlphabetic((int)1024).getBytes(ConfigConstants.DEFAULT_CHARSET);
                try {
                    recordAggregator.addUserRecord(partitionKey, data);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error aggregating message", e);
                }
            }
            AggRecord aggRecord = recordAggregator.clearAndGet();
            recordBatch.add(new Record().withData(ByteBuffer.wrap(aggRecord.toRecordBytes())).withPartitionKey(partitionKey).withApproximateArrivalTimestamp(new Date(System.currentTimeMillis())).withSequenceNumber(String.valueOf(sequenceNumber.getAndAdd(numOfChildRecords))));
        }
        return recordBatch;
    }

    public static StreamShardHandle createDummyStreamShardHandle() {
        return TestUtils.createDummyStreamShardHandle("stream-name", "000000");
    }

    public static StreamShardHandle createDummyStreamShardHandle(String streamName, String shardId) {
        Shard shard = new Shard().withSequenceNumberRange(new SequenceNumberRange().withStartingSequenceNumber("0").withEndingSequenceNumber("9999999999999")).withHashKeyRange(new HashKeyRange().withStartingHashKey("0").withEndingHashKey(new BigInteger(StringUtils.repeat((String)"FF", (int)16), 16).toString())).withShardId(shardId);
        return new StreamShardHandle(streamName, shard);
    }

    public static Properties efoProperties() {
        Properties consumerConfig = new Properties();
        consumerConfig.setProperty("flink.stream.recordpublisher", ConsumerConfigConstants.RecordPublisherType.EFO.name());
        consumerConfig.setProperty("flink.stream.efo.registration", ConsumerConfigConstants.EFORegistrationType.NONE.name());
        consumerConfig.setProperty("flink.stream.efo.consumerarn.fakeStream", "stream-consumer-arn");
        return consumerConfig;
    }

    public static RuntimeContext getMockedRuntimeContext(int fakeTotalCountOfSubtasks, int fakeIndexOfThisSubtask) {
        RuntimeContext mockedRuntimeContext = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        Mockito.when((Object)mockedRuntimeContext.getNumberOfParallelSubtasks()).thenReturn((Object)fakeTotalCountOfSubtasks);
        Mockito.when((Object)mockedRuntimeContext.getIndexOfThisSubtask()).thenReturn((Object)fakeIndexOfThisSubtask);
        Mockito.when((Object)mockedRuntimeContext.getTaskName()).thenReturn((Object)"Fake Task");
        Mockito.when((Object)mockedRuntimeContext.getTaskNameWithSubtasks()).thenReturn((Object)("Fake Task (" + fakeIndexOfThisSubtask + "/" + fakeTotalCountOfSubtasks + ")"));
        Mockito.when((Object)mockedRuntimeContext.getUserCodeClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)mockedRuntimeContext.getMetricGroup()).thenReturn((Object)UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup());
        return mockedRuntimeContext;
    }

    public static class TestConsumer
    implements RecordPublisher.RecordBatchConsumer {
        private final List<RecordBatch> recordBatches = new ArrayList<RecordBatch>();
        private String latestSequenceNumber;

        public SequenceNumber accept(RecordBatch batch) {
            this.recordBatches.add(batch);
            if (batch.getDeaggregatedRecordSize() > 0) {
                List records = batch.getDeaggregatedRecords();
                this.latestSequenceNumber = ((UserRecord)records.get(records.size() - 1)).getSequenceNumber();
            }
            return new SequenceNumber(this.latestSequenceNumber);
        }

        public List<RecordBatch> getRecordBatches() {
            return this.recordBatches;
        }
    }
}

