/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.testutils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.RecordPublisherFactory;
import org.apache.flink.streaming.connectors.kinesis.model.KinesisStreamShardState;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyInterface;
import org.apache.flink.streaming.connectors.kinesis.serialization.KinesisDeserializationSchema;
import org.apache.flink.streaming.connectors.kinesis.testutils.TestableKinesisDataFetcher;

public class TestableKinesisDataFetcherForShardConsumerException<T>
extends TestableKinesisDataFetcher<T> {
    public volatile boolean wasInterrupted = false;
    private OneShotLatch awaitTerminationWaiter = new OneShotLatch();

    public TestableKinesisDataFetcherForShardConsumerException(List<String> fakeStreams, SourceFunction.SourceContext<T> sourceContext, Properties fakeConfiguration, KinesisDeserializationSchema<T> deserializationSchema, int fakeTotalCountOfSubtasks, int fakeIndexOfThisSubtask, AtomicReference<Throwable> thrownErrorUnderTest, LinkedList<KinesisStreamShardState> subscribedShardsStateUnderTest, HashMap<String, String> subscribedStreamsToLastDiscoveredShardIdsStateUnderTest, KinesisProxyInterface fakeKinesis, RecordPublisherFactory recordPublisherFactory) {
        super(fakeStreams, sourceContext, fakeConfiguration, deserializationSchema, fakeTotalCountOfSubtasks, fakeIndexOfThisSubtask, thrownErrorUnderTest, subscribedShardsStateUnderTest, subscribedStreamsToLastDiscoveredShardIdsStateUnderTest, fakeKinesis);
    }

    public void waitUntilAwaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        this.awaitTerminationWaiter.await(timeout, timeUnit);
    }

    @Override
    protected ExecutorService createShardConsumersThreadPool(String subtaskName) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("KinesisShardConsumers-%d").build();
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        this.awaitTerminationWaiter.trigger();
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            this.wasInterrupted = true;
            throw e;
        }
    }
}

