/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate.undirected;

import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.DegreeAnnotationFunctions;
import org.apache.flink.graph.asm.degree.annotate.undirected.EdgeSourceDegree;
import org.apache.flink.graph.asm.degree.annotate.undirected.VertexDegree;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.LongValue;

public class EdgeDegreePair<K, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Edge<K, Tuple3<EV, LongValue, LongValue>>> {
    private OptionalBoolean reduceOnTargetId = new OptionalBoolean(false, false);

    public EdgeDegreePair<K, VV, EV> setReduceOnTargetId(boolean reduceOnTargetId) {
        this.reduceOnTargetId.set(reduceOnTargetId);
        return this;
    }

    @Override
    protected void mergeConfiguration(GraphAlgorithmWrappingBase other) {
        super.mergeConfiguration(other);
        EdgeDegreePair rhs = (EdgeDegreePair)other;
        this.reduceOnTargetId.mergeWith(rhs.reduceOnTargetId);
    }

    @Override
    public DataSet<Edge<K, Tuple3<EV, LongValue, LongValue>>> runInternal(Graph<K, VV, EV> input) throws Exception {
        DataSet edgeSourceDegrees = (DataSet)input.run(new EdgeSourceDegree().setReduceOnTargetId(this.reduceOnTargetId.get()).setParallelism(this.parallelism));
        DataSet vertexDegrees = (DataSet)input.run(new VertexDegree().setReduceOnTargetId(this.reduceOnTargetId.get()).setParallelism(this.parallelism));
        return ((JoinOperator)edgeSourceDegrees.join(vertexDegrees, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{1}).equalTo(new int[]{0}).with(new DegreeAnnotationFunctions.JoinEdgeDegreeWithVertexDegree()).setParallelism(this.parallelism)).name("Edge target degree");
    }
}

