/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.undirected;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.asm.degree.annotate.undirected.EdgeDegreePair;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.asm.result.TertiaryResultBase;
import org.apache.flink.graph.library.clustering.TriangleListingBase;
import org.apache.flink.graph.utils.MurmurHash;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Collector;

public class TriangleListing<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends TriangleListingBase<K, VV, EV, Result<K>> {
    @Override
    public DataSet<Result<K>> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator filteredByID = ((FlatMapOperator)input.getEdges().flatMap(new FilterByID()).setParallelism(this.parallelism)).name("Filter by ID");
        DataSet pairDegree = (DataSet)input.run(new EdgeDegreePair().setParallelism(this.parallelism));
        Operator filteredByDegree = ((FlatMapOperator)pairDegree.flatMap(new FilterByDegree()).setParallelism(this.parallelism)).name("Filter by degree");
        Operator triplets = filteredByDegree.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup(new GenerateTriplets()).name("Generate triplets");
        Operator triangles = triplets.join((DataSet)filteredByID, JoinOperatorBase.JoinHint.REPARTITION_HASH_SECOND).where(new int[]{1, 2}).equalTo(new int[]{0, 1}).with(new ProjectTriangles()).name("Triangle listing");
        if (this.permuteResults) {
            triangles = triangles.flatMap(new PermuteResult()).name("Permute triangle vertices");
        } else if (this.sortTriangleVertices.get()) {
            triangles = triangles.map(new SortTriangleVertices()).name("Sort triangle vertices");
        }
        return triangles;
    }

    public static class Result<T>
    extends TertiaryResultBase<T>
    implements PrintableResult {
        public static final int HASH_SEED = -744500821;
        private transient MurmurHash hasher;

        @Override
        public String toString() {
            return "(" + this.getVertexId0() + "," + this.getVertexId1() + "," + this.getVertexId2() + ")";
        }

        @Override
        public String toPrintableString() {
            return "1st vertex ID: " + this.getVertexId0() + ", 2nd vertex ID: " + this.getVertexId1() + ", 3rd vertex ID: " + this.getVertexId2();
        }

        public int hashCode() {
            if (this.hasher == null) {
                this.hasher = new MurmurHash(-744500821);
            }
            return this.hasher.reset().hash(this.getVertexId0().hashCode()).hash(this.getVertexId1().hashCode()).hash(this.getVertexId2().hashCode()).hash();
        }
    }

    private static final class SortTriangleVertices<T extends Comparable<T>>
    implements MapFunction<Result<T>, Result<T>> {
        private SortTriangleVertices() {
        }

        public Result<T> map(Result<T> value) throws Exception {
            if (((Comparable)value.getVertexId0()).compareTo(value.getVertexId1()) > 0) {
                Comparable tempVal = (Comparable)value.getVertexId0();
                value.setVertexId0(value.getVertexId1());
                if (tempVal.compareTo(value.getVertexId2()) <= 0) {
                    value.setVertexId1(tempVal);
                } else {
                    value.setVertexId1(value.getVertexId2());
                    value.setVertexId2(tempVal);
                }
            }
            return value;
        }
    }

    private static class PermuteResult<T>
    implements FlatMapFunction<Result<T>, Result<T>> {
        private PermuteResult() {
        }

        public void flatMap(Result<T> value, Collector<Result<T>> out) throws Exception {
            out.collect(value);
            Object tmp = value.getVertexId0();
            value.setVertexId0(value.getVertexId1());
            value.setVertexId1(tmp);
            out.collect(value);
            tmp = value.getVertexId1();
            value.setVertexId1(value.getVertexId2());
            value.setVertexId2(tmp);
            out.collect(value);
            tmp = value.getVertexId0();
            value.setVertexId0(value.getVertexId2());
            value.setVertexId2(tmp);
            out.collect(value);
            tmp = value.getVertexId0();
            value.setVertexId0(value.getVertexId1());
            value.setVertexId1(tmp);
            out.collect(value);
            tmp = value.getVertexId1();
            value.setVertexId1(value.getVertexId2());
            value.setVertexId2(tmp);
            out.collect(value);
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0->vertexId0; 1->vertexId1; 2->vertexId2"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0->vertexId0; 1->vertexId1"})
    private static final class ProjectTriangles<T>
    implements JoinFunction<Tuple3<T, T, T>, Tuple2<T, T>, Result<T>> {
        private Result<T> output = new Result();

        private ProjectTriangles() {
        }

        public Result<T> join(Tuple3<T, T, T> triplet, Tuple2<T, T> edge) throws Exception {
            this.output.setVertexId0(triplet.f0);
            this.output.setVertexId1(triplet.f1);
            this.output.setVertexId2(triplet.f2);
            return this.output;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static final class GenerateTriplets<T extends CopyableValue<T>>
    implements GroupReduceFunction<Tuple2<T, T>, Tuple3<T, T, T>> {
        private Tuple3<T, T, T> output = new Tuple3();
        private List<T> visited = new ArrayList<T>();

        private GenerateTriplets() {
        }

        public void reduce(Iterable<Tuple2<T, T>> values, Collector<Tuple3<T, T, T>> out) throws Exception {
            int visitedCount = 0;
            Iterator<Tuple2<T, T>> iter = values.iterator();
            while (true) {
                Tuple2<T, T> edge = iter.next();
                this.output.f0 = edge.f0;
                this.output.f2 = edge.f1;
                for (int i = 0; i < visitedCount; ++i) {
                    this.output.f1 = this.visited.get(i);
                    out.collect(this.output);
                }
                if (!iter.hasNext()) break;
                if (visitedCount == this.visited.size()) {
                    this.visited.add(((CopyableValue)edge.f1).copy());
                } else {
                    ((CopyableValue)edge.f1).copyTo(this.visited.get(visitedCount));
                }
                ++visitedCount;
            }
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0; 1"})
    private static final class FilterByDegree<T extends Comparable<T>, ET>
    implements FlatMapFunction<Edge<T, Tuple3<ET, LongValue, LongValue>>, Tuple2<T, T>> {
        private Tuple2<T, T> edge = new Tuple2();

        private FilterByDegree() {
        }

        public void flatMap(Edge<T, Tuple3<ET, LongValue, LongValue>> value, Collector<Tuple2<T, T>> out) throws Exception {
            long targetDegree;
            Tuple3 degrees = (Tuple3)value.f2;
            long sourceDegree = ((LongValue)degrees.f1).getValue();
            if (sourceDegree < (targetDegree = ((LongValue)degrees.f2).getValue()) || sourceDegree == targetDegree && ((Comparable)value.f0).compareTo(value.f1) < 0) {
                this.edge.f0 = value.f0;
                this.edge.f1 = value.f1;
                out.collect(this.edge);
            }
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0; 1"})
    private static final class FilterByID<T extends Comparable<T>, ET>
    implements FlatMapFunction<Edge<T, ET>, Tuple2<T, T>> {
        private Tuple2<T, T> edge = new Tuple2();

        private FilterByID() {
        }

        public void flatMap(Edge<T, ET> value, Collector<Tuple2<T, T>> out) throws Exception {
            if (((Comparable)value.f0).compareTo(value.f1) < 0) {
                this.edge.f0 = value.f0;
                this.edge.f1 = value.f1;
                out.collect(this.edge);
            }
        }
    }
}

