/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.utils.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.java.operators.NoOpOperator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;

public abstract class GraphAlgorithmWrappingGraph<IN_K, IN_VV, IN_EV, OUT_K, OUT_VV, OUT_EV>
extends GraphAlgorithmWrappingBase<IN_K, IN_VV, IN_EV, Graph<OUT_K, OUT_VV, OUT_EV>> {
    private static Map<GraphAlgorithmWrappingGraph, List<GraphAlgorithmWrappingGraph>> cache = Collections.synchronizedMap(new HashMap());
    private Graph<IN_K, IN_VV, IN_EV> input;
    private NoOpOperator<Vertex<OUT_K, OUT_VV>> verticesWrappingOperator;
    private NoOpOperator<Edge<OUT_K, OUT_EV>> edgesWrappingOperator;

    protected abstract Graph<OUT_K, OUT_VV, OUT_EV> runInternal(Graph<IN_K, IN_VV, IN_EV> var1) throws Exception;

    public final int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.input).append((Object)this.getAlgorithmName()).toHashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!GraphAlgorithmWrappingGraph.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        GraphAlgorithmWrappingGraph rhs = (GraphAlgorithmWrappingGraph)obj;
        return new EqualsBuilder().append(this.input, rhs.input).append((Object)this.getAlgorithmName(), (Object)rhs.getAlgorithmName()).isEquals();
    }

    @Override
    public final Graph<OUT_K, OUT_VV, OUT_EV> run(Graph<IN_K, IN_VV, IN_EV> input) throws Exception {
        this.input = input;
        if (cache.containsKey(this)) {
            for (GraphAlgorithmWrappingGraph other : cache.get(this)) {
                if (!this.canMergeConfigurationWith(other)) continue;
                this.mergeConfiguration(other);
                Graph<OUT_K, OUT_VV, OUT_EV> output = this.runInternal(input);
                other.verticesWrappingOperator.setInput(output.getVertices());
                other.edgesWrappingOperator.setInput(output.getEdges());
                this.verticesWrappingOperator = other.verticesWrappingOperator;
                this.edgesWrappingOperator = other.edgesWrappingOperator;
                return Graph.fromDataSet(this.verticesWrappingOperator, this.edgesWrappingOperator, output.getContext());
            }
        }
        Graph<OUT_K, OUT_VV, OUT_EV> output = this.runInternal(input);
        this.verticesWrappingOperator = new NoOpOperator(output.getVertices(), output.getVertices().getType());
        this.edgesWrappingOperator = new NoOpOperator(output.getEdges(), output.getEdges().getType());
        if (cache.containsKey(this)) {
            cache.get(this).add(this);
        } else {
            cache.put(this, new ArrayList<GraphAlgorithmWrappingGraph>(Collections.singletonList(this)));
        }
        return Graph.fromDataSet(this.verticesWrappingOperator, this.edgesWrappingOperator, output.getContext());
    }
}

