/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.degree.annotate.directed;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.EdgeOrder;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.utils.MurmurHash;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingDataSet;
import org.apache.flink.graph.utils.proxy.OptionalBoolean;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Collector;

public class VertexDegrees<K, VV, EV>
extends GraphAlgorithmWrappingDataSet<K, VV, EV, Vertex<K, Degrees>> {
    private OptionalBoolean includeZeroDegreeVertices = new OptionalBoolean(false, true);

    public VertexDegrees<K, VV, EV> setIncludeZeroDegreeVertices(boolean includeZeroDegreeVertices) {
        this.includeZeroDegreeVertices.set(includeZeroDegreeVertices);
        return this;
    }

    @Override
    protected boolean canMergeConfigurationWith(GraphAlgorithmWrappingBase other) {
        if (!super.canMergeConfigurationWith(other)) {
            return false;
        }
        VertexDegrees rhs = (VertexDegrees)other;
        return !this.includeZeroDegreeVertices.conflictsWith(rhs.includeZeroDegreeVertices);
    }

    @Override
    protected void mergeConfiguration(GraphAlgorithmWrappingBase other) {
        super.mergeConfiguration(other);
        VertexDegrees rhs = (VertexDegrees)other;
        this.includeZeroDegreeVertices.mergeWith(rhs.includeZeroDegreeVertices);
    }

    @Override
    public DataSet<Vertex<K, Degrees>> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator vertexWithEdgeOrder = ((GroupReduceOperator)((FlatMapOperator)((FlatMapOperator)input.getEdges().flatMap(new EmitAndFlipEdge()).setParallelism(this.parallelism)).name("Emit and flip edge")).groupBy(new int[]{0, 1}).reduceGroup(new ReduceBitmask()).setParallelism(this.parallelism)).name("Reduce bitmask");
        Operator vertexDegrees = ((GroupReduceOperator)vertexWithEdgeOrder.groupBy(new int[]{0}).reduceGroup(new DegreeCount()).setParallelism(this.parallelism)).name("Degree count");
        if (this.includeZeroDegreeVertices.get()) {
            vertexDegrees = ((JoinOperator)input.getVertices().leftOuterJoin((DataSet)vertexDegrees).where(new int[]{0}).equalTo(new int[]{0}).with(new JoinVertexWithVertexDegrees()).setParallelism(this.parallelism)).name("Zero degree vertices");
        }
        return vertexDegrees;
    }

    public static class Degrees
    extends Tuple3<LongValue, LongValue, LongValue> {
        private static final int HASH_SEED = 974322737;
        private MurmurHash hasher = new MurmurHash(974322737);

        public Degrees() {
            this(new LongValue(), new LongValue(), new LongValue());
        }

        public Degrees(LongValue value0, LongValue value1, LongValue value2) {
            super((Object)value0, (Object)value1, (Object)value2);
        }

        public LongValue getDegree() {
            return (LongValue)this.f0;
        }

        public LongValue getOutDegree() {
            return (LongValue)this.f1;
        }

        public LongValue getInDegree() {
            return (LongValue)this.f2;
        }

        public int hashCode() {
            return this.hasher.reset().hash(((LongValue)this.f0).getValue()).hash(((LongValue)this.f1).getValue()).hash(((LongValue)this.f2).getValue()).hash();
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0"})
    private static class JoinVertexWithVertexDegrees<T, TV>
    implements JoinFunction<Vertex<T, TV>, Vertex<T, Degrees>, Vertex<T, Degrees>> {
        private Vertex<T, Degrees> output = new Vertex<Object, Degrees>(null, new Degrees());

        private JoinVertexWithVertexDegrees() {
        }

        public Vertex<T, Degrees> join(Vertex<T, TV> vertex, Vertex<T, Degrees> vertexDegree) throws Exception {
            if (vertexDegree == null) {
                this.output.f0 = vertex.f0;
                return this.output;
            }
            return vertexDegree;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class DegreeCount<T>
    implements GroupReduceFunction<Tuple2<T, ByteValue>, Vertex<T, Degrees>> {
        private Vertex<T, Degrees> output = new Vertex<Object, Degrees>(null, new Degrees());

        private DegreeCount() {
        }

        public void reduce(Iterable<Tuple2<T, ByteValue>> values, Collector<Vertex<T, Degrees>> out) throws Exception {
            long degree = 0L;
            long outDegree = 0L;
            long inDegree = 0L;
            for (Tuple2<T, ByteValue> edge : values) {
                this.output.f0 = edge.f0;
                byte bitmask = ((ByteValue)edge.f1).getValue();
                ++degree;
                if (bitmask == EdgeOrder.FORWARD.getBitmask()) {
                    ++outDegree;
                    continue;
                }
                if (bitmask == EdgeOrder.REVERSE.getBitmask()) {
                    ++inDegree;
                    continue;
                }
                ++outDegree;
                ++inDegree;
            }
            ((Degrees)((Object)this.output.f1)).getDegree().setValue(degree);
            ((Degrees)((Object)this.output.f1)).getOutDegree().setValue(outDegree);
            ((Degrees)((Object)this.output.f1)).getInDegree().setValue(inDegree);
            out.collect(this.output);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static final class ReduceBitmask<T>
    implements GroupReduceFunction<Tuple3<T, T, ByteValue>, Tuple2<T, ByteValue>> {
        private Tuple2<T, ByteValue> output = new Tuple2(null, (Object)new ByteValue());

        private ReduceBitmask() {
        }

        public void reduce(Iterable<Tuple3<T, T, ByteValue>> values, Collector<Tuple2<T, ByteValue>> out) throws Exception {
            byte bitmask = 0;
            for (Tuple3<T, T, ByteValue> value : values) {
                this.output.f0 = value.f0;
                bitmask = (byte)(bitmask | ((ByteValue)value.f2).getValue());
            }
            ((ByteValue)this.output.f1).setValue(bitmask);
            out.collect(this.output);
        }
    }

    private static class EmitAndFlipEdge<T, TV>
    implements FlatMapFunction<Edge<T, TV>, Tuple3<T, T, ByteValue>> {
        private Tuple3<T, T, ByteValue> forward = new Tuple3(null, null, (Object)new ByteValue(EdgeOrder.FORWARD.getBitmask()));
        private Tuple3<T, T, ByteValue> reverse = new Tuple3(null, null, (Object)new ByteValue(EdgeOrder.REVERSE.getBitmask()));

        private EmitAndFlipEdge() {
        }

        public void flatMap(Edge<T, TV> value, Collector<Tuple3<T, T, ByteValue>> out) throws Exception {
            this.forward.f0 = value.f0;
            this.forward.f1 = value.f1;
            out.collect(this.forward);
            this.reverse.f0 = value.f1;
            this.reverse.f1 = value.f0;
            out.collect(this.reverse);
        }
    }
}

