/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.simple.directed;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;

public class Simplify<K extends Comparable<K>, VV, EV>
extends GraphAlgorithmWrappingGraph<K, VV, EV, K, VV, EV> {
    @Override
    public Graph<K, VV, EV> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator edges = ((DistinctOperator)((FilterOperator)((FilterOperator)input.getEdges().filter(new RemoveSelfLoops()).setParallelism(this.parallelism)).name("Remove self-loops")).distinct(new int[]{0, 1}).setCombineHint(ReduceOperatorBase.CombineHint.NONE).setParallelism(this.parallelism)).name("Remove duplicate edges");
        return Graph.fromDataSet(input.getVertices(), edges, input.getContext());
    }

    private static class RemoveSelfLoops<T extends Comparable<T>, ET>
    implements FilterFunction<Edge<T, ET>> {
        private RemoveSelfLoops() {
        }

        public boolean filter(Edge<T, ET> value) throws Exception {
            return ((Comparable)value.f0).compareTo(value.f1) != 0;
        }
    }
}

