/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.simple.undirected;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.util.Collector;

public class Simplify<K extends Comparable<K>, VV, EV>
extends GraphAlgorithmWrappingGraph<K, VV, EV, K, VV, EV> {
    private boolean clipAndFlip;

    public Simplify(boolean clipAndFlip) {
        this.clipAndFlip = clipAndFlip;
    }

    @Override
    protected boolean canMergeConfigurationWith(GraphAlgorithmWrappingBase other) {
        if (!super.canMergeConfigurationWith(other)) {
            return false;
        }
        Simplify rhs = (Simplify)other;
        return this.clipAndFlip == rhs.clipAndFlip;
    }

    @Override
    public Graph<K, VV, EV> runInternal(Graph<K, VV, EV> input) throws Exception {
        Operator edges = ((DistinctOperator)((FlatMapOperator)((FlatMapOperator)input.getEdges().flatMap(new SymmetrizeAndRemoveSelfLoops(this.clipAndFlip)).setParallelism(this.parallelism)).name("Remove self-loops")).distinct(new int[]{0, 1}).setCombineHint(ReduceOperatorBase.CombineHint.NONE).setParallelism(this.parallelism)).name("Remove duplicate edges");
        return Graph.fromDataSet(input.getVertices(), edges, input.getContext());
    }

    private static class SymmetrizeAndRemoveSelfLoops<T extends Comparable<T>, ET>
    implements FlatMapFunction<Edge<T, ET>, Edge<T, ET>> {
        private boolean clipAndFlip;

        public SymmetrizeAndRemoveSelfLoops(boolean clipAndFlip) {
            this.clipAndFlip = clipAndFlip;
        }

        public void flatMap(Edge<T, ET> value, Collector<Edge<T, ET>> out) throws Exception {
            int comparison = ((Comparable)value.f0).compareTo(value.f1);
            if (this.clipAndFlip && comparison > 0 || !this.clipAndFlip && comparison != 0) {
                out.collect(value);
                Comparable temp = (Comparable)value.f0;
                value.f0 = value.f1;
                value.f1 = temp;
                out.collect(value);
            }
        }
    }
}

