/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.StringValueArray;
import org.apache.flink.types.NormalizableKey;

@Internal
public class StringValueArrayComparator
extends TypeComparator<StringValueArray> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final StringValueArray reference = new StringValueArray();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public StringValueArrayComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    public int hash(StringValueArray record) {
        return record.hashCode();
    }

    public void setReference(StringValueArray toCompare) {
        toCompare.copyTo(this.reference);
    }

    public boolean equalToReference(StringValueArray candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<StringValueArray> referencedComparator) {
        int comp = ((StringValueArrayComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(StringValueArray first, StringValueArray second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    private static int readStringLength(DataInputView source) throws IOException {
        int len = source.readByte() & 0xFF;
        if (len >= 128) {
            int curr;
            int shift = 7;
            len &= 0x7F;
            while ((curr = source.readByte() & 0xFF) >= 128) {
                len |= (curr & 0x7F) << shift;
                shift += 7;
            }
            len |= curr << shift;
        }
        return len;
    }

    private static char readStringChar(DataInputView source) throws IOException {
        int c = source.readByte() & 0xFF;
        if (c >= 128) {
            int curr;
            int shift = 7;
            c &= 0x7F;
            while ((curr = source.readByte() & 0xFF) >= 128) {
                c |= (curr & 0x7F) << shift;
                shift += 7;
            }
            c |= curr << shift;
        }
        return (char)c;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstCount = firstSource.readInt();
        int secondCount = secondSource.readInt();
        int minCount = Math.min(firstCount, secondCount);
        while (minCount-- > 0) {
            int firstLength = StringValueArrayComparator.readStringLength(firstSource);
            int secondLength = StringValueArrayComparator.readStringLength(secondSource);
            int minLength = Math.min(firstLength, secondLength);
            while (minLength-- > 0) {
                char secondChar;
                char firstChar = StringValueArrayComparator.readStringChar(firstSource);
                int cmp = Character.compare(firstChar, secondChar = StringValueArrayComparator.readStringChar(secondSource));
                if (cmp == 0) continue;
                return this.ascendingComparison ? cmp : -cmp;
            }
            int cmp = Integer.compare(firstLength, secondLength);
            if (cmp == 0) continue;
            return this.ascendingComparison ? cmp : -cmp;
        }
        int cmp = Integer.compare(firstCount, secondCount);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(StringValueArray.class);
    }

    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(StringValueArray record, MemorySegment target, int offset, int numBytes) {
        record.copyNormalizedKey(target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<StringValueArray> duplicate() {
        return new StringValueArrayComparator(this.ascendingComparison);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(StringValueArray record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public StringValueArray readWithKeyDenormalization(StringValueArray reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

