/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.utils.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.NoOpOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;

public abstract class GraphAlgorithmWrappingDataSet<K, VV, EV, T>
extends GraphAlgorithmWrappingBase<K, VV, EV, DataSet<T>> {
    private static Map<GraphAlgorithmWrappingDataSet, List<GraphAlgorithmWrappingDataSet>> cache = Collections.synchronizedMap(new HashMap());
    private Graph<K, VV, EV> input;
    private NoOpOperator<T> wrappingOperator;

    protected abstract DataSet<T> runInternal(Graph<K, VV, EV> var1) throws Exception;

    public final int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.input).append((Object)this.getAlgorithmName()).toHashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!GraphAlgorithmWrappingDataSet.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        GraphAlgorithmWrappingDataSet rhs = (GraphAlgorithmWrappingDataSet)obj;
        return new EqualsBuilder().append(this.input, rhs.input).append((Object)this.getAlgorithmName(), (Object)rhs.getAlgorithmName()).isEquals();
    }

    @Override
    public final DataSet<T> run(Graph<K, VV, EV> input) throws Exception {
        this.input = input;
        if (cache.containsKey(this)) {
            for (GraphAlgorithmWrappingDataSet other : cache.get(this)) {
                if (!this.canMergeConfigurationWith(other)) continue;
                this.mergeConfiguration(other);
                DataSet<T> output = this.runInternal(input);
                other.wrappingOperator.setInput(output);
                this.wrappingOperator = other.wrappingOperator;
                return this.wrappingOperator;
            }
        }
        DataSet<T> output = this.runInternal(input);
        this.wrappingOperator = new NoOpOperator(output, output.getType());
        if (cache.containsKey(this)) {
            cache.get(this).add(this);
        } else {
            cache.put(this, new ArrayList<GraphAlgorithmWrappingDataSet>(Collections.singletonList(this)));
        }
        return this.wrappingOperator;
    }
}

