/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.client.cli.PythonProgramOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonOptions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PythonProgramOptionsTest {
    private Options options;

    PythonProgramOptionsTest() {
    }

    @BeforeEach
    void setUp() {
        this.options = new Options();
        this.options.addOption(CliFrontendParser.PY_OPTION);
        this.options.addOption(CliFrontendParser.PYFILES_OPTION);
        this.options.addOption(CliFrontendParser.PYMODULE_OPTION);
        this.options.addOption(CliFrontendParser.PYREQUIREMENTS_OPTION);
        this.options.addOption(CliFrontendParser.PYARCHIVE_OPTION);
        this.options.addOption(CliFrontendParser.PYEXEC_OPTION);
    }

    @Test
    void testCreateProgramOptionsWithPythonCommandLine() throws CliArgsException {
        String[] parameters = new String[]{"-py", "test.py", "-pym", "test", "-pyfs", "test1.py,test2.zip,test3.egg,test4_dir", "-pyreq", "a.txt#b_dir", "-pyarch", "c.zip#venv,d.zip", "-pyexec", "bin/python", "userarg1", "userarg2"};
        CommandLine line = CliFrontendParser.parse((Options)this.options, (String[])parameters, (boolean)false);
        PythonProgramOptions programOptions = (PythonProgramOptions)ProgramOptions.create((CommandLine)line);
        Configuration config = new Configuration();
        programOptions.applyToConfiguration(config);
        Assertions.assertThat((String)((String)config.get(PythonOptions.PYTHON_FILES))).isEqualTo("test1.py,test2.zip,test3.egg,test4_dir");
        Assertions.assertThat((String)((String)config.get(PythonOptions.PYTHON_REQUIREMENTS))).isEqualTo("a.txt#b_dir");
        Assertions.assertThat((String)((String)config.get(PythonOptions.PYTHON_ARCHIVES))).isEqualTo("c.zip#venv,d.zip");
        Assertions.assertThat((String)((String)config.get(PythonOptions.PYTHON_EXECUTABLE))).isEqualTo("bin/python");
        Assertions.assertThat((Object[])programOptions.getProgramArgs()).containsExactly((Object[])new String[]{"--python", "test.py", "--pyModule", "test", "userarg1", "userarg2"});
    }

    @Test
    void testCreateProgramOptionsWithLongOptions() throws CliArgsException {
        String[] args = new String[]{"--python", "xxx.py", "--pyModule", "xxx", "--pyFiles", "/absolute/a.py,relative/b.py,relative/c.py", "--pyRequirements", "d.txt#e_dir", "--pyExecutable", "/usr/bin/python", "--pyArchives", "g.zip,h.zip#data,h.zip#data2", "userarg1", "userarg2"};
        CommandLine line = CliFrontendParser.parse((Options)this.options, (String[])args, (boolean)false);
        PythonProgramOptions programOptions = (PythonProgramOptions)ProgramOptions.create((CommandLine)line);
        Configuration config = new Configuration();
        programOptions.applyToConfiguration(config);
        Assertions.assertThat((String)((String)config.get(PythonOptions.PYTHON_FILES))).isEqualTo("/absolute/a.py,relative/b.py,relative/c.py");
        Assertions.assertThat((String)((String)config.get(PythonOptions.PYTHON_REQUIREMENTS))).isEqualTo("d.txt#e_dir");
        Assertions.assertThat((String)((String)config.get(PythonOptions.PYTHON_ARCHIVES))).isEqualTo("g.zip,h.zip#data,h.zip#data2");
        Assertions.assertThat((String)((String)config.get(PythonOptions.PYTHON_EXECUTABLE))).isEqualTo("/usr/bin/python");
        Assertions.assertThat((Object[])programOptions.getProgramArgs()).containsExactly((Object[])new String[]{"--python", "xxx.py", "--pyModule", "xxx", "userarg1", "userarg2"});
    }
}

