/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python;

import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonOptions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PythonOptionsTest {
    PythonOptionsTest() {
    }

    @Test
    void testBundleSize() {
        Configuration configuration = new Configuration();
        int defaultBundleSize = configuration.getInteger(PythonOptions.MAX_BUNDLE_SIZE);
        Assertions.assertThat((int)defaultBundleSize).isEqualTo(PythonOptions.MAX_BUNDLE_SIZE.defaultValue());
        int expectedBundleSize = 100;
        configuration.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 100);
        int actualBundleSize = configuration.getInteger(PythonOptions.MAX_BUNDLE_SIZE);
        Assertions.assertThat((int)actualBundleSize).isEqualTo(100);
    }

    @Test
    void testBundleTime() {
        Configuration configuration = new Configuration();
        long defaultBundleTime = configuration.getLong(PythonOptions.MAX_BUNDLE_TIME_MILLS);
        Assertions.assertThat((long)defaultBundleTime).isEqualTo(PythonOptions.MAX_BUNDLE_TIME_MILLS.defaultValue());
        long expectedBundleTime = 100L;
        configuration.setLong(PythonOptions.MAX_BUNDLE_TIME_MILLS, 100L);
        long actualBundleSize = configuration.getLong(PythonOptions.MAX_BUNDLE_TIME_MILLS);
        Assertions.assertThat((long)actualBundleSize).isEqualTo(100L);
    }

    @Test
    void testArrowBatchSize() {
        Configuration configuration = new Configuration();
        int defaultArrowBatchSize = configuration.getInteger(PythonOptions.MAX_ARROW_BATCH_SIZE);
        Assertions.assertThat((int)defaultArrowBatchSize).isEqualTo(PythonOptions.MAX_ARROW_BATCH_SIZE.defaultValue());
        int expectedArrowBatchSize = 100;
        configuration.setInteger(PythonOptions.MAX_ARROW_BATCH_SIZE, 100);
        int actualArrowBatchSize = configuration.getInteger(PythonOptions.MAX_ARROW_BATCH_SIZE);
        Assertions.assertThat((int)actualArrowBatchSize).isEqualTo(100);
    }

    @Test
    void testPythonMetricEnabled() {
        Configuration configuration = new Configuration();
        boolean isMetricEnabled = configuration.getBoolean(PythonOptions.PYTHON_METRIC_ENABLED);
        Assertions.assertThat((boolean)isMetricEnabled).isEqualTo(PythonOptions.PYTHON_METRIC_ENABLED.defaultValue());
        boolean expectedIsMetricEnabled = false;
        configuration.setBoolean(PythonOptions.PYTHON_METRIC_ENABLED, false);
        boolean actualIsMetricEnabled = configuration.getBoolean(PythonOptions.PYTHON_METRIC_ENABLED);
        Assertions.assertThat((boolean)actualIsMetricEnabled).isEqualTo(false);
    }

    @Test
    void testPythonProfileEnabled() {
        Configuration configuration = new Configuration();
        boolean isProfileEnabled = configuration.getBoolean(PythonOptions.PYTHON_PROFILE_ENABLED);
        Assertions.assertThat((boolean)isProfileEnabled).isEqualTo(PythonOptions.PYTHON_PROFILE_ENABLED.defaultValue());
        boolean expectedIsProfileEnabled = true;
        configuration.setBoolean(PythonOptions.PYTHON_PROFILE_ENABLED, true);
        boolean actualIsProfileEnabled = configuration.getBoolean(PythonOptions.PYTHON_PROFILE_ENABLED);
        Assertions.assertThat((boolean)actualIsProfileEnabled).isEqualTo(true);
    }

    @Test
    void testPythonFiles() {
        Configuration configuration = new Configuration();
        Optional defaultPythonFiles = configuration.getOptional(PythonOptions.PYTHON_FILES);
        Assertions.assertThat((Optional)defaultPythonFiles).isEmpty();
        String expectedPythonFiles = "tmp_dir/test1.py,tmp_dir/test2.py";
        configuration.set(PythonOptions.PYTHON_FILES, (Object)"tmp_dir/test1.py,tmp_dir/test2.py");
        String actualPythonFiles = (String)configuration.get(PythonOptions.PYTHON_FILES);
        Assertions.assertThat((String)actualPythonFiles).isEqualTo("tmp_dir/test1.py,tmp_dir/test2.py");
    }

    @Test
    void testPythonRequirements() {
        Configuration configuration = new Configuration();
        Optional defaultPythonRequirements = configuration.getOptional(PythonOptions.PYTHON_REQUIREMENTS);
        Assertions.assertThat((Optional)defaultPythonRequirements).isEmpty();
        String expectedPythonRequirements = "tmp_dir/requirements.txt#tmp_dir/cache";
        configuration.set(PythonOptions.PYTHON_REQUIREMENTS, (Object)"tmp_dir/requirements.txt#tmp_dir/cache");
        String actualPythonRequirements = (String)configuration.get(PythonOptions.PYTHON_REQUIREMENTS);
        Assertions.assertThat((String)actualPythonRequirements).isEqualTo("tmp_dir/requirements.txt#tmp_dir/cache");
    }

    @Test
    void testPythonArchives() {
        Configuration configuration = new Configuration();
        Optional defaultPythonArchives = configuration.getOptional(PythonOptions.PYTHON_ARCHIVES);
        Assertions.assertThat((Optional)defaultPythonArchives).isEmpty();
        String expectedPythonArchives = "tmp_dir/py37.zip#venv,tmp_dir/data.zip";
        configuration.set(PythonOptions.PYTHON_ARCHIVES, (Object)"tmp_dir/py37.zip#venv,tmp_dir/data.zip");
        String actualPythonArchives = (String)configuration.get(PythonOptions.PYTHON_ARCHIVES);
        Assertions.assertThat((String)actualPythonArchives).isEqualTo("tmp_dir/py37.zip#venv,tmp_dir/data.zip");
    }

    @Test
    void testPythonExecutable() {
        Configuration configuration = new Configuration();
        Optional defaultPythonExecutable = configuration.getOptional(PythonOptions.PYTHON_EXECUTABLE);
        Assertions.assertThat((Optional)defaultPythonExecutable).isEmpty();
        String expectedPythonExecutable = "venv/py37/bin/python";
        configuration.set(PythonOptions.PYTHON_EXECUTABLE, (Object)"venv/py37/bin/python");
        String actualPythonExecutable = (String)configuration.get(PythonOptions.PYTHON_EXECUTABLE);
        Assertions.assertThat((String)actualPythonExecutable).isEqualTo("venv/py37/bin/python");
    }

    @Test
    void testPythonClientExecutable() {
        Configuration configuration = new Configuration();
        Optional defaultPythonClientExecutable = configuration.getOptional(PythonOptions.PYTHON_CLIENT_EXECUTABLE);
        Assertions.assertThat((Optional)defaultPythonClientExecutable).isEmpty();
        String expectedPythonClientExecutable = "tmp_dir/test1.py,tmp_dir/test2.py";
        configuration.set(PythonOptions.PYTHON_CLIENT_EXECUTABLE, (Object)"tmp_dir/test1.py,tmp_dir/test2.py");
        String actualPythonClientExecutable = (String)configuration.get(PythonOptions.PYTHON_CLIENT_EXECUTABLE);
        Assertions.assertThat((String)actualPythonClientExecutable).isEqualTo("tmp_dir/test1.py,tmp_dir/test2.py");
    }

    @Test
    void testPythonSystemEnvEnabled() {
        Configuration configuration = new Configuration();
        boolean isSystemEnvEnabled = configuration.getBoolean(PythonOptions.PYTHON_SYSTEMENV_ENABLED);
        Assertions.assertThat((boolean)isSystemEnvEnabled).isEqualTo(PythonOptions.PYTHON_SYSTEMENV_ENABLED.defaultValue());
        boolean expectedIsSystemEnvEnabled = false;
        configuration.setBoolean(PythonOptions.PYTHON_SYSTEMENV_ENABLED, false);
        boolean actualIsSystemEnvEnabled = configuration.getBoolean(PythonOptions.PYTHON_SYSTEMENV_ENABLED);
        Assertions.assertThat((boolean)actualIsSystemEnvEnabled).isEqualTo(false);
    }
}

