/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.env.process;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.python.env.PythonDependencyInfo;
import org.apache.flink.python.env.process.ProcessPythonEnvironmentManager;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class ProcessPythonEnvironmentManagerTest {
    private static String tmpDir;
    private static boolean isUnix;

    ProcessPythonEnvironmentManagerTest() {
    }

    @BeforeAll
    static void prepareTempDirectory() throws IOException {
        FileOutputStream out;
        Serializable fileInDirs;
        int i;
        File tmpFile = File.createTempFile("process_environment_manager_test", "");
        if (!tmpFile.delete() || !tmpFile.mkdirs()) {
            throw new IOException("Create temp directory: " + tmpFile.getAbsolutePath() + " failed!");
        }
        tmpDir = tmpFile.getAbsolutePath();
        for (i = 0; i < 6; ++i) {
            File distributedFile = new File(tmpDir, "file" + i);
            try (FileOutputStream out2 = new FileOutputStream(distributedFile);){
                out2.write(i);
                continue;
            }
        }
        for (i = 0; i < 2; ++i) {
            File distributedDirectory = new File(tmpDir, "dir" + i);
            if (distributedDirectory.mkdirs()) {
                for (int j = 0; j < 2; ++j) {
                    fileInDirs = new File(tmpDir, "dir" + i + File.separator + "file" + j);
                    out = new FileOutputStream((File)fileInDirs);
                    Throwable throwable = null;
                    try {
                        out.write(i);
                        out.write(j);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                continue;
            }
            throw new IOException("Create temp dir: " + distributedDirectory.getAbsolutePath() + " failed!");
        }
        isUnix = OperatingSystem.isFreeBSD() || OperatingSystem.isLinux() || OperatingSystem.isMac() || OperatingSystem.isSolaris();
        for (i = 0; i < 2; ++i) {
            Object zipfile1;
            File zipFile = new File(tmpDir, "zip" + i);
            ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));
            fileInDirs = null;
            try {
                ZipArchiveEntry zipfile0 = new ZipArchiveEntry("zipDir" + i + "/zipfile0");
                zipfile0.setUnixMode(457);
                zipOut.putArchiveEntry((ArchiveEntry)zipfile0);
                zipOut.write(new byte[]{1, 1, 1, 1, 1});
                zipOut.closeArchiveEntry();
                zipfile1 = new ZipArchiveEntry("zipDir" + i + "/zipfile1");
                zipfile1.setUnixMode(420);
                zipOut.putArchiveEntry((ArchiveEntry)zipfile1);
                zipOut.write(new byte[]{2, 2, 2, 2, 2});
                zipOut.closeArchiveEntry();
            }
            catch (Throwable zipfile0) {
                fileInDirs = zipfile0;
                throw zipfile0;
            }
            finally {
                if (zipOut != null) {
                    if (fileInDirs != null) {
                        try {
                            zipOut.close();
                        }
                        catch (Throwable zipfile0) {
                            ((Throwable)fileInDirs).addSuppressed(zipfile0);
                        }
                    } else {
                        zipOut.close();
                    }
                }
            }
            File zipExpected = new File(String.join((CharSequence)File.separator, tmpDir, "zipExpected" + i, "zipDir" + i));
            if (!zipExpected.mkdirs()) {
                throw new IOException("Create temp dir: " + zipExpected.getAbsolutePath() + " failed!");
            }
            File zipfile0 = new File(zipExpected, "zipfile0");
            out = new FileOutputStream(zipfile0);
            zipfile1 = null;
            try {
                out.write(new byte[]{1, 1, 1, 1, 1});
            }
            catch (Throwable throwable) {
                zipfile1 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (zipfile1 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)zipfile1).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            File zipfile12 = new File(zipExpected, "zipfile1");
            try (FileOutputStream out3 = new FileOutputStream(zipfile12);){
                out3.write(new byte[]{2, 2, 2, 2, 2});
            }
            if (!isUnix) continue;
            if (!(zipfile0.setReadable(true, true) && zipfile0.setWritable(true, true) && zipfile0.setExecutable(true))) {
                throw new IOException("Set unixmode 711 to temp file: " + zipfile0.getAbsolutePath() + "failed!");
            }
            if (zipfile12.setReadable(true) && zipfile12.setWritable(true, true) && zipfile12.setExecutable(false)) continue;
            throw new IOException("Set unixmode 644 to temp file: " + zipfile12.getAbsolutePath() + "failed!");
        }
    }

    @AfterAll
    static void cleanTempDirectory() {
        if (tmpDir != null) {
            org.apache.flink.util.FileUtils.deleteDirectoryQuietly((File)new File(tmpDir));
            tmpDir = null;
        }
    }

    @Test
    void testPythonFiles() throws Exception {
        LinkedHashMap<String, String> pythonFiles = new LinkedHashMap<String, String>();
        pythonFiles.put(String.join((CharSequence)File.separator, tmpDir, "zip0"), "test_zip.zip");
        pythonFiles.put(String.join((CharSequence)File.separator, tmpDir, "file1"), "test_file1.py");
        pythonFiles.put(String.join((CharSequence)File.separator, tmpDir, "file2"), "test_file2.egg");
        pythonFiles.put(String.join((CharSequence)File.separator, tmpDir, "dir0"), "test_dir");
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(pythonFiles, null, null, new HashMap(), "python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            String baseDir = environmentManager.getBaseDirectory();
            Map environmentVariable = environmentManager.getPythonEnv();
            CharSequence[] expectedUserPythonPaths = new String[]{String.join((CharSequence)File.separator, baseDir, "python-files", "zip0", "test_zip"), String.join((CharSequence)File.separator, baseDir, "python-files", "file1"), String.join((CharSequence)File.separator, baseDir, "python-files", "file2", "test_file2.egg"), String.join((CharSequence)File.separator, baseDir, "python-files", "dir0", "test_dir")};
            String expectedPythonPath = String.join((CharSequence)File.pathSeparator, expectedUserPythonPaths);
            Assertions.assertThat((String)((String)environmentVariable.get("PYTHONPATH"))).isEqualTo(expectedPythonPath);
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "file1")), new File(String.join((CharSequence)File.separator, baseDir, "python-files", "file1", "test_file1.py")));
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "zipExpected0")), new File(String.join((CharSequence)File.separator, baseDir, "python-files", "zip0", "test_zip")));
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "file2")), new File(String.join((CharSequence)File.separator, baseDir, "python-files", "file2", "test_file2.egg")));
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "dir0")), new File(String.join((CharSequence)File.separator, baseDir, "python-files", "dir0", "test_dir")));
        }
    }

    @Test
    void testRequirements() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), String.join((CharSequence)File.separator, tmpDir, "file0"), String.join((CharSequence)File.separator, tmpDir, "dir0"), new HashMap(), "python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            File baseDirectory = new File(tmpDir, "python-dist-" + UUID.randomUUID().toString());
            if (!baseDirectory.mkdirs()) {
                throw new IOException("Could not find a unique directory name in '" + tmpDir + "' for storing the generated files of python dependency.");
            }
            String tmpBase = baseDirectory.getAbsolutePath();
            Map environmentVariable = environmentManager.constructEnvironmentVariables(tmpBase);
            HashMap<String, String> expected = new HashMap<String, String>();
            expected.put("python", "python");
            expected.put("BOOT_LOG_DIR", tmpBase);
            expected.put("PYFLINK_GATEWAY_DISABLED", "true");
            expected.put("_PYTHON_REQUIREMENTS_FILE", String.join((CharSequence)File.separator, tmpDir, "file0"));
            expected.put("_PYTHON_REQUIREMENTS_CACHE", String.join((CharSequence)File.separator, tmpDir, "dir0"));
            expected.put("_PYTHON_REQUIREMENTS_INSTALL_DIR", String.join((CharSequence)File.separator, tmpBase, "python-requirements"));
            Assertions.assertThat((Map)environmentVariable).isEqualTo(expected);
        }
    }

    @Test
    void testArchives() throws Exception {
        LinkedHashMap<String, String> archives = new LinkedHashMap<String, String>();
        archives.put(String.join((CharSequence)File.separator, tmpDir, "zip0"), "py27.zip");
        archives.put(String.join((CharSequence)File.separator, tmpDir, "zip1"), "py37");
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, archives, "python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            String tmpBase = environmentManager.getBaseDirectory();
            Map environmentVariable = environmentManager.getPythonEnv();
            Map<String, String> expected = ProcessPythonEnvironmentManagerTest.getBasicExpectedEnv(environmentManager);
            expected.put("_PYTHON_WORKING_DIR", String.join((CharSequence)File.separator, tmpBase, "python-archives"));
            Assertions.assertThat((Map)environmentVariable).isEqualTo(expected);
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "zipExpected0")), new File(String.join((CharSequence)File.separator, tmpBase, "python-archives", "py27.zip")), true);
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "zipExpected1")), new File(String.join((CharSequence)File.separator, tmpBase, "python-archives", "py37")), true);
        }
    }

    @Test
    void testPythonExecutable() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "/usr/local/bin/python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            Map environmentVariable = environmentManager.getPythonEnv();
            Map<String, String> expected = ProcessPythonEnvironmentManagerTest.getBasicExpectedEnv(environmentManager);
            expected.put("python", "/usr/local/bin/python");
            Assertions.assertThat((Map)environmentVariable).isEqualTo(expected);
        }
    }

    @Test
    void testCreateRetrievalToken() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "python");
        HashMap<String, String> sysEnv = new HashMap<String, String>();
        sysEnv.put("FLINK_HOME", "/flink");
        try (ProcessPythonEnvironmentManager environmentManager = new ProcessPythonEnvironmentManager(dependencyInfo, new String[]{tmpDir}, sysEnv, new JobID());){
            environmentManager.open();
            String retrievalToken = environmentManager.createRetrievalToken();
            File retrievalTokenFile = new File(retrievalToken);
            byte[] content = new byte[(int)retrievalTokenFile.length()];
            try (DataInputStream input = new DataInputStream(new FileInputStream(retrievalToken));){
                input.readFully(content);
            }
            Assertions.assertThat((String)new String(content)).isEqualTo("{\"manifest\": {}}");
        }
    }

    @Test
    void testSetLogDirectory() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "python");
        try (ProcessPythonEnvironmentManager environmentManager = new ProcessPythonEnvironmentManager(dependencyInfo, new String[]{tmpDir}, new HashMap(), new JobID());){
            environmentManager.open();
            Map env = environmentManager.constructEnvironmentVariables(environmentManager.getBaseDirectory());
            Map<String, String> expected = ProcessPythonEnvironmentManagerTest.getBasicExpectedEnv(environmentManager);
            expected.put("BOOT_LOG_DIR", environmentManager.getBaseDirectory());
            Assertions.assertThat((Map)env).isEqualTo(expected);
        }
    }

    @Test
    void testOpenClose() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            environmentManager.createRetrievalToken();
            String tmpBase = environmentManager.getBaseDirectory();
            Assertions.assertThat((File)new File(tmpBase)).isDirectory();
            environmentManager.close();
            Assertions.assertThat((File)new File(tmpBase)).doesNotExist();
        }
    }

    private static void assertFileEquals(File expectedFile, File actualFile) throws IOException, NoSuchAlgorithmException {
        ProcessPythonEnvironmentManagerTest.assertFileEquals(expectedFile, actualFile, false);
    }

    private static void assertFileEquals(File expectedFile, File actualFile, boolean checkUnixMode) throws IOException, NoSuchAlgorithmException {
        BasicFileAttributes expectedFileAttributes;
        Assertions.assertThat((File)actualFile).exists();
        Assertions.assertThat((File)expectedFile).exists();
        if (expectedFile.getAbsolutePath().equals(actualFile.getAbsolutePath())) {
            return;
        }
        if (isUnix && checkUnixMode) {
            Set<PosixFilePermission> expectedPerm = Files.getPosixFilePermissions(Paths.get(expectedFile.toURI()), new LinkOption[0]);
            Set<PosixFilePermission> actualPerm = Files.getPosixFilePermissions(Paths.get(actualFile.toURI()), new LinkOption[0]);
            Assertions.assertThat(actualPerm).isEqualTo(expectedPerm);
        }
        if ((expectedFileAttributes = Files.readAttributes(expectedFile.toPath(), BasicFileAttributes.class, new LinkOption[0])).isDirectory()) {
            Assertions.assertThat((File)actualFile).isDirectory();
            String[] expectedSubFiles = expectedFile.list();
            Assertions.assertThat((Object[])actualFile.list()).isEqualTo((Object)expectedSubFiles);
            if (expectedSubFiles != null) {
                for (String fileName : expectedSubFiles) {
                    ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(expectedFile.getAbsolutePath(), fileName), new File(actualFile.getAbsolutePath(), fileName));
                }
            }
        } else {
            Assertions.assertThat((File)actualFile).hasSize(expectedFileAttributes.size());
            if (expectedFileAttributes.size() > 0L) {
                Assertions.assertThat((boolean)FileUtils.contentEquals((File)expectedFile, (File)actualFile)).isTrue();
            }
        }
    }

    private static Map<String, String> getBasicExpectedEnv(ProcessPythonEnvironmentManager environmentManager) {
        HashMap<String, String> map = new HashMap<String, String>();
        String tmpBase = environmentManager.getBaseDirectory();
        map.put("python", "python");
        map.put("BOOT_LOG_DIR", tmpBase);
        map.put("PYFLINK_GATEWAY_DISABLED", "true");
        return map;
    }

    private static ProcessPythonEnvironmentManager createBasicPythonEnvironmentManager(PythonDependencyInfo dependencyInfo) {
        return new ProcessPythonEnvironmentManager(dependencyInfo, new String[]{tmpDir}, new HashMap(), new JobID());
    }
}

