/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.metric.process;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.python.metric.process.FlinkMetricContainer;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricGroupTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class FlinkMetricContainerTest {
    @Mock
    private RuntimeContext runtimeContext;
    @Mock
    private OperatorMetricGroup metricGroup;
    private FlinkMetricContainer container;
    private static final List<String> DEFAULT_SCOPE_COMPONENTS = Arrays.asList("key", "value", "MetricGroupType.key", "MetricGroupType.value");
    private static final String DEFAULT_NAMESPACE = "[\"key\", \"value\", \"MetricGroupType.key\", \"MetricGroupType.value\"]";

    FlinkMetricContainerTest() {
    }

    @BeforeEach
    void beforeTest() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.runtimeContext.getMetricGroup()).thenReturn((Object)this.metricGroup);
        Mockito.when((Object)this.metricGroup.addGroup((String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)this.metricGroup);
        Mockito.when((Object)this.metricGroup.addGroup((String)Mockito.any())).thenReturn((Object)this.metricGroup);
        this.container = new FlinkMetricContainer((MetricGroup)this.runtimeContext.getMetricGroup());
    }

    @Test
    void testGetNameSpaceArray() {
        String json = DEFAULT_NAMESPACE;
        MetricKey key = MetricKey.create((String)"step", (MetricName)MetricName.named((String)json, (String)"name"));
        Assertions.assertThat((List)FlinkMetricContainer.getNameSpaceArray((MetricKey)key)).isEqualTo(DEFAULT_SCOPE_COMPONENTS);
    }

    @Test
    void testGetFlinkMetricIdentifierString() {
        MetricKey key = MetricKey.create((String)"step", (MetricName)MetricName.named((String)DEFAULT_NAMESPACE, (String)"name"));
        Assertions.assertThat((String)FlinkMetricContainer.getFlinkMetricIdentifierString((MetricKey)key)).isEqualTo("key.value.name");
    }

    @Test
    void testRegisterMetricGroup() {
        MetricKey key = MetricKey.create((String)"step", (MetricName)MetricName.named((String)DEFAULT_NAMESPACE, (String)"name"));
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup(registry), "root");
        MetricGroup metricGroup = FlinkMetricContainer.registerMetricGroup((MetricKey)key, (MetricGroup)root);
        Assertions.assertThat((Object[])metricGroup.getScopeComponents()).isEqualTo((Object)Arrays.asList("root", "key", "value").toArray());
    }

    @Test
    void testCounterMonitoringInfoUpdate() {
        SimpleCounter userCounter = new SimpleCounter();
        Mockito.when((Object)this.metricGroup.counter("myCounter")).thenReturn((Object)userCounter);
        MetricsApi.MonitoringInfo userMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", DEFAULT_NAMESPACE).setLabel("NAME", "myCounter").setLabel("PTRANSFORM", "anyPTransform").setInt64SumValue(111L).build();
        Assertions.assertThat((long)userCounter.getCount()).isEqualTo(0L);
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userMonitoringInfo));
        Assertions.assertThat((long)userCounter.getCount()).isEqualTo(111L);
    }

    @Test
    void testMeterMonitoringInfoUpdate() {
        MeterView userMeter = new MeterView((Counter)new SimpleCounter());
        Mockito.when((Object)this.metricGroup.meter((String)Matchers.eq((Object)"myMeter"), (Meter)Mockito.any(Meter.class))).thenReturn((Object)userMeter);
        String namespace = "[\"key\", \"value\", \"MetricGroupType.key\", \"MetricGroupType.value\", \"60\"]";
        MetricsApi.MonitoringInfo userMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", namespace).setLabel("NAME", "myMeter").setLabel("PTRANSFORM", "anyPTransform").setInt64SumValue(111L).build();
        Assertions.assertThat((long)userMeter.getCount()).isEqualTo(0L);
        Assertions.assertThat((double)userMeter.getRate()).isEqualTo(0.0);
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userMonitoringInfo));
        userMeter.update();
        Assertions.assertThat((long)userMeter.getCount()).isEqualTo(111L);
        Assertions.assertThat((double)userMeter.getRate()).isEqualTo(1.85);
    }

    @Test
    void testGaugeMonitoringInfoUpdate() {
        MetricsApi.MonitoringInfo userMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", DEFAULT_NAMESPACE).setLabel("NAME", "myGauge").setLabel("PTRANSFORM", "anyPTransform").setInt64LatestValue(GaugeData.create((long)111L)).build();
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userMonitoringInfo));
        ((OperatorMetricGroup)Mockito.verify((Object)this.metricGroup)).gauge((String)Matchers.eq((Object)"myGauge"), (Gauge)ArgumentMatchers.argThat(argument -> {
            Long actual = argument.getValue();
            return actual.equals(111L);
        }));
    }

    @Test
    void testDistributionMonitoringInfoUpdate() {
        MetricsApi.MonitoringInfo userMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_DISTRIBUTION_INT64).setLabel("NAMESPACE", DEFAULT_NAMESPACE).setLabel("NAME", "myDistribution").setLabel("PTRANSFORM", "anyPTransform").setInt64DistributionValue(DistributionData.create((long)30L, (long)10L, (long)1L, (long)5L)).build();
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userMonitoringInfo));
        ((OperatorMetricGroup)Mockito.verify((Object)this.metricGroup)).gauge((String)Matchers.eq((Object)"myDistribution"), (Gauge)ArgumentMatchers.argThat(argument -> {
            DistributionResult actual = argument.getValue();
            DistributionResult expected = DistributionResult.create((long)30L, (long)10L, (long)1L, (long)5L);
            return actual.equals(expected);
        }));
    }
}

